/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.impl;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;

public class FutureLockImpl<R>
implements Future<R> {
    private final ReentrantLock lock;
    private boolean isDone;
    private CountDownLatch latch;
    private boolean isCancelled;
    private Throwable failure;
    protected R result;

    public FutureLockImpl() {
        this(new ReentrantLock());
    }

    public FutureLockImpl(ReentrantLock lock) {
        this.lock = lock;
        this.latch = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R getResult() {
        try {
            this.lock.lock();
            R r = this.result;
            return r;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(R result) {
        try {
            this.lock.lock();
            this.result = result;
            this.notifyHaveResult();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            this.lock.lock();
            this.isCancelled = true;
            this.notifyHaveResult();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        try {
            this.lock.lock();
            boolean bl = this.isCancelled;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        try {
            this.lock.lock();
            boolean bl = this.isDone;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R get() throws InterruptedException, ExecutionException {
        this.latch.await();
        try {
            this.lock.lock();
            if (this.isCancelled) {
                throw new CancellationException();
            }
            if (this.failure != null) {
                throw new ExecutionException(this.failure);
            }
            R r = this.result;
            return r;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean isTimeOut = this.latch.await(timeout, unit);
        try {
            this.lock.lock();
            if (!isTimeOut) {
                if (this.isCancelled) {
                    throw new CancellationException();
                }
                if (this.failure != null) {
                    throw new ExecutionException(this.failure);
                }
                R r = this.result;
                return r;
            }
            throw new TimeoutException();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failure(Throwable failure) {
        try {
            this.lock.lock();
            this.failure = failure;
            this.notifyHaveResult();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void notifyHaveResult() {
        this.isDone = true;
        this.latch.countDown();
    }
}

