/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Connection;
import com.sun.grizzly.Context;
import com.sun.grizzly.Grizzly;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.PostProcessor;
import com.sun.grizzly.Processor;
import com.sun.grizzly.ProcessorResult;
import com.sun.grizzly.Transport;
import java.io.IOException;
import java.util.logging.Level;

public class ProcessorRunnable
implements Runnable {
    private Context context;
    private IOEvent ioEvent;
    private Connection connection;
    private Processor processor;
    private PostProcessor postProcessor;
    private boolean isSuspended;

    public ProcessorRunnable(Context context) {
        this.context = context;
    }

    public ProcessorRunnable(IOEvent ioEvent, Connection connection, Processor processor, PostProcessor postProcessor) {
        this.ioEvent = ioEvent;
        this.connection = connection;
        this.processor = processor;
        this.postProcessor = postProcessor;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public IOEvent getIoEvent() {
        return this.ioEvent;
    }

    public void setIoEvent(IOEvent ioEvent) {
        this.ioEvent = ioEvent;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public PostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public void setPostProcessor(PostProcessor ioEventPostProcessor) {
        this.postProcessor = ioEventPostProcessor;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public void run() {
        if (this.context == null) {
            this.createContext();
            this.initContext();
        } else {
            this.initFromContext();
        }
        this.context.setProcessorRunnable(this);
        ProcessorResult result = null;
        try {
            if (!this.isSuspended) {
                this.processor.beforeProcess(this.context);
            }
            while ((result = this.processor.process(this.context)) != null && result.getStatus() == ProcessorResult.Status.RERUN) {
            }
            if (result == null || result.getStatus() != ProcessorResult.Status.TERMINATE) {
                this.postProcess(this.context, result);
            } else {
                this.isSuspended = true;
            }
        }
        catch (IOException e) {
            result = new ProcessorResult(ProcessorResult.Status.ERROR, e);
            this.postProcess(this.context, result);
            this.logException(this.context, e);
        }
        catch (Throwable t) {
            this.logException(this.context, t);
            this.postProcess(this.context, result);
            throw new RuntimeException(t);
        }
    }

    protected void createContext() {
        this.context = this.processor.context();
        if (this.context == null) {
            this.context = new Context();
        }
    }

    protected void initContext() {
        this.context.setIoEvent(this.ioEvent);
        this.context.setConnection(this.connection);
        this.context.setProcessor(this.processor);
        this.context.setPostProcessor(this.postProcessor);
    }

    private void initFromContext() {
        this.ioEvent = this.context.getIoEvent();
        this.connection = this.context.getConnection();
        this.processor = this.context.getProcessor();
        this.postProcessor = this.context.getPostProcessor();
    }

    private void postProcess(Context context, ProcessorResult result) {
        try {
            this.processor.afterProcess(context);
        }
        catch (IOException e) {
            this.logException(context, e);
        }
        PostProcessor ioEventPostProcessor = context.getPostProcessor();
        if (ioEventPostProcessor != null) {
            try {
                ioEventPostProcessor.process(result, context);
            }
            catch (IOException e) {
                this.logException(context, e);
            }
        }
        context.offerToPool();
    }

    private void logException(Context context, Throwable e) {
        Transport.State transportState = context.getConnection().getTransport().getState().getState(false);
        if (transportState != Transport.State.STOPPING && transportState != Transport.State.STOP) {
            Grizzly.logger.log(Level.WARNING, "Processor execution exception. Processor: " + this.processor + " Context: " + context, e);
        } else {
            Grizzly.logger.log(Level.FINE, "Processor execution exception, however transport was in the stopping phase: " + (Object)((Object)transportState) + " Processor: " + this.processor + " Context: " + context, e);
        }
    }
}

