/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Connection;
import com.sun.grizzly.Grizzly;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.PostProcessor;
import com.sun.grizzly.Processor;
import com.sun.grizzly.ProcessorRunnable;
import com.sun.grizzly.attributes.AttributeHolder;
import com.sun.grizzly.attributes.IndexedAttributeHolder;
import com.sun.grizzly.utils.ObjectPool;
import com.sun.grizzly.utils.PoolableObject;

public class Context
implements PoolableObject {
    private Connection connection;
    private IOEvent ioEvent;
    private Processor processor;
    private PostProcessor postProcessor;
    private AttributeHolder attributes;
    private ProcessorRunnable processorRunnable;
    private final ObjectPool<Context> parentPool;

    public Context() {
        this(null);
    }

    public Context(ObjectPool parentPool) {
        this.parentPool = parentPool;
    }

    public IOEvent getIoEvent() {
        return this.ioEvent;
    }

    public void setIoEvent(IOEvent ioEvent) {
        this.ioEvent = ioEvent;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public ProcessorRunnable getProcessorRunnable() {
        return this.processorRunnable;
    }

    public void setProcessorRunnable(ProcessorRunnable processorRunnable) {
        this.processorRunnable = processorRunnable;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public PostProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public void setPostProcessor(PostProcessor ioEventPostProcessor) {
        this.postProcessor = ioEventPostProcessor;
    }

    public AttributeHolder getAttributes() {
        return this.attributes;
    }

    public AttributeHolder obtainAttributes() {
        if (this.attributes == null) {
            if (this.connection == null) {
                throw new IllegalStateException("Can not obtain an attributes. Connection is not set for this context object!");
            }
            this.attributes = this.initializeAttributeHolder();
        }
        return this.attributes;
    }

    protected AttributeHolder initializeAttributeHolder() {
        return new IndexedAttributeHolder(this.connection.getTransport().getAttributeBuilder());
    }

    protected void setAttributes(AttributeHolder attributes) {
        this.attributes = attributes;
    }

    @Override
    public void prepare() {
        if (this.attributes == null) {
            this.attributes = new IndexedAttributeHolder(Grizzly.DEFAULT_ATTRIBUTE_BUILDER);
        }
    }

    @Override
    public void release() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
        this.processor = null;
        this.postProcessor = null;
        this.connection = null;
        this.ioEvent = IOEvent.NONE;
    }

    public void offerToPool() {
        if (this.parentPool != null) {
            this.parentPool.offer(this);
        }
    }
}

