/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Connection;
import com.sun.grizzly.Grizzly;
import com.sun.grizzly.TransformationException;
import com.sun.grizzly.TransformationResult;
import com.sun.grizzly.Transformer;
import com.sun.grizzly.attributes.Attribute;
import com.sun.grizzly.attributes.AttributeBuilder;
import com.sun.grizzly.attributes.AttributeHolder;
import com.sun.grizzly.attributes.AttributeStorage;
import com.sun.grizzly.memory.MemoryManager;

public abstract class AbstractTransformer<K, L>
implements Transformer<K, L> {
    protected static TransformationResult incompletedResult = new TransformationResult(TransformationResult.Status.INCOMPLED);
    protected AttributeBuilder attributeBuilder = Grizzly.DEFAULT_ATTRIBUTE_BUILDER;
    protected Attribute<K> inputBufferAttribute;
    protected Attribute<L> outputBufferAttribute;
    protected Attribute<TransformationResult<L>> lastResultAttribute;
    private MemoryManager memoryManager;

    public AbstractTransformer() {
        String namePrefix = this.getClass().getName();
        this.inputBufferAttribute = this.attributeBuilder.createAttribute(namePrefix + ".inputBuffer");
        this.outputBufferAttribute = this.attributeBuilder.createAttribute(namePrefix + ".outputBuffer");
        this.lastResultAttribute = this.attributeBuilder.createAttribute(namePrefix + ".lastResult");
    }

    @Override
    public TransformationResult<L> transform(AttributeStorage storage) throws TransformationException {
        return this.transform(storage, this.getInput(storage), this.getOutput(storage));
    }

    @Override
    public K getInput(AttributeStorage storage) {
        return this.inputBufferAttribute.get(storage);
    }

    @Override
    public void setInput(AttributeStorage storage, K input) {
        this.inputBufferAttribute.set(storage, input);
    }

    @Override
    public L getOutput(AttributeStorage storage) {
        return this.outputBufferAttribute.get(storage);
    }

    @Override
    public void setOutput(AttributeStorage storage, L output) {
        this.outputBufferAttribute.set(storage, output);
    }

    @Override
    public TransformationResult<L> getLastResult(AttributeStorage storage) {
        return this.lastResultAttribute.get(storage);
    }

    @Override
    public AttributeHolder getProperties(AttributeStorage storage) {
        return storage.getAttributes();
    }

    @Override
    public void hibernate(AttributeStorage storage) {
    }

    @Override
    public void release(AttributeStorage storage) {
        this.inputBufferAttribute.remove(storage);
        this.outputBufferAttribute.remove(storage);
        this.lastResultAttribute.remove(storage);
    }

    protected MemoryManager obtainMemoryManager(AttributeStorage storage) {
        if (this.memoryManager != null) {
            return this.memoryManager;
        }
        if (storage instanceof Connection) {
            Connection connection = (Connection)storage;
            return connection.getTransport().getMemoryManager();
        }
        return null;
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public void setMemoryManager(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    public static <T> T getValue(AttributeStorage storage, Attribute<T> attribute, T defaultValue) {
        T value = attribute.get(storage);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

