/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Connection;
import com.sun.grizzly.Processor;
import com.sun.grizzly.ProcessorSelector;
import com.sun.grizzly.SocketConnectorHandler;
import com.sun.grizzly.Transport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Future;

public abstract class AbstractSocketConnectorHandler
implements SocketConnectorHandler {
    protected Transport transport;
    protected Processor defaultProcessor;
    protected ProcessorSelector defaultProcessorSelector;

    public AbstractSocketConnectorHandler(Transport transport) {
        this.transport = transport;
        this.defaultProcessor = transport.getProcessor();
        this.defaultProcessorSelector = transport.getProcessorSelector();
    }

    @Override
    public Future<Connection> connect(String host, int port) throws IOException {
        return this.connect(new InetSocketAddress(host, port));
    }

    @Override
    public Future<Connection> connect(SocketAddress remoteAddress) throws IOException {
        return this.connect(remoteAddress, null);
    }

    @Override
    public abstract Future<Connection> connect(SocketAddress var1, SocketAddress var2) throws IOException;

    @Override
    public Processor getProcessor() {
        return this.defaultProcessor;
    }

    @Override
    public void setProcessor(Processor defaultProcessor) {
        this.defaultProcessor = defaultProcessor;
    }

    @Override
    public ProcessorSelector getProcessorSelector() {
        return this.defaultProcessorSelector;
    }

    @Override
    public void setProcessorSelector(ProcessorSelector defaultProcessorSelector) {
        this.defaultProcessorSelector = defaultProcessorSelector;
    }
}

