/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Controller;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import java.nio.channels.SelectionKey;

public class SelectorHandlerRunner
implements Runnable {
    private final SelectorHandler selectorHandler;
    private final Controller controller;

    public SelectorHandlerRunner(Controller controller, SelectorHandler selectorHandler) {
        this.controller = controller;
        this.selectorHandler = selectorHandler;
    }

    public SelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean firstTimeSelect = true;
        try {
            while (this.controller.state == Controller.State.STARTED && this.controller.state == Controller.State.STARTED) {
                this.controller.doSelect(this.selectorHandler);
                if (!firstTimeSelect) continue;
                firstTimeSelect = false;
                this.controller.notifyReady();
            }
            SelectionKeyHandler selectionKeyHandler = this.selectorHandler.getSelectionKeyHandler();
            for (SelectionKey selectionKey : this.selectorHandler.keys()) {
                selectionKeyHandler.close(selectionKey);
            }
            this.selectorHandler.shutdown();
        }
        finally {
            this.controller.notifyStopped();
        }
    }
}

