/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.html_basic.BaseTableRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRenderer
extends BaseTableRenderer {
    private static final String[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.DATATABLE);

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        UIData data = (UIData)component;
        data.setRowIndex(-1);
        ResponseWriter writer = context.getResponseWriter();
        this.renderTableStart(context, component, writer, ATTRIBUTES);
        this.renderCaption(context, (UIComponent)data, writer);
        this.renderColumnGroups(context, (UIComponent)data);
        this.renderHeader(context, component, writer);
        this.renderFooter(context, component, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncodeChildren(component)) {
            return;
        }
        UIData data = (UIData)component;
        ResponseWriter writer = context.getResponseWriter();
        int processed = 0;
        int rowIndex = data.getFirst() - 1;
        int rows = data.getRows();
        List<Integer> bodyRows = this.getBodyRows(data);
        boolean hasBodyRows = bodyRows != null && !bodyRows.isEmpty();
        boolean wroteTableBody = false;
        if (!hasBodyRows) {
            this.renderTableBodyStart(component, writer);
        }
        while (rows <= 0 || ++processed <= rows) {
            data.setRowIndex(++rowIndex);
            if (!data.isRowAvailable()) break;
            if (hasBodyRows && bodyRows.contains(data.getRowIndex())) {
                if (wroteTableBody) {
                    writer.endElement("tbody");
                }
                writer.startElement("tbody", (UIComponent)data);
                wroteTableBody = true;
            }
            this.renderRowStart(component, writer);
            this.renderRow(context, component, null, writer);
            this.renderRowEnd(component, writer);
        }
        this.renderTableBodyEnd(component, writer);
        data.setRowIndex(-1);
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        UIData data = (UIData)component;
        this.clearMetaInfo((UIComponent)data);
        data.setRowIndex(-1);
        this.renderTableEnd(component, context.getResponseWriter());
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    private List<Integer> getBodyRows(UIData data) {
        String[] rows;
        ArrayList<Integer> result = null;
        String bodyRows = (String)data.getAttributes().get("bodyrows");
        if (bodyRows != null && (rows = Util.split(bodyRows, ",")) != null) {
            result = new ArrayList<Integer>(rows.length);
            for (String curRow : rows) {
                result.add(Integer.valueOf(curRow));
            }
        }
        return result;
    }

    protected void renderColumnGroups(FacesContext context, UIComponent table) throws IOException {
        UIComponent colGroups = this.getFacet(table, "colgroups");
        if (colGroups != null) {
            this.encodeRecursive(context, colGroups);
        }
    }

    @Override
    protected void renderFooter(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(table);
        UIComponent footer = this.getFacet(table, "footer");
        String footerClass = (String)table.getAttributes().get("footerClass");
        if (footer != null || info.hasFooterFacets) {
            writer.startElement("tfoot", table);
            writer.writeText((Object)"\n", table, null);
        }
        if (info.hasFooterFacets) {
            writer.startElement("tr", table);
            writer.writeText((Object)"\n", table, null);
            for (UIColumn column : info.columns) {
                String columnFooterClass = (String)column.getAttributes().get("footerClass");
                writer.startElement("td", (UIComponent)column);
                if (columnFooterClass != null) {
                    writer.writeAttribute("class", (Object)columnFooterClass, "columnFooterClass");
                } else if (footerClass != null) {
                    writer.writeAttribute("class", (Object)footerClass, "footerClass");
                }
                UIComponent facet = this.getFacet((UIComponent)column, "footer");
                if (facet != null) {
                    this.encodeRecursive(context, facet);
                }
                writer.endElement("td");
                writer.writeText((Object)"\n", table, null);
            }
            this.renderRowEnd(table, writer);
        }
        if (footer != null) {
            writer.startElement("tr", footer);
            writer.startElement("td", footer);
            if (footerClass != null) {
                writer.writeAttribute("class", (Object)footerClass, "footerClass");
            }
            writer.writeAttribute("colspan", (Object)String.valueOf(info.columns.size()), null);
            this.encodeRecursive(context, footer);
            writer.endElement("td");
            this.renderRowEnd(table, writer);
        }
        if (footer != null || info.hasFooterFacets) {
            writer.endElement("tfoot");
            writer.writeText((Object)"\n", table, null);
        }
    }

    @Override
    protected void renderHeader(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(table);
        UIComponent header = this.getFacet(table, "header");
        String headerClass = (String)table.getAttributes().get("headerClass");
        if (header != null || info.hasHeaderFacets) {
            writer.startElement("thead", table);
            writer.writeText((Object)"\n", table, null);
        }
        if (header != null) {
            writer.startElement("tr", header);
            writer.startElement("th", header);
            if (headerClass != null) {
                writer.writeAttribute("class", (Object)headerClass, "headerClass");
            }
            writer.writeAttribute("colspan", (Object)String.valueOf(info.columns.size()), null);
            writer.writeAttribute("scope", (Object)"colgroup", null);
            this.encodeRecursive(context, header);
            writer.endElement("th");
            this.renderRowEnd(table, writer);
        }
        if (info.hasHeaderFacets) {
            writer.startElement("tr", table);
            writer.writeText((Object)"\n", table, null);
            for (UIColumn column : info.columns) {
                String columnHeaderClass = (String)column.getAttributes().get("headerClass");
                writer.startElement("th", (UIComponent)column);
                if (columnHeaderClass != null) {
                    writer.writeAttribute("class", (Object)columnHeaderClass, "columnHeaderClass");
                } else if (headerClass != null) {
                    writer.writeAttribute("class", (Object)headerClass, "headerClass");
                }
                writer.writeAttribute("scope", (Object)"col", null);
                UIComponent facet = this.getFacet((UIComponent)column, "header");
                if (facet != null) {
                    this.encodeRecursive(context, facet);
                }
                writer.endElement("th");
                writer.writeText((Object)"\n", table, null);
            }
            this.renderRowEnd(table, writer);
        }
        if (header != null || info.hasHeaderFacets) {
            writer.endElement("thead");
            writer.writeText((Object)"\n", table, null);
        }
    }

    @Override
    protected void renderRow(FacesContext context, UIComponent table, UIComponent child, ResponseWriter writer) throws IOException {
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(table);
        info.newRow();
        for (UIColumn column : info.columns) {
            boolean isRowHeader = Boolean.TRUE.equals(column.getAttributes().get("rowHeader"));
            if (isRowHeader) {
                writer.startElement("th", (UIComponent)column);
                writer.writeAttribute("scope", (Object)"row", null);
            } else {
                writer.startElement("td", (UIComponent)column);
            }
            String columnClass = info.getCurrentColumnClass();
            if (columnClass != null) {
                writer.writeAttribute("class", (Object)columnClass, "columnClasses");
            }
            Iterator<UIComponent> gkids = this.getChildren((UIComponent)column);
            while (gkids.hasNext()) {
                this.encodeRecursive(context, gkids.next());
            }
            if (isRowHeader) {
                writer.endElement("th");
            } else {
                writer.endElement("td");
            }
            writer.writeText((Object)"\n", table, null);
        }
    }
}

