/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.view.MultiViewHandler;
import com.sun.faces.application.view.ViewHandlingStrategy;
import com.sun.faces.application.view.WriteBehindStateWriter;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.Facelet;
import com.sun.faces.facelets.FaceletFactory;
import com.sun.faces.facelets.compiler.Compiler;
import com.sun.faces.facelets.compiler.SAXCompiler;
import com.sun.faces.facelets.impl.PageDeclarationLanguageImpl;
import com.sun.faces.facelets.tag.ui.UIDebug;
import com.sun.faces.facelets.util.DevTools;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.webapp.pdl.PageDeclarationLanguage;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class FaceletViewHandlingStrategy
extends ViewHandlingStrategy {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private FaceletFactory faceletFactory;
    private String[] extensionsArray;
    private String[] prefixesArray;

    public FaceletViewHandlingStrategy() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        ctx.getApplication().setPageDeclarationLanguage((PageDeclarationLanguage)new PageDeclarationLanguageImpl());
        this.initialize();
    }

    public boolean handlesViewId(String viewId) {
        if (viewId != null) {
            int i;
            if (this.extensionsArray == null && this.prefixesArray == null) {
                return viewId.endsWith(".xhtml");
            }
            if (this.extensionsArray != null) {
                for (i = 0; i < this.extensionsArray.length; ++i) {
                    String extension = this.extensionsArray[i];
                    if (!viewId.endsWith(extension)) continue;
                    return true;
                }
            }
            if (this.prefixesArray != null) {
                for (i = 0; i < this.prefixesArray.length; ++i) {
                    String prefix = this.prefixesArray[i];
                    if (!viewId.startsWith(prefix)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderView(FacesContext ctx, MultiViewHandler vh, UIViewRoot viewToRender) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Rendering View: " + viewToRender.getViewId());
        }
        WriteBehindStateWriter stateWriter = null;
        try {
            ResponseWriter origWriter;
            if (!FaceletViewHandlingStrategy.isViewPopulated(ctx, viewToRender)) {
                this.buildView(ctx, viewToRender);
            }
            if ((origWriter = ctx.getResponseWriter()) == null) {
                origWriter = this.createResponseWriter(ctx);
            }
            stateWriter = new WriteBehindStateWriter((Writer)origWriter, ctx, this.responseBufferSize);
            ResponseWriter writer = origWriter.cloneWithWriter((Writer)stateWriter);
            ctx.setResponseWriter(writer);
            writer.startDocument();
            viewToRender.encodeAll(ctx);
            writer.endDocument();
            writer.close();
            boolean writtenState = stateWriter.stateWritten();
            if (writtenState) {
                stateWriter.flushToWriter();
            }
        }
        catch (FileNotFoundException fnfe) {
            this.handleFaceletNotFound(ctx, vh, viewToRender.getViewId());
        }
        catch (Exception e) {
            this.handleRenderException(ctx, e);
        }
        finally {
            if (stateWriter != null) {
                stateWriter.release();
            }
        }
    }

    public UIViewRoot restoreView(FacesContext ctx, MultiViewHandler vh, String viewId) {
        if (UIDebug.debugRequest(ctx)) {
            return new UIViewRoot();
        }
        return super.restoreView(ctx, vh, viewId);
    }

    public UIViewRoot createView(FacesContext ctx, MultiViewHandler vh, String viewId) {
        UIViewRoot root = super.createView(ctx, vh, viewId);
        ctx.setViewRoot(root);
        if (root != null) {
            try {
                this.buildView(ctx, root);
            }
            catch (IOException ioe) {
                throw new FacesException((Throwable)ioe);
            }
        }
        return root;
    }

    protected static boolean isViewPopulated(FacesContext ctx, UIViewRoot viewToRender) {
        return ctx.getAttributes().containsKey(viewToRender.getViewId());
    }

    protected static void setViewPopulated(FacesContext ctx, UIViewRoot viewToRender) {
        ctx.getAttributes().put(viewToRender.getViewId(), Boolean.TRUE);
    }

    protected void initialize() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Initializing FaceletViewHandlingStrategy");
        }
        this.initializeMappings();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Initialization Successful");
        }
    }

    private void initializeMappings() {
        String viewMappings = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.FaceletsViewMappings);
        if (viewMappings != null && viewMappings.length() > 0) {
            String[] mappingsArray = Util.split(viewMappings, ";");
            ArrayList<String> extensionsList = new ArrayList<String>(mappingsArray.length);
            ArrayList<String> prefixesList = new ArrayList<String>(mappingsArray.length);
            for (int i = 0; i < mappingsArray.length; ++i) {
                String mapping = mappingsArray[i].trim();
                int mappingLength = mapping.length();
                if (mappingLength <= 1) continue;
                if (mapping.charAt(0) == '*') {
                    extensionsList.add(mapping.substring(1));
                    continue;
                }
                if (mapping.charAt(mappingLength - 1) != '*') continue;
                prefixesList.add(mapping.substring(0, mappingLength - 1));
            }
            this.extensionsArray = new String[extensionsList.size()];
            extensionsList.toArray(this.extensionsArray);
            this.prefixesArray = new String[prefixesList.size()];
            prefixesList.toArray(this.prefixesArray);
        }
    }

    protected Compiler createCompiler() {
        return new SAXCompiler();
    }

    protected void buildView(FacesContext ctx, UIViewRoot viewToRender) throws IOException {
        viewToRender.setViewId(viewToRender.getViewId());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Building View: " + viewToRender.getViewId());
        }
        if (this.faceletFactory == null) {
            ApplicationAssociate associate = ApplicationAssociate.getInstance(ctx.getExternalContext());
            this.faceletFactory = associate.getFaceletFactory();
            assert (this.faceletFactory != null);
        }
        RequestStateManager.set(ctx, "com.sun.faces.FACELET_FACTORY", this.faceletFactory);
        Facelet f = this.faceletFactory.getFacelet(viewToRender.getViewId());
        f.apply(ctx, (UIComponent)viewToRender);
        FaceletViewHandlingStrategy.setViewPopulated(ctx, viewToRender);
    }

    protected ResponseWriter createResponseWriter(FacesContext context) throws IOException {
        ExternalContext extContext = context.getExternalContext();
        RenderKit renderKit = context.getRenderKit();
        if (renderKit == null) {
            String id = context.getViewRoot().getRenderKitId();
            throw new IllegalStateException("No render kit was available for id \"" + id + "\"");
        }
        ServletResponse response = (ServletResponse)extContext.getResponse();
        if (this.responseBufferSizeSet) {
            response.setBufferSize(this.responseBufferSize);
        }
        String contentType = (String)extContext.getRequestMap().get("facelets.ContentType");
        String encoding = (String)extContext.getRequestMap().get("facelets.Encoding");
        ResponseWriter writer = renderKit.createResponseWriter((Writer)NullWriter.Instance, contentType, encoding);
        contentType = this.getResponseContentType(context, writer.getContentType());
        encoding = this.getResponseEncoding(context, writer.getCharacterEncoding());
        response.setContentType(contentType);
        response.setCharacterEncoding(encoding);
        writer = writer.cloneWithWriter((Writer)response.getWriter());
        return writer;
    }

    protected void handleRenderException(FacesContext context, Exception e) throws IOException {
        Object resp = context.getExternalContext().getResponse();
        if (LOGGER.isLoggable(Level.SEVERE)) {
            UIViewRoot root = context.getViewRoot();
            StringBuffer sb = new StringBuffer(64);
            sb.append("Error Rendering View");
            if (root != null) {
                sb.append('[');
                sb.append(root.getViewId());
                sb.append(']');
            }
            LOGGER.log(Level.SEVERE, sb.toString(), e);
        }
        if (this.associate.isDevModeEnabled() && !context.getResponseComplete() && resp instanceof HttpServletResponse) {
            HttpServletResponse httpResp = (HttpServletResponse)resp;
            if (!httpResp.isCommitted()) {
                httpResp.reset();
                httpResp.setContentType("text/html; charset=UTF-8");
                PrintWriter w = httpResp.getWriter();
                DevTools.debugHtml(w, context, e);
                ((Writer)w).flush();
                context.responseComplete();
            }
        } else {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    protected void handleFaceletNotFound(FacesContext context, ViewHandler vh, String viewId) throws IOException {
        String actualId = vh.getActionURL(context, viewId);
        Object respObj = context.getExternalContext().getResponse();
        if (respObj instanceof HttpServletResponse) {
            HttpServletResponse respHttp = (HttpServletResponse)respObj;
            respHttp.sendError(404, actualId);
            context.responseComplete();
        }
    }

    protected String getResponseEncoding(FacesContext context, String orig) {
        String encoding = orig;
        Map ctxAttributes = context.getAttributes();
        Map sessionMap = context.getExternalContext().getSessionMap();
        if (ctxAttributes.containsKey("facelets.Encoding")) {
            encoding = (String)ctxAttributes.get("facelets.Encoding");
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Facelet specified alternate encoding {0}", encoding);
            }
            sessionMap.put("javax.faces.request.charset", encoding);
        }
        Object request = context.getExternalContext().getRequest();
        if (encoding == null && request instanceof ServletRequest) {
            encoding = ((ServletRequest)request).getCharacterEncoding();
        }
        if (encoding == null) {
            encoding = (String)sessionMap.get("javax.faces.request.charset");
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Session specified alternate encoding {0}", encoding);
            }
        }
        if (encoding == null) {
            encoding = "UTF-8";
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("ResponseWriter created had a null CharacterEncoding, defaulting to UTF-8");
            }
        }
        return encoding;
    }

    protected String getResponseContentType(FacesContext context, String orig) {
        String contentType = orig;
        Map m = context.getAttributes();
        if (m.containsKey("facelets.ContentType")) {
            contentType = (String)m.get("facelets.ContentType");
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Facelet specified alternate contentType '" + contentType + "'");
            }
        }
        if (contentType == null) {
            contentType = "text/html";
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("ResponseWriter created had a null ContentType, defaulting to text/html");
            }
        }
        return contentType;
    }

    protected static final class NullWriter
    extends Writer {
        static final NullWriter Instance = new NullWriter();

        protected NullWriter() {
        }

        public void write(char[] buffer) {
        }

        public void write(char[] buffer, int off, int len) {
        }

        public void write(String str) {
        }

        public void write(int c) {
        }

        public void write(String str, int off, int len) {
        }

        public void close() {
        }

        public void flush() {
        }
    }
}

