/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.scripting;

import com.sun.faces.scripting.groovy.GroovyHelper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

class WeldAwareGroovySupportFilter
implements Filter {
    private boolean helperChecked;
    private GroovyHelper helper;
    private ServletContext sc;
    private Class containerClass;
    private Field instanceField;
    private Method instanceMethod;
    private Class singletonClass;
    private Method singletonSetMethod;

    WeldAwareGroovySupportFilter() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.sc = filterConfig.getServletContext();
        try {
            this.obtainReflectionReferences();
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    private void obtainReflectionReferences() throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.containerClass = classLoader.loadClass("org.jboss.weld.Container");
        this.instanceField = this.containerClass.getDeclaredField("instance");
        this.instanceField.setAccessible(true);
        Class[] classArray = new Class[]{};
        this.instanceMethod = this.containerClass.getDeclaredMethod("instance", classArray);
        this.instanceMethod.setAccessible(true);
        this.singletonClass = classLoader.loadClass("org.jboss.weld.bootstrap.api.Singleton");
        classArray = new Class[]{Object.class};
        this.singletonSetMethod = this.singletonClass.getDeclaredMethod("set", classArray);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.helperChecked) {
            this.helper = GroovyHelper.getCurrentInstance(this.sc);
            this.helperChecked = true;
        }
        if (this.helper != null) {
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            this.helper.setClassLoader();
            ClassLoader classLoader2 = thread.getContextClassLoader();
            thread.setContextClassLoader(classLoader);
            Object object = null;
            try {
                object = this.getWeldContainerInstance();
            }
            catch (Exception exception) {
                Logger.getLogger(WeldAwareGroovySupportFilter.class.getName()).log(Level.SEVERE, null, exception);
            }
            thread.setContextClassLoader(classLoader2);
            try {
                this.installMojarraGroovyClassLoaderToContainer(object);
            }
            catch (Exception exception) {
                Logger.getLogger(WeldAwareGroovySupportFilter.class.getName()).log(Level.SEVERE, null, exception);
            }
            this.helper.setClassLoader();
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private Object getWeldContainerInstance() throws Exception {
        Object[] objectArray = new Object[]{};
        Object object = this.instanceMethod.invoke(null, objectArray);
        return object;
    }

    private void installMojarraGroovyClassLoaderToContainer(Object object) throws NoSuchFieldException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object object2 = this.instanceField.get(null);
        this.singletonSetMethod.invoke(object2, object);
    }

    public void destroy() {
    }
}

