/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf.core;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagHandler;
import com.sun.faces.facelets.util.ReflectionUtil;
import java.io.IOException;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.EditableValueHolderAttachedObjectHandler;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;

public final class ValueChangeListenerHandler
extends TagHandlerImpl
implements EditableValueHolderAttachedObjectHandler {
    private final TagAttribute binding = this.getAttribute("binding");
    private final String listenerType;
    private final TagAttribute typeAttribute = this.getAttribute("type");

    public ValueChangeListenerHandler(TagConfig tagConfig) {
        super(tagConfig);
        if (null != this.typeAttribute) {
            String string = null;
            if (!this.typeAttribute.isLiteral()) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                FaceletContext faceletContext = (FaceletContext)facesContext.getAttributes().get("javax.faces.FACELET_CONTEXT");
                string = (String)this.typeAttribute.getValueExpression(faceletContext, String.class).getValue((ELContext)faceletContext);
            } else {
                string = this.typeAttribute.getValue();
            }
            this.checkType(string);
            this.listenerType = string;
        } else {
            this.listenerType = null;
        }
    }

    public void apply(FaceletContext faceletContext, UIComponent uIComponent) throws IOException {
        if (uIComponent == null || !ComponentHandler.isNew((UIComponent)uIComponent)) {
            return;
        }
        if (uIComponent instanceof EditableValueHolder) {
            this.applyAttachedObject(faceletContext.getFacesContext(), uIComponent);
        } else if (uIComponent.getAttributes().containsKey("javax.faces.application.Resource.ComponentResource")) {
            CompositeComponentTagHandler.getAttachedObjectHandlers(uIComponent).add((AttachedObjectHandler)this);
        } else {
            throw new TagException(this.tag, "Parent is not of type EditableValueHolder, type is: " + uIComponent);
        }
    }

    public void applyAttachedObject(FacesContext facesContext, UIComponent uIComponent) {
        FaceletContext faceletContext = (FaceletContext)facesContext.getAttributes().get("javax.faces.FACELET_CONTEXT");
        EditableValueHolder editableValueHolder = (EditableValueHolder)uIComponent;
        ValueExpression valueExpression = null;
        if (this.binding != null) {
            valueExpression = this.binding.getValueExpression(faceletContext, ValueChangeListener.class);
        }
        LazyValueChangeListener lazyValueChangeListener = new LazyValueChangeListener(this.listenerType, valueExpression);
        editableValueHolder.addValueChangeListener((ValueChangeListener)lazyValueChangeListener);
    }

    public String getFor() {
        String string = null;
        TagAttribute tagAttribute = this.getAttribute("for");
        if (null != tagAttribute) {
            if (tagAttribute.isLiteral()) {
                string = tagAttribute.getValue();
            } else {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                FaceletContext faceletContext = (FaceletContext)facesContext.getAttributes().get("javax.faces.FACELET_CONTEXT");
                string = (String)tagAttribute.getValueExpression(faceletContext, String.class).getValue((ELContext)faceletContext);
            }
        }
        return string;
    }

    private void checkType(String string) {
        try {
            ReflectionUtil.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TagAttributeException(this.typeAttribute, "Couldn't qualify ActionListener", (Throwable)classNotFoundException);
        }
    }

    private static class LazyValueChangeListener
    implements ValueChangeListener,
    Serializable {
        private static final long serialVersionUID = 7613811124326963180L;
        private final String type;
        private final ValueExpression binding;

        public LazyValueChangeListener(String string, ValueExpression valueExpression) {
            this.type = string;
            this.binding = valueExpression;
        }

        public void processValueChange(ValueChangeEvent valueChangeEvent) throws AbortProcessingException {
            ValueChangeListener valueChangeListener = null;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null) {
                return;
            }
            if (this.binding != null) {
                valueChangeListener = (ValueChangeListener)this.binding.getValue(facesContext.getELContext());
            }
            if (valueChangeListener == null && this.type != null) {
                try {
                    valueChangeListener = (ValueChangeListener)ReflectionUtil.forName(this.type).newInstance();
                }
                catch (Exception exception) {
                    throw new AbortProcessingException("Couldn't Lazily instantiate ValueChangeListener", (Throwable)exception);
                }
                if (this.binding != null) {
                    this.binding.setValue(facesContext.getELContext(), (Object)valueChangeListener);
                }
            }
            if (valueChangeListener != null) {
                valueChangeListener.processValueChange(valueChangeEvent);
            }
        }
    }
}

