/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ApplicationResourceBundle;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.el.ChainAwareVariableResolver;
import com.sun.faces.el.DummyPropertyResolverImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELResolver;
import javax.faces.application.Application;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ResourceHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.event.NamedEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String APPLICATION = "application";
    private static final String ACTION_LISTENER = "action-listener";
    private List<ActionListener> actionListeners = new CopyOnWriteArrayList<ActionListener>();
    private static final String DEFAULT_RENDERKIT_ID = "default-render-kit-id";
    private static final String DEFAULT_VALIDATORS = "default-validators";
    private static final String VALIDATOR_ID = "validator-id";
    private static final String MESSAGE_BUNDLE = "message-bundle";
    private static final String NAVIGATION_HANDLER = "navigation-handler";
    private List<NavigationHandler> navigationHandlers = new CopyOnWriteArrayList<NavigationHandler>();
    private static final String VIEW_HANDLER = "view-handler";
    private List<ViewHandler> viewHandlers = new CopyOnWriteArrayList<ViewHandler>();
    private static final String STATE_MANAGER = "state-manager";
    private List<StateManager> stateManagers = new CopyOnWriteArrayList<StateManager>();
    private static final String RESOURCE_HANDLER = "resource-handler";
    private List<ResourceHandler> resourceHandlers = new CopyOnWriteArrayList<ResourceHandler>();
    private static final String EL_RESOLVER = "el-resolver";
    private List<ELResolver> elResolvers = new CopyOnWriteArrayList<ELResolver>();
    private static final String PROPERTY_RESOLVER = "property-resolver";
    private static final String VARIABLE_RESOLVER = "variable-resolver";
    private static final String DEFAULT_LOCALE = "default-locale";
    private static final String SUPPORTED_LOCALE = "supported-locale";
    private static final String RESOURCE_BUNDLE = "resource-bundle";
    private static final String BASE_NAME = "base-name";
    private static final String VAR = "var";
    private static final String RES_DESCRIPTIONS = "description";
    private static final String RES_DISPLAY_NAMES = "display-name";
    private static final String SYSTEM_EVENT_LISTENER = "system-event-listener";
    private List<SystemEventListener> systemEventListeners = new CopyOnWriteArrayList<SystemEventListener>();
    private static final String SYSTEM_EVENT_LISTENER_CLASS = "system-event-listener-class";
    private static final String SYSTEM_EVENT_CLASS = "system-event-class";
    private static final String SOURCE_CLASS = "source-class";

    @Override
    public void process(ServletContext servletContext, DocumentInfo[] documentInfoArray) throws Exception {
        Application application = this.getApplication();
        ApplicationAssociate applicationAssociate = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext());
        LinkedHashMap<String, Node> linkedHashMap = new LinkedHashMap<String, Node>();
        LinkedHashSet<String> linkedHashSet = null;
        for (int i = 0; i < documentInfoArray.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing application elements for document: ''{0}''", documentInfoArray[i].getSourceURI()));
            }
            Document document = documentInfoArray[i].getDocument();
            String string = document.getDocumentElement().getNamespaceURI();
            NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS(string, APPLICATION);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            int n = nodeList.getLength();
            for (int j = 0; j < n; ++j) {
                Node node = nodeList.item(j);
                NodeList nodeList2 = ((Element)node).getElementsByTagNameNS(string, "*");
                if (nodeList2 == null || nodeList2.getLength() <= 0) continue;
                int n2 = nodeList2.getLength();
                for (int k = 0; k < n2; ++k) {
                    Node node2 = nodeList2.item(k);
                    if (MESSAGE_BUNDLE.equals(node2.getLocalName())) {
                        this.setMessageBundle(application, node2);
                        continue;
                    }
                    if (DEFAULT_RENDERKIT_ID.equals(node2.getLocalName())) {
                        this.setDefaultRenderKitId(application, node2);
                        continue;
                    }
                    if (ACTION_LISTENER.equals(node2.getLocalName())) {
                        this.addActionListener(servletContext, application, node2);
                        continue;
                    }
                    if (NAVIGATION_HANDLER.equals(node2.getLocalName())) {
                        this.setNavigationHandler(servletContext, application, node2);
                        continue;
                    }
                    if (VIEW_HANDLER.equals(node2.getLocalName())) {
                        String string2 = this.getNodeText(node2);
                        if (string2 == null) continue;
                        linkedHashMap.put(string2, node2);
                        continue;
                    }
                    if (STATE_MANAGER.equals(node2.getLocalName())) {
                        this.setStateManager(servletContext, application, node2);
                        continue;
                    }
                    if (EL_RESOLVER.equals(node2.getLocalName())) {
                        this.addELResolver(servletContext, applicationAssociate, node2);
                        continue;
                    }
                    if (PROPERTY_RESOLVER.equals(node2.getLocalName())) {
                        this.addPropertyResolver(servletContext, applicationAssociate, node2);
                        continue;
                    }
                    if (VARIABLE_RESOLVER.equals(node2.getLocalName())) {
                        this.addVariableResolver(servletContext, applicationAssociate, node2);
                        continue;
                    }
                    if (DEFAULT_LOCALE.equals(node2.getLocalName())) {
                        this.setDefaultLocale(application, node2);
                        continue;
                    }
                    if (SUPPORTED_LOCALE.equals(node2.getLocalName())) {
                        this.addSupportedLocale(application, node2);
                        continue;
                    }
                    if (RESOURCE_BUNDLE.equals(node2.getLocalName())) {
                        this.addResouceBundle(applicationAssociate, node2);
                        continue;
                    }
                    if (RESOURCE_HANDLER.equals(node2.getLocalName())) {
                        this.setResourceHandler(servletContext, application, node2);
                        continue;
                    }
                    if (SYSTEM_EVENT_LISTENER.equals(node2.getLocalName())) {
                        this.addSystemEventListener(servletContext, application, node2);
                        continue;
                    }
                    if (DEFAULT_VALIDATORS.equals(node2.getLocalName())) {
                        if (linkedHashSet == null) {
                            linkedHashSet = new LinkedHashSet<String>();
                            continue;
                        }
                        linkedHashSet.clear();
                        continue;
                    }
                    if (!VALIDATOR_ID.equals(node2.getLocalName())) continue;
                    linkedHashSet.add(this.getNodeText(node2));
                }
            }
        }
        this.registerDefaultValidatorIds(application, linkedHashSet);
        this.processViewHandlers(servletContext, application, linkedHashMap);
        this.processAnnotations(NamedEvent.class);
        this.invokeNext(servletContext, documentInfoArray);
    }

    @Override
    public void destroy(ServletContext servletContext) {
        this.destroyInstances(servletContext, this.actionListeners);
        this.destroyInstances(servletContext, this.navigationHandlers);
        this.destroyInstances(servletContext, this.stateManagers);
        this.destroyInstances(servletContext, this.viewHandlers);
        this.destroyInstances(servletContext, this.elResolvers);
        this.destroyInstances(servletContext, this.resourceHandlers);
        this.destroyInstances(servletContext, this.systemEventListeners);
        this.destroyNext(servletContext);
    }

    private void destroyInstances(ServletContext servletContext, List list) {
        for (Object e : list) {
            this.destroyInstance(servletContext, e.getClass().getName(), e);
        }
        list.clear();
    }

    private void registerDefaultValidatorIds(Application application, LinkedHashSet<String> linkedHashSet) {
        if (linkedHashSet == null) {
            Object object;
            linkedHashSet = new LinkedHashSet();
            if (ApplicationConfigProcessor.isBeanValidatorAvailable() && !((WebConfiguration)(object = WebConfiguration.getInstance())).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableDefaultBeanValidator)) {
                linkedHashSet.add("javax.faces.Bean");
            }
        }
        for (String string : linkedHashSet) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.addDefaultValidatorId({0})", string));
            }
            application.addDefaultValidatorId(string);
        }
    }

    static boolean isBeanValidatorAvailable() {
        boolean bl = false;
        Map map = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        if (map.containsKey("javax.faces.BEANS_VALIDATION_AVAILABLE")) {
            bl = (Boolean)map.get("javax.faces.BEANS_VALIDATION_AVAILABLE");
        } else {
            block15: {
                try {
                    Object object;
                    Object object2;
                    block17: {
                        InitialContext initialContext;
                        block16: {
                            Thread.currentThread().getContextClassLoader().loadClass("javax.validation.MessageInterpolator");
                            Object v = map.get("javax.faces.validator.beanValidator.ValidatorFactory");
                            if (v instanceof ValidatorFactory) {
                                bl = true;
                                break block15;
                            }
                            initialContext = null;
                            try {
                                initialContext = new InitialContext();
                            }
                            catch (NoClassDefFoundError noClassDefFoundError) {
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.log(Level.FINE, noClassDefFoundError.toString(), noClassDefFoundError);
                                }
                            }
                            catch (NamingException namingException) {
                                if (!LOGGER.isLoggable(Level.WARNING)) break block16;
                                LOGGER.log(Level.WARNING, namingException.toString(), namingException);
                            }
                        }
                        try {
                            object2 = initialContext.lookup("java:comp/ValidatorFactory");
                            if (null != object2) {
                                map.put("javax.faces.validator.beanValidator.ValidatorFactory", object2);
                                bl = true;
                            }
                        }
                        catch (NamingException namingException) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block17;
                            object = "Could not build a default Bean Validator factory: " + namingException.getMessage();
                            LOGGER.fine((String)object);
                        }
                    }
                    if (!bl) {
                        try {
                            object2 = Validation.buildDefaultValidatorFactory();
                            object = object2.getValidator();
                            map.put("javax.faces.validator.beanValidator.ValidatorFactory", object2);
                            bl = true;
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable throwable) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block15;
                    LOGGER.fine("Unable to load Beans Validation");
                }
            }
            map.put("javax.faces.BEANS_VALIDATION_AVAILABLE", bl);
        }
        return bl;
    }

    private void setMessageBundle(Application application, Node node) {
        String string;
        if (node != null && (string = this.getNodeText(node)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setMessageBundle({0})", string));
            }
            application.setMessageBundle(string);
        }
    }

    private void setDefaultRenderKitId(Application application, Node node) {
        String string;
        if (node != null && (string = this.getNodeText(node)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setDefaultRenderKitId({0})", string));
            }
            application.setDefaultRenderKitId(string);
        }
    }

    private void addActionListener(ServletContext servletContext, Application application, Node node) {
        String string;
        if (node != null && (string = this.getNodeText(node)) != null) {
            boolean[] blArray = new boolean[]{false};
            ActionListener actionListener = (ActionListener)this.createInstance(servletContext, string, ActionListener.class, application.getActionListener(), node, true, blArray);
            if (actionListener != null) {
                if (blArray[0]) {
                    this.actionListeners.add(actionListener);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setActionListeners({0})", string));
                }
                application.setActionListener(actionListener);
            }
        }
    }

    private void setNavigationHandler(ServletContext servletContext, Application application, Node node) {
        String string;
        if (node != null && (string = this.getNodeText(node)) != null) {
            Class<?> clazz = this.findRootType(servletContext, string, node, new Class[]{ConfigurableNavigationHandler.class, NavigationHandler.class});
            boolean[] blArray = new boolean[]{false};
            NavigationHandler navigationHandler = (NavigationHandler)this.createInstance(servletContext, string, clazz != null ? clazz : NavigationHandler.class, application.getNavigationHandler(), node, true, blArray);
            if (navigationHandler != null) {
                if (blArray[0]) {
                    this.navigationHandlers.add(navigationHandler);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setNavigationHandlers({0})", string));
                }
                application.setNavigationHandler(navigationHandler);
            }
        }
    }

    private void setStateManager(ServletContext servletContext, Application application, Node node) {
        String string;
        if (node != null && (string = this.getNodeText(node)) != null) {
            boolean[] blArray = new boolean[]{false};
            StateManager stateManager = (StateManager)this.createInstance(servletContext, string, StateManager.class, application.getStateManager(), node, true, blArray);
            if (stateManager != null) {
                if (blArray[0]) {
                    this.stateManagers.add(stateManager);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setStateManagers({0})", string));
                }
                application.setStateManager(stateManager);
            }
        }
    }

    private void setViewHandler(ServletContext servletContext, Application application, Node node) {
        String string;
        if (node != null && (string = this.getNodeText(node)) != null) {
            boolean[] blArray = new boolean[]{false};
            ViewHandler viewHandler = (ViewHandler)this.createInstance(servletContext, string, ViewHandler.class, application.getViewHandler(), node, true, blArray);
            if (viewHandler != null) {
                if (blArray[0]) {
                    this.viewHandlers.add(viewHandler);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setViewHandler({0})", string));
                }
                application.setViewHandler(viewHandler);
            }
        }
    }

    private void addELResolver(ServletContext servletContext, ApplicationAssociate applicationAssociate, Node node) {
        if (node != null && applicationAssociate != null) {
            boolean[] blArray;
            ELResolver eLResolver;
            String string;
            List<ELResolver> list = applicationAssociate.getELResolversFromFacesConfig();
            if (list == null) {
                list = new ArrayList<ELResolver>();
                applicationAssociate.setELResolversFromFacesConfig(list);
            }
            if ((string = this.getNodeText(node)) != null && (eLResolver = (ELResolver)this.createInstance(servletContext, string, ELResolver.class, null, node, true, blArray = new boolean[]{false})) != null) {
                if (blArray[0]) {
                    this.elResolvers.add(eLResolver);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding ''{0}'' to ELResolver chain", string));
                }
                list.add(eLResolver);
            }
        }
    }

    private void addPropertyResolver(ServletContext servletContext, ApplicationAssociate applicationAssociate, Node node) {
        if (node != null && applicationAssociate != null) {
            String string;
            Object object = applicationAssociate.getLegacyPRChainHead();
            if (object == null) {
                object = new DummyPropertyResolverImpl();
            }
            if ((string = this.getNodeText(node)) != null) {
                boolean[] blArray = new boolean[]{false};
                object = this.createInstance(servletContext, string, PropertyResolver.class, object, node, false, blArray);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding ''{0}'' to PropertyResolver chain", object));
                }
            }
            if (object != null) {
                applicationAssociate.setLegacyPRChainHead((PropertyResolver)object);
            }
        }
    }

    private void addVariableResolver(ServletContext servletContext, ApplicationAssociate applicationAssociate, Node node) {
        if (node != null && applicationAssociate != null) {
            String string;
            Object object = applicationAssociate.getLegacyVRChainHead();
            if (object == null) {
                object = new ChainAwareVariableResolver();
            }
            if ((string = this.getNodeText(node)) != null) {
                boolean[] blArray = new boolean[]{false};
                object = this.createInstance(servletContext, string, VariableResolver.class, object, node, false, blArray);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding ''{0}'' to VariableResolver chain", object));
                }
            }
            if (object != null) {
                applicationAssociate.setLegacyVRChainHead((VariableResolver)object);
            }
        }
    }

    private void setDefaultLocale(Application application, Node node) {
        Locale locale;
        String string;
        if (node != null && (string = this.getNodeText(node)) != null && (locale = Util.getLocaleFromString(string)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Setting default Locale to ''{0}''", string));
            }
            application.setDefaultLocale(locale);
        }
    }

    private void addSupportedLocale(Application application, Node node) {
        if (node != null) {
            Set<Locale> set = this.getCurrentLocales(application);
            String string = this.getNodeText(node);
            if (string != null) {
                Locale locale = Util.getLocaleFromString(string);
                if (locale != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, MessageFormat.format("Adding supported Locale ''{0}''", string));
                    }
                    set.add(locale);
                }
                application.setSupportedLocales(set);
            }
        }
    }

    private void addResouceBundle(ApplicationAssociate applicationAssociate, Node node) {
        NodeList nodeList;
        if (node != null && (nodeList = node.getChildNodes()) != null) {
            String string = null;
            String string2 = null;
            ArrayList<Node> arrayList = null;
            ArrayList<Node> arrayList2 = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                if (BASE_NAME.equals(node2.getLocalName())) {
                    string = this.getNodeText(node2);
                    continue;
                }
                if (VAR.equals(node2.getLocalName())) {
                    string2 = this.getNodeText(node2);
                    continue;
                }
                if (RES_DESCRIPTIONS.equals(node2.getLocalName())) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Node>(2);
                    }
                    arrayList.add(node2);
                    continue;
                }
                if (!RES_DISPLAY_NAMES.equals(node2.getLocalName())) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Node>(2);
                }
                arrayList2.add(node2);
            }
            if (string != null && string2 != null) {
                applicationAssociate.addResourceBundle(string2, new ApplicationResourceBundle(string, this.getTextMap(arrayList2), this.getTextMap(arrayList)));
            }
        }
    }

    private Set<Locale> getCurrentLocales(Application application) {
        HashSet<Locale> hashSet = new HashSet<Locale>();
        Iterator iterator = application.getSupportedLocales();
        while (iterator.hasNext()) {
            hashSet.add((Locale)iterator.next());
        }
        return hashSet;
    }

    private void setResourceHandler(ServletContext servletContext, Application application, Node node) {
        String string;
        if (node != null && (string = this.getNodeText(node)) != null) {
            boolean[] blArray = new boolean[]{false};
            ResourceHandler resourceHandler = (ResourceHandler)this.createInstance(servletContext, string, ResourceHandler.class, application.getResourceHandler(), node, true, blArray);
            if (resourceHandler != null) {
                if (blArray[0]) {
                    this.resourceHandlers.add(resourceHandler);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setResourceHandler({0})", string));
                }
                application.setResourceHandler(resourceHandler);
            }
        }
    }

    private void addSystemEventListener(ServletContext servletContext, Application application, Node node) {
        SystemEventListener systemEventListener;
        Node node2;
        NodeList nodeList = node.getChildNodes();
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (SYSTEM_EVENT_LISTENER_CLASS.equals(node2.getLocalName())) {
                string = this.getNodeText(node2);
                continue;
            }
            if (SYSTEM_EVENT_CLASS.equals(node2.getLocalName())) {
                string2 = this.getNodeText(node2);
                continue;
            }
            if (!SOURCE_CLASS.equals(node2.getLocalName())) continue;
            string3 = this.getNodeText(node2);
        }
        if (string != null && (systemEventListener = (SystemEventListener)this.createInstance(servletContext, string, SystemEventListener.class, null, node)) != null) {
            this.systemEventListeners.add(systemEventListener);
            try {
                Class clazz = string2 != null ? this.loadClass(servletContext, string2, this, null) : SystemEvent.class;
                node2 = string3 != null && string3.length() != 0 ? Util.loadClass(string3, this.getClass()) : null;
                application.subscribeToEvent(clazz, (Class)((Object)node2), systemEventListener);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Subscribing for event {0} and source {1} using listener {2}", new Object[]{clazz.getName(), node2 != null ? ((Class)((Object)node2)).getName() : "ANY", systemEventListener.getClass().getName()});
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConfigurationException(classNotFoundException);
            }
        }
    }

    private void processViewHandlers(ServletContext servletContext, Application application, LinkedHashMap<String, Node> linkedHashMap) {
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        if (!webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler) && linkedHashMap.containsKey("com.sun.facelets.FaceletViewHandler")) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.application.legacy_facelet_viewhandler_detected", "com.sun.facelets.FaceletViewHandler");
            }
            webConfiguration.overrideContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler, true);
        }
        for (Node node : linkedHashMap.values()) {
            this.setViewHandler(servletContext, application, node);
        }
    }
}

