/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DbfFactory;
import com.sun.faces.config.DelegatingAnnotationProvider;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.DocumentOrderingWrapper;
import com.sun.faces.config.FacesConfigInfo;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.configprovider.MetaInfFaceletTaglibraryConfigProvider;
import com.sun.faces.config.configprovider.MetaInfFacesConfigResourceProvider;
import com.sun.faces.config.configprovider.MojarraFacesConfigResourceProvider;
import com.sun.faces.config.configprovider.WebAppFlowConfigResourceProvider;
import com.sun.faces.config.configprovider.WebFaceletTaglibResourceProvider;
import com.sun.faces.config.configprovider.WebFacesConfigResourceProvider;
import com.sun.faces.config.processor.ApplicationConfigProcessor;
import com.sun.faces.config.processor.BehaviorConfigProcessor;
import com.sun.faces.config.processor.ComponentConfigProcessor;
import com.sun.faces.config.processor.ConfigProcessor;
import com.sun.faces.config.processor.ConverterConfigProcessor;
import com.sun.faces.config.processor.FaceletTaglibConfigProcessor;
import com.sun.faces.config.processor.FacesConfigExtensionProcessor;
import com.sun.faces.config.processor.FacesFlowDefinitionConfigProcessor;
import com.sun.faces.config.processor.FactoryConfigProcessor;
import com.sun.faces.config.processor.LifecycleConfigProcessor;
import com.sun.faces.config.processor.ManagedBeanConfigProcessor;
import com.sun.faces.config.processor.NavigationConfigProcessor;
import com.sun.faces.config.processor.ProtectedViewsConfigProcessor;
import com.sun.faces.config.processor.RenderKitConfigProcessor;
import com.sun.faces.config.processor.ResourceLibraryContractsConfigProcessor;
import com.sun.faces.config.processor.ValidatorConfigProcessor;
import com.sun.faces.el.ELContextImpl;
import com.sun.faces.el.ELUtils;
import com.sun.faces.spi.AnnotationProvider;
import com.sun.faces.spi.AnnotationProviderFactory;
import com.sun.faces.spi.AnnotationScanner;
import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.spi.ConfigurationResourceProviderFactory;
import com.sun.faces.spi.HighAvailabilityEnabler;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderFactory;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Timer;
import com.sun.faces.util.Util;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.el.ExpressionFactory;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationConfigurationPopulator;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PostConstructApplicationEvent;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigManager {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final Pattern JAR_PATTERN = Pattern.compile("(.*/(\\S*\\.jar)).*(/faces-config.xml|/*.\\.faces-config.xml)");
    private final List<ConfigurationResourceProvider> FACES_CONFIG_RESOURCE_PROVIDERS;
    private final List<ConfigurationResourceProvider> FACELET_TAGLIBRARY_RESOURCE_PROVIDERS;
    private static final int NUMBER_OF_TASK_THREADS = 5;
    private static final String CONFIG_MANAGER_INSTANCE_KEY = "com.sun.faces.CONFIG_MANAGER_KEY";
    private static final String ANNOTATIONS_SCAN_TASK_KEY = ConfigManager.class.getName() + "_ANNOTATION_SCAN_TASK";
    public static final String INJECTION_PROVIDER_KEY = ConfigManager.class.getName() + "_INJECTION_PROVIDER_TASK";
    public static final String WEB_INF_MARKER = "com.sun.faces.webinf";
    private List<ServletContext> initializedContexts = new CopyOnWriteArrayList<ServletContext>();
    private final ConfigProcessor FACES_CONFIG_PROCESSOR_CHAIN;
    private final ConfigProcessor FACELET_TAGLIB_CONFIG_PROCESSOR_CHAIN;
    private static final String FACES_TO_1_1_PRIVATE_XSL = "/com/sun/faces/jsf1_0-1_1toSchema.xsl";
    private static final String FACELETS_TO_2_0_XSL = "/com/sun/faces/facelets1_0-2_0toSchema.xsl";
    private static final String FACES_CONFIG_1_X_DEFAULT_NS = "http://java.sun.com/JSF/Configuration";
    private static final String FACELETS_1_0_DEFAULT_NS = "http://java.sun.com/JSF/Facelet";

    public ConfigManager() {
        ArrayList<ConfigurationResourceProvider> arrayList = new ArrayList<ConfigurationResourceProvider>(3);
        arrayList.add(new MojarraFacesConfigResourceProvider());
        arrayList.add(new MetaInfFacesConfigResourceProvider());
        arrayList.add(new WebAppFlowConfigResourceProvider());
        arrayList.add(new WebFacesConfigResourceProvider());
        this.FACES_CONFIG_RESOURCE_PROVIDERS = Collections.unmodifiableList(arrayList);
        ArrayList<ConfigurationResourceProvider> arrayList2 = new ArrayList<ConfigurationResourceProvider>(3);
        arrayList2.add(new MetaInfFaceletTaglibraryConfigProvider());
        arrayList2.add(new WebFaceletTaglibResourceProvider());
        this.FACELET_TAGLIBRARY_RESOURCE_PROVIDERS = Collections.unmodifiableList(arrayList2);
        ConfigProcessor[] configProcessorArray = new ConfigProcessor[]{new FactoryConfigProcessor(), new LifecycleConfigProcessor(), new ApplicationConfigProcessor(), new ComponentConfigProcessor(), new ConverterConfigProcessor(), new ValidatorConfigProcessor(), new ManagedBeanConfigProcessor(), new RenderKitConfigProcessor(), new NavigationConfigProcessor(), new BehaviorConfigProcessor(), new FacesConfigExtensionProcessor(), new ProtectedViewsConfigProcessor(), new FacesFlowDefinitionConfigProcessor(), new ResourceLibraryContractsConfigProcessor()};
        for (int i = 0; i < configProcessorArray.length; ++i) {
            ConfigProcessor configProcessor = configProcessorArray[i];
            if (i + 1 >= configProcessorArray.length) continue;
            configProcessor.setNext(configProcessorArray[i + 1]);
        }
        this.FACES_CONFIG_PROCESSOR_CHAIN = configProcessorArray[0];
        this.FACELET_TAGLIB_CONFIG_PROCESSOR_CHAIN = new FaceletTaglibConfigProcessor();
    }

    public static ConfigManager getInstance(ServletContext servletContext) {
        return (ConfigManager)servletContext.getAttribute(CONFIG_MANAGER_INSTANCE_KEY);
    }

    public static ConfigManager createInstance(ServletContext servletContext) {
        ConfigManager configManager = new ConfigManager();
        servletContext.setAttribute(CONFIG_MANAGER_INSTANCE_KEY, (Object)configManager);
        return configManager;
    }

    public static void removeInstance(ServletContext servletContext) {
        servletContext.removeAttribute(CONFIG_MANAGER_INSTANCE_KEY);
    }

    private void initializeConfigProcessers(ServletContext servletContext) {
        ConfigProcessor configProcessor = this.FACES_CONFIG_PROCESSOR_CHAIN;
        do {
            configProcessor.initializeClassMetadataMap(servletContext);
        } while (null != (configProcessor = configProcessor.getNext()));
    }

    public void initialize(ServletContext servletContext) {
        if (!this.hasBeenInitialized(servletContext)) {
            this.initializedContexts.add(servletContext);
            this.initializeConfigProcessers(servletContext);
            ExecutorService executorService = null;
            try {
                Object object;
                Object object2;
                Object object3;
                WebConfiguration webConfiguration = WebConfiguration.getInstance(servletContext);
                boolean bl = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.ValidateFacesConfigFiles);
                if (ConfigManager.useThreads(servletContext)) {
                    executorService = ConfigManager.createExecutorService();
                }
                DocumentInfo[] documentInfoArray = ConfigManager.getConfigDocuments(servletContext, this.getFacesConfigResourceProviders(), executorService, bl);
                FacesConfigInfo facesConfigInfo = new FacesConfigInfo(documentInfoArray[documentInfoArray.length - 1]);
                documentInfoArray = this.sortDocuments(documentInfoArray, facesConfigInfo);
                InitFacesContext initFacesContext = (InitFacesContext)FacesContext.getCurrentInstance();
                InjectionProvider injectionProvider = InjectionProviderFactory.createInstance(initFacesContext.getExternalContext());
                initFacesContext.getAttributes().put(INJECTION_PROVIDER_KEY, injectionProvider);
                boolean bl2 = false;
                if (facesConfigInfo.isWebInfFacesConfig()) {
                    bl2 = this.isFaceletsDisabled(webConfiguration, facesConfigInfo);
                }
                if (!facesConfigInfo.isWebInfFacesConfig() || !facesConfigInfo.isMetadataComplete()) {
                    object3 = new ProvideMetadataToAnnotationScanTask(documentInfoArray, injectionProvider);
                    if (executorService != null) {
                        object2 = executorService.submit(new AnnotationScanTask(servletContext, initFacesContext, (ProvideMetadataToAnnotationScanTask)object3));
                        this.pushTaskToContext(servletContext, (Future<Map<Class<? extends Annotation>, Set<Class<?>>>>)object2);
                    } else {
                        object2 = new FutureTask(new AnnotationScanTask(servletContext, initFacesContext, (ProvideMetadataToAnnotationScanTask)object3));
                        ((FutureTask)object2).run();
                    }
                    this.pushTaskToContext(servletContext, (Future<Map<Class<? extends Annotation>, Set<Class<?>>>>)object2);
                }
                if (injectionProvider instanceof HighAvailabilityEnabler) {
                    ((HighAvailabilityEnabler)((Object)injectionProvider)).enableHighAvailability(servletContext);
                }
                object3 = ServiceLoader.load(ApplicationConfigurationPopulator.class);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
                ArrayList<DocumentInfo> arrayList = new ArrayList<DocumentInfo>();
                DocumentInfo[] documentInfoArray2 = ((ServiceLoader)object3).iterator();
                while (documentInfoArray2.hasNext()) {
                    ApplicationConfigurationPopulator applicationConfigurationPopulator = (ApplicationConfigurationPopulator)documentInfoArray2.next();
                    object2 = dOMImplementation.createDocument("http://xmlns.jcp.org/xml/ns/javaee", "faces-config", null);
                    object = object2.createAttribute("version");
                    object.setValue("2.2");
                    object2.getDocumentElement().getAttributes().setNamedItem((Node)object);
                    try {
                        applicationConfigurationPopulator.populateApplicationConfiguration((Document)object2);
                        DocumentInfo documentInfo = new DocumentInfo((Document)object2, null);
                        arrayList.add(documentInfo);
                    }
                    catch (Throwable throwable) {
                        if (!LOGGER.isLoggable(Level.INFO)) continue;
                        LOGGER.log(Level.INFO, "{0} thrown when invoking {1}.populateApplicationConfigurationResources: {2}", new String[]{throwable.getClass().getName(), applicationConfigurationPopulator.getClass().getName(), throwable.getMessage()});
                    }
                }
                if (!arrayList.isEmpty()) {
                    documentInfoArray2 = new DocumentInfo[documentInfoArray.length + arrayList.size()];
                    System.arraycopy(documentInfoArray, 0, documentInfoArray2, 0, documentInfoArray.length);
                    int n = documentInfoArray.length;
                    object = arrayList.iterator();
                    while (object.hasNext()) {
                        DocumentInfo documentInfo;
                        documentInfoArray2[n] = documentInfo = (DocumentInfo)object.next();
                    }
                    documentInfoArray = documentInfoArray2;
                }
                this.FACES_CONFIG_PROCESSOR_CHAIN.process(servletContext, documentInfoArray);
                if (!bl2) {
                    this.FACELET_TAGLIB_CONFIG_PROCESSOR_CHAIN.process(servletContext, ConfigManager.getConfigDocuments(servletContext, this.getFaceletConfigResourceProviders(), executorService, bl));
                }
            }
            catch (Exception exception) {
                this.releaseFactories();
                Object object = exception;
                if (!(exception instanceof ConfigurationException)) {
                    object = new ConfigurationException("CONFIGURATION FAILED! " + object.getMessage(), (Throwable)object);
                }
                throw (ConfigurationException)((Object)object);
            }
            finally {
                if (executorService != null) {
                    executorService.shutdown();
                }
                servletContext.removeAttribute(ANNOTATIONS_SCAN_TASK_KEY);
            }
        }
        DbfFactory.removeSchemaMap(servletContext);
    }

    public void destroy(ServletContext servletContext) {
        this.FACES_CONFIG_PROCESSOR_CHAIN.destroy(servletContext);
        this.initializedContexts.remove(servletContext);
    }

    public boolean hasBeenInitialized(ServletContext servletContext) {
        return this.initializedContexts.contains(servletContext);
    }

    public static Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses(FacesContext facesContext) {
        Map map = facesContext.getExternalContext().getApplicationMap();
        Future future = (Future)map.get(ANNOTATIONS_SCAN_TASK_KEY);
        try {
            return future != null ? (Map)future.get() : Collections.emptyMap();
        }
        catch (Exception exception) {
            throw new FacesException((Throwable)exception);
        }
    }

    private static boolean useThreads(ServletContext servletContext) {
        WebConfiguration webConfiguration = WebConfiguration.getInstance(servletContext);
        return webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableThreading);
    }

    private List<ConfigurationResourceProvider> getFacesConfigResourceProviders() {
        return this.getConfigurationResourceProviders(this.FACES_CONFIG_RESOURCE_PROVIDERS, ConfigurationResourceProviderFactory.ProviderType.FacesConfig);
    }

    private List<ConfigurationResourceProvider> getFaceletConfigResourceProviders() {
        return this.getConfigurationResourceProviders(this.FACELET_TAGLIBRARY_RESOURCE_PROVIDERS, ConfigurationResourceProviderFactory.ProviderType.FaceletConfig);
    }

    private List<ConfigurationResourceProvider> getConfigurationResourceProviders(List<ConfigurationResourceProvider> list, ConfigurationResourceProviderFactory.ProviderType providerType) {
        ConfigurationResourceProvider[] configurationResourceProviderArray = ConfigurationResourceProviderFactory.createProviders(providerType);
        if (configurationResourceProviderArray.length == 0) {
            return list;
        }
        ArrayList<ConfigurationResourceProvider> arrayList = new ArrayList<ConfigurationResourceProvider>();
        arrayList.addAll(list);
        arrayList.addAll(list.size() - 1, Arrays.asList(configurationResourceProviderArray));
        return Collections.unmodifiableList(arrayList);
    }

    private DocumentInfo[] sortDocuments(DocumentInfo[] documentInfoArray, FacesConfigInfo facesConfigInfo) {
        int n = facesConfigInfo.isWebInfFacesConfig() ? documentInfoArray.length - 1 : documentInfoArray.length;
        List<String> list = facesConfigInfo.getAbsoluteOrdering();
        if (n > 1) {
            ArrayList<DocumentOrderingWrapper> arrayList = new ArrayList<DocumentOrderingWrapper>();
            for (int i = 1; i < n; ++i) {
                arrayList.add(new DocumentOrderingWrapper(documentInfoArray[i]));
            }
            DocumentOrderingWrapper[] documentOrderingWrapperArray = arrayList.toArray(new DocumentOrderingWrapper[arrayList.size()]);
            if (list == null) {
                DocumentOrderingWrapper.sort(documentOrderingWrapperArray);
                for (int i = 1; i < n; ++i) {
                    documentInfoArray[i] = documentOrderingWrapperArray[i - 1].getDocument();
                }
                return documentInfoArray;
            }
            DocumentOrderingWrapper[] documentOrderingWrapperArray2 = DocumentOrderingWrapper.sort(documentOrderingWrapperArray, list);
            DocumentInfo[] documentInfoArray2 = new DocumentInfo[facesConfigInfo.isWebInfFacesConfig() ? documentOrderingWrapperArray2.length + 2 : documentOrderingWrapperArray2.length + 1];
            for (int i = 1; i < n; ++i) {
                documentInfoArray2[i] = documentOrderingWrapperArray2[i - 1].getDocument();
            }
            documentInfoArray2[0] = documentInfoArray[0];
            if (facesConfigInfo.isWebInfFacesConfig()) {
                documentInfoArray2[documentInfoArray2.length - 1] = documentInfoArray[documentInfoArray.length - 1];
            }
            return documentInfoArray2;
        }
        return documentInfoArray;
    }

    private boolean isFaceletsDisabled(WebConfiguration webConfiguration, FacesConfigInfo facesConfigInfo) {
        boolean bl = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler);
        if (!bl) {
            bl = !facesConfigInfo.isVersionGreaterOrEqual(2.0);
            webConfiguration.overrideContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler, bl);
        }
        return bl;
    }

    private void pushTaskToContext(ServletContext servletContext, Future<Map<Class<? extends Annotation>, Set<Class<?>>>> future) {
        servletContext.setAttribute(ANNOTATIONS_SCAN_TASK_KEY, future);
    }

    void publishPostConfigEvent() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        if (null == ((InitFacesContext)facesContext).getELContext()) {
            ELContextListener[] eLContextListenerArray;
            UIViewRoot uIViewRoot;
            ELContextImpl eLContextImpl = new ELContextImpl(application.getELResolver());
            eLContextImpl.putContext(FacesContext.class, facesContext);
            ExpressionFactory expressionFactory = ELUtils.getDefaultExpressionFactory(facesContext);
            if (null != expressionFactory) {
                eLContextImpl.putContext(ExpressionFactory.class, expressionFactory);
            }
            if (null != (uIViewRoot = facesContext.getViewRoot())) {
                eLContextImpl.setLocale(uIViewRoot.getLocale());
            }
            if ((eLContextListenerArray = application.getELContextListeners()).length > 0) {
                ELContextEvent eLContextEvent = new ELContextEvent((ELContext)eLContextImpl);
                for (ELContextListener eLContextListener : eLContextListenerArray) {
                    eLContextListener.contextCreated(eLContextEvent);
                }
            }
            ((InitFacesContext)facesContext).setELContext(eLContextImpl);
        }
        application.publishEvent(facesContext, PostConstructApplicationEvent.class, Application.class, (Object)application);
    }

    private static DocumentInfo[] getConfigDocuments(ServletContext servletContext, List<ConfigurationResourceProvider> list, ExecutorService executorService, boolean bl) {
        Object object;
        ArrayList<FutureTask<Collection<URI>>> arrayList2 = new ArrayList<FutureTask<Collection<URI>>>(list.size());
        for (ConfigurationResourceProvider arrayList3 : list) {
            FutureTask<Collection<URI>> futureTask = new FutureTask<Collection<URI>>(new URITask(arrayList3, servletContext));
            arrayList2.add(futureTask);
            if (executorService != null) {
                executorService.execute(futureTask);
                continue;
            }
            futureTask.run();
        }
        ArrayList arrayList4 = new ArrayList(list.size() << 1);
        for (FutureTask futureTask : arrayList2) {
            try {
                object = (Collection)futureTask.get();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    URI uRI = (URI)iterator.next();
                    FutureTask<DocumentInfo> futureTask2 = new FutureTask<DocumentInfo>(new ParseTask(servletContext, bl, uRI));
                    arrayList4.add(futureTask2);
                    if (executorService != null) {
                        executorService.execute(futureTask2);
                        continue;
                    }
                    futureTask2.run();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                throw new ConfigurationException(exception);
            }
        }
        ArrayList arrayList = new ArrayList(arrayList4.size());
        Iterator iterator = arrayList4.iterator();
        while (iterator.hasNext()) {
            object = (FutureTask)iterator.next();
            try {
                arrayList.add(((FutureTask)object).get());
            }
            catch (ExecutionException executionException) {
                throw new ConfigurationException(executionException);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return arrayList.toArray(new DocumentInfo[arrayList.size()]);
    }

    private static ExecutorService createExecutorService() {
        int n = Runtime.getRuntime().availableProcessors();
        if (n > 5) {
            n = 5;
        }
        return Executors.newFixedThreadPool(n);
    }

    private void releaseFactories() {
        block2: {
            try {
                FactoryFinder.releaseFactories();
            }
            catch (FacesException facesException) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.log(Level.FINE, "Exception thrown from FactoryFinder.releaseFactories()", facesException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class URITask
    implements Callable<Collection<URI>> {
        private ConfigurationResourceProvider provider;
        private ServletContext sc;

        public URITask(ConfigurationResourceProvider configurationResourceProvider, ServletContext servletContext) {
            this.provider = configurationResourceProvider;
            this.sc = servletContext;
        }

        @Override
        public Collection<URI> call() throws Exception {
            Collection<URI> collection = this.provider.getResources(this.sc);
            Iterator<URI> iterator = collection.iterator();
            Collection<URI> collection2 = Collections.emptyList();
            if (iterator.hasNext()) {
                URI uRI = iterator.next();
                if (uRI instanceof URL) {
                    collection2 = new ArrayList<URI>(collection.size());
                    collection2.add(new URI(((URL)((Object)uRI)).toExternalForm()));
                    while (iterator.hasNext()) {
                        uRI = iterator.next();
                        collection2.add(new URI(((URL)((Object)uRI)).toExternalForm()));
                    }
                } else {
                    collection2 = collection;
                }
            }
            return collection2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParseTask
    implements Callable<DocumentInfo> {
        private static final String JAVAEE_SCHEMA_LEGACY_DEFAULT_NS = "http://java.sun.com/xml/ns/javaee";
        private static final String JAVAEE_SCHEMA_DEFAULT_NS = "http://xmlns.jcp.org/xml/ns/javaee";
        private static final String EMPTY_FACES_CONFIG = "com/sun/faces/empty-faces-config.xml";
        private ServletContext servletContext;
        private URI documentURI;
        private DocumentBuilderFactory factory;
        private boolean validating;

        public ParseTask(ServletContext servletContext, boolean bl, URI uRI) throws Exception {
            this.servletContext = servletContext;
            this.documentURI = uRI;
            this.validating = bl;
        }

        @Override
        public DocumentInfo call() throws Exception {
            try {
                Timer timer = Timer.getInstance();
                if (timer != null) {
                    timer.startTiming();
                }
                Document document = this.getDocument();
                if (timer != null) {
                    timer.stopTiming();
                    timer.logResult("Parse " + this.documentURI.toURL().toExternalForm());
                }
                return new DocumentInfo(document, this.documentURI);
            }
            catch (Exception exception) {
                throw new ConfigurationException(MessageFormat.format("Unable to parse document ''{0}'': {1}", this.documentURI.toURL().toExternalForm(), exception.getMessage()), exception);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Document getDocument() throws Exception {
            Document document;
            Object object;
            Object object2;
            Document document2;
            URL uRL;
            block23: {
                DocumentBuilder documentBuilder = this.getNonValidatingBuilder();
                uRL = this.documentURI.toURL();
                InputSource inputSource = new InputSource(ParseTask.getInputStream(uRL));
                inputSource.setSystemId(this.documentURI.toURL().toExternalForm());
                document2 = null;
                try {
                    document2 = documentBuilder.parse(inputSource);
                }
                catch (SAXParseException sAXParseException) {
                    object2 = inputSource.getByteStream();
                    ((InputStream)object2).close();
                    inputSource = new InputSource(ParseTask.getInputStream(uRL));
                    object2 = inputSource.getByteStream();
                    if (!this.streamIsZeroLengthOrEmpty((InputStream)object2) || !uRL.toExternalForm().endsWith("faces-config.xml")) break block23;
                    object = this.getClass().getClassLoader();
                    inputSource = new InputSource(ParseTask.getInputStream(((ClassLoader)object).getResource(EMPTY_FACES_CONFIG)));
                    document2 = documentBuilder.parse(inputSource);
                }
            }
            String string = null;
            if (null == document2) {
                if (FacesFlowDefinitionConfigProcessor.uriIsFlowDefinition(this.documentURI)) {
                    string = JAVAEE_SCHEMA_DEFAULT_NS;
                    document2 = FacesFlowDefinitionConfigProcessor.synthesizeEmptyFlowDefinition(this.documentURI);
                }
            } else {
                string = document2.getDocumentElement().getNamespaceURI();
            }
            if (this.validating && string != null) {
                object2 = new DOMSource(document2, uRL.toExternalForm());
                object = ((Document)((DOMSource)object2).getNode()).getDocumentElement();
                if (JAVAEE_SCHEMA_DEFAULT_NS.equals(string)) {
                    Attr attr = (Attr)object.getAttributes().getNamedItem("version");
                    if (attr == null) throw new ConfigurationException("No document version available.");
                    String string2 = attr.getValue();
                    if (!"2.2".equals(string2)) throw new ConfigurationException("Unknown Schema version: " + string2);
                    Schema schema = "facelet-taglib".equals(object.getLocalName()) ? DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACELET_TAGLIB_22) : DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACES_22);
                    DocumentBuilder documentBuilder = this.getBuilderForSchema(schema);
                    if (documentBuilder.isValidating()) {
                        documentBuilder.getSchema().newValidator().validate((Source)object2);
                        document = (Document)((DOMSource)object2).getNode();
                    } else {
                        document = (Document)((DOMSource)object2).getNode();
                    }
                } else if (JAVAEE_SCHEMA_LEGACY_DEFAULT_NS.equals(string)) {
                    Schema schema;
                    Attr attr = (Attr)object.getAttributes().getNamedItem("version");
                    if (attr == null) throw new ConfigurationException("No document version available.");
                    String string3 = attr.getValue();
                    if ("2.0".equals(string3)) {
                        schema = "facelet-taglib".equals(object.getLocalName()) ? DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACELET_TAGLIB_20) : DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACES_20);
                    } else if ("2.1".equals(string3)) {
                        schema = "facelet-taglib".equals(object.getLocalName()) ? DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACELET_TAGLIB_20) : DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACES_21);
                    } else {
                        if (!"1.2".equals(string3)) throw new ConfigurationException("Unknown Schema version: " + string3);
                        schema = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACES_12);
                    }
                    DocumentBuilder documentBuilder = this.getBuilderForSchema(schema);
                    if (documentBuilder.isValidating()) {
                        documentBuilder.getSchema().newValidator().validate((Source)object2);
                        document = (Document)((DOMSource)object2).getNode();
                    } else {
                        document = (Document)((DOMSource)object2).getNode();
                    }
                } else {
                    Schema schema;
                    DOMResult dOMResult = new DOMResult();
                    Transformer transformer = ParseTask.getTransformer(string);
                    transformer.transform((Source)object2, dOMResult);
                    ((Document)dOMResult.getNode()).setDocumentURI(((Document)((DOMSource)object2).getNode()).getDocumentURI());
                    if (ConfigManager.FACES_CONFIG_1_X_DEFAULT_NS.equals(string)) {
                        schema = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACES_11);
                    } else {
                        if (!ConfigManager.FACELETS_1_0_DEFAULT_NS.equals(string)) throw new IllegalStateException();
                        schema = DbfFactory.getSchema(this.servletContext, DbfFactory.FacesSchema.FACELET_TAGLIB_20);
                    }
                    DocumentBuilder documentBuilder = this.getBuilderForSchema(schema);
                    if (documentBuilder.isValidating()) {
                        documentBuilder.getSchema().newValidator().validate(new DOMSource(dOMResult.getNode()));
                        document = (Document)dOMResult.getNode();
                    } else {
                        document = (Document)dOMResult.getNode();
                    }
                }
            } else {
                document = document2;
            }
            if (!uRL.toExternalForm().contains("/WEB-INF/faces-config.xml")) return document;
            object2 = document.createAttribute(ConfigManager.WEB_INF_MARKER);
            object2.setValue("true");
            document.getDocumentElement().getAttributes().setNamedItem((Node)object2);
            return document;
        }

        private boolean streamIsZeroLengthOrEmpty(InputStream inputStream) throws IOException {
            boolean bl = 0 == inputStream.available();
            byte[] byArray = new byte[1024];
            while (!bl && -1 != inputStream.read(byArray, 0, 1024)) {
                String string = new String(byArray, "UTF-8").trim();
                bl = 0 == string.length();
                byArray[0] = 0;
                for (int i = 1; i < 1024; i += i) {
                    System.arraycopy(byArray, 0, byArray, i, 1024 - i < i ? 1024 - i : i);
                }
            }
            return bl;
        }

        private static Transformer getTransformer(String string) throws Exception {
            String string2;
            TransformerFactory transformerFactory = Util.createTransformerFactory();
            if (ConfigManager.FACES_CONFIG_1_X_DEFAULT_NS.equals(string)) {
                string2 = ConfigManager.FACES_TO_1_1_PRIVATE_XSL;
            } else if (ConfigManager.FACELETS_1_0_DEFAULT_NS.equals(string)) {
                string2 = ConfigManager.FACELETS_TO_2_0_XSL;
            } else {
                throw new IllegalStateException();
            }
            return transformerFactory.newTransformer(new StreamSource(ParseTask.getInputStream(ConfigManager.class.getResource(string2))));
        }

        private static InputStream getInputStream(URL uRL) throws IOException {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            return new BufferedInputStream(uRLConnection.getInputStream());
        }

        private DocumentBuilder getNonValidatingBuilder() throws Exception {
            DocumentBuilderFactory documentBuilderFactory = DbfFactory.getFactory();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
            documentBuilder.setErrorHandler(DbfFactory.FACES_ERROR_HANDLER);
            return documentBuilder;
        }

        private DocumentBuilder getBuilderForSchema(Schema schema) throws Exception {
            this.factory = DbfFactory.getFactory();
            try {
                this.factory.setSchema(schema);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return this.getNonValidatingBuilder();
            }
            DocumentBuilder documentBuilder = this.factory.newDocumentBuilder();
            documentBuilder.setEntityResolver(DbfFactory.FACES_ENTITY_RESOLVER);
            documentBuilder.setErrorHandler(DbfFactory.FACES_ERROR_HANDLER);
            return documentBuilder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationScanTask
    implements Callable<Map<Class<? extends Annotation>, Set<Class<?>>>> {
        private ServletContext sc;
        private InitFacesContext facesContext;
        private AnnotationProvider provider;
        private ProvideMetadataToAnnotationScanTask metadataGetter;

        public AnnotationScanTask(ServletContext servletContext, InitFacesContext initFacesContext, ProvideMetadataToAnnotationScanTask provideMetadataToAnnotationScanTask) {
            this.facesContext = initFacesContext;
            this.provider = AnnotationProviderFactory.createAnnotationProvider(servletContext);
            this.metadataGetter = provideMetadataToAnnotationScanTask;
        }

        @Override
        public Map<Class<? extends Annotation>, Set<Class<?>>> call() throws Exception {
            Timer timer = Timer.getInstance();
            if (timer != null) {
                timer.startTiming();
            }
            this.facesContext.callSetCurrentInstance();
            Set set = null;
            AnnotationScanner annotationScanner = this.metadataGetter.getAnnotationScanner();
            if (this.provider instanceof DelegatingAnnotationProvider && null != annotationScanner) {
                ((DelegatingAnnotationProvider)this.provider).setAnnotationScanner(annotationScanner, this.metadataGetter.getJarNames());
                set = Collections.emptySet();
            } else {
                set = this.metadataGetter.getAnnotationScanURIs();
            }
            Map<Class<? extends Annotation>, Set<Class<?>>> map = this.provider.getAnnotatedClasses(set);
            if (timer != null) {
                timer.stopTiming();
                timer.logResult("Configuration annotation scan complete.");
            }
            return map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProvideMetadataToAnnotationScanTask {
        DocumentInfo[] documentInfos;
        InjectionProvider containerConnector;
        Set<URI> uris = null;
        Set<String> jarNames = null;

        private ProvideMetadataToAnnotationScanTask(DocumentInfo[] documentInfoArray, InjectionProvider injectionProvider) {
            this.documentInfos = documentInfoArray;
            this.containerConnector = injectionProvider;
        }

        private void initializeIvars() {
            if (null != this.uris || null != this.jarNames) {
                assert (null != this.uris && null != this.jarNames);
                return;
            }
            this.uris = new HashSet<URI>(this.documentInfos.length);
            this.jarNames = new HashSet<String>(this.documentInfos.length);
            for (DocumentInfo documentInfo : this.documentInfos) {
                FacesConfigInfo facesConfigInfo;
                String string;
                URI uRI = documentInfo.getSourceURI();
                Matcher matcher = JAR_PATTERN.matcher(uRI.toString());
                if (!matcher.matches() || this.jarNames.contains(string = matcher.group(2)) || (facesConfigInfo = new FacesConfigInfo(documentInfo)).isMetadataComplete()) continue;
                this.uris.add(uRI);
                this.jarNames.add(string);
            }
        }

        private Set<URI> getAnnotationScanURIs() {
            this.initializeIvars();
            return this.uris;
        }

        private Set<String> getJarNames() {
            this.initializeIvars();
            return this.jarNames;
        }

        private AnnotationScanner getAnnotationScanner() {
            AnnotationScanner annotationScanner = null;
            if (this.containerConnector instanceof AnnotationScanner) {
                annotationScanner = (AnnotationScanner)((Object)this.containerConnector);
            }
            return annotationScanner;
        }
    }
}

