/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.ViewScopeContext;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import com.sun.faces.util.cdi11.CDIUtil;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.faces.view.ViewScoped;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewScopeExtension
implements Extension {
    private boolean isCdiOneOneOrGreater = false;
    private CDIUtil cdiUtil = null;
    private static final Logger LOGGER = FacesLogger.APPLICATION_VIEW.getLogger();

    public ViewScopeExtension() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Constructor @ViewScoped CDI Extension called");
        }
        this.isCdiOneOneOrGreater = Util.isCdiOneOneOrGreater();
    }

    public void processBean(@Observes ProcessBean<?> processBean) {
        ViewScoped viewScoped = (ViewScoped)processBean.getAnnotated().getAnnotation(ViewScoped.class);
        if (viewScoped != null && LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Processing occurrence of @ViewScoped");
        }
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        beforeBeanDiscovery.addScope(ViewScoped.class, true, true);
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Adding @ViewScoped context to CDI runtime");
        }
        afterBeanDiscovery.addContext((Context)new ViewScopeContext());
        if (this.isCdiOneOneOrGreater) {
            Bean bean;
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.sun.faces.application.view.ViewScopedCDIEventFireHelperImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "CDI 1.1 events not enabled", classNotFoundException);
                }
                return;
            }
            if (null == this.cdiUtil) {
                bean = ServiceLoader.load(CDIUtil.class);
                for (CDIUtil cDIUtil : bean) {
                    if (null != this.cdiUtil) {
                        String string = "Must only have one implementation of CDIUtil available";
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, string);
                        }
                        throw new IllegalStateException(string);
                    }
                    this.cdiUtil = cDIUtil;
                }
            }
            if (null != this.cdiUtil) {
                bean = this.cdiUtil.createHelperBean(beanManager, clazz);
                afterBeanDiscovery.addBean(bean);
            } else if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unable to obtain CDI 1.1 utilities for Mojarra");
            }
        }
    }
}

