/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.StateHolderSaver;
import com.sun.faces.context.StateContext;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.ComponentStruct;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.StateManagementStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaceletFullStateManagementStrategy
extends StateManagementStrategy {
    private static final Logger LOGGER = FacesLogger.APPLICATION_VIEW.getLogger();
    private static String SKIP_ITERATION_HINT = "javax.faces.visit.SKIP_ITERATION";
    private Map<String, Class<?>> classMap;
    private boolean isDevelopmentMode;

    public FaceletFullStateManagementStrategy() {
        this(FacesContext.getCurrentInstance());
    }

    public FaceletFullStateManagementStrategy(FacesContext facesContext) {
        this.isDevelopmentMode = facesContext.isProjectStage(ProjectStage.Development);
        this.classMap = new ConcurrentHashMap(32);
    }

    private void captureChild(List<TreeNode> list, int n, UIComponent uIComponent) {
        if (!uIComponent.isTransient() && !uIComponent.getAttributes().containsKey("com.sun.faces.DynamicComponent")) {
            TreeNode treeNode = new TreeNode(n, uIComponent);
            int n2 = list.size();
            list.add(treeNode);
            this.captureRest(list, n2, uIComponent);
        }
    }

    private void captureFacet(List<TreeNode> list, int n, String string, UIComponent uIComponent) {
        if (!uIComponent.isTransient() && !uIComponent.getAttributes().containsKey("com.sun.faces.DynamicComponent")) {
            FacetNode facetNode = new FacetNode(n, string, uIComponent);
            int n2 = list.size();
            list.add(facetNode);
            this.captureRest(list, n2, uIComponent);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void captureRest(List<TreeNode> list, int n, UIComponent uIComponent) {
        int n2 = uIComponent.getChildCount();
        if (n2 > 0) {
            void entry;
            List list2 = uIComponent.getChildren();
            boolean i = false;
            while (entry < n2) {
                this.captureChild(list, n, (UIComponent)list2.get((int)entry));
                ++entry;
            }
        }
        if ((n2 = uIComponent.getFacetCount()) > 0) {
            for (Map.Entry entry : uIComponent.getFacets().entrySet()) {
                this.captureFacet(list, n, (String)entry.getKey(), (UIComponent)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UIComponent locateComponentByClientId(FacesContext facesContext, UIComponent uIComponent, final String string) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "FaceletFullStateManagementStrategy.locateComponentByClientId", string);
        }
        final ArrayList arrayList = new ArrayList();
        UIComponent uIComponent2 = null;
        try {
            facesContext.getAttributes().put(SKIP_ITERATION_HINT, true);
            EnumSet<VisitHint> enumSet = EnumSet.of(VisitHint.SKIP_ITERATION);
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, enumSet);
            uIComponent.visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext visitContext, UIComponent uIComponent) {
                    VisitResult visitResult = VisitResult.ACCEPT;
                    if (uIComponent.getClientId(visitContext.getFacesContext()).equals(string)) {
                        arrayList.add(uIComponent);
                        visitResult = VisitResult.COMPLETE;
                    } else if (uIComponent instanceof UIForm) {
                        UIForm uIForm = (UIForm)uIComponent;
                        if (uIForm.isPrependId() && !string.startsWith(uIForm.getClientId(visitContext.getFacesContext()))) {
                            visitResult = VisitResult.REJECT;
                        }
                    } else if (uIComponent instanceof NamingContainer && !string.startsWith(uIComponent.getClientId(visitContext.getFacesContext()))) {
                        visitResult = VisitResult.REJECT;
                    }
                    return visitResult;
                }
            });
        }
        finally {
            facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
        }
        if (!arrayList.isEmpty()) {
            uIComponent2 = (UIComponent)arrayList.get(0);
        }
        return uIComponent2;
    }

    private UIComponent newInstance(TreeNode treeNode) throws FacesException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "FaceletFullStateManagementStrategy.newInstance", treeNode.componentType);
        }
        try {
            Class clazz;
            Class clazz2 = clazz = this.classMap != null ? this.classMap.get(treeNode.componentType) : null;
            if (clazz == null) {
                clazz = Util.loadClass(treeNode.componentType, treeNode);
                if (clazz != null && this.classMap != null) {
                    this.classMap.put(treeNode.componentType, clazz);
                } else if (!this.isDevelopmentMode) {
                    throw new NullPointerException();
                }
            }
            assert (clazz != null);
            UIComponent uIComponent = (UIComponent)clazz.newInstance();
            uIComponent.setId(treeNode.id);
            return uIComponent;
        }
        catch (Exception exception) {
            throw new FacesException((Throwable)exception);
        }
    }

    private void pruneAndReAddToDynamicActions(List<ComponentStruct> list, ComponentStruct componentStruct) {
        int n;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.pruneAndReAddToDynamicActions");
        }
        if ((n = list.indexOf(componentStruct)) == -1) {
            list.add(componentStruct);
        } else {
            int n2 = list.lastIndexOf(componentStruct);
            if (n2 == -1 || n2 == n) {
                list.add(componentStruct);
            } else {
                if ("ADD".equals(componentStruct.action)) {
                    list.remove(n2);
                    list.remove(n);
                    list.add(componentStruct);
                }
                if ("REMOVE".equals(componentStruct.action)) {
                    list.remove(n2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreComponentState(final FacesContext facesContext, final HashMap<String, Object> hashMap) {
        final StateContext stateContext = StateContext.getStateContext(facesContext);
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        try {
            facesContext.getAttributes().put(SKIP_ITERATION_HINT, true);
            EnumSet<VisitHint> enumSet = EnumSet.of(VisitHint.SKIP_ITERATION);
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, enumSet);
            uIViewRoot.visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext visitContext, UIComponent uIComponent) {
                    VisitResult visitResult = VisitResult.ACCEPT;
                    String string = uIComponent.getClientId(facesContext);
                    Object v = hashMap.get(string);
                    if (v != null && !stateContext.componentAddedDynamically(uIComponent)) {
                        boolean bl = true;
                        if (v instanceof StateHolderSaver) {
                            boolean bl2 = bl = !((StateHolderSaver)v).componentAddedDynamically();
                        }
                        if (bl) {
                            try {
                                uIComponent.restoreState(facesContext, v);
                            }
                            catch (Exception exception) {
                                throw new FacesException((Throwable)exception);
                            }
                        }
                    }
                    return visitResult;
                }
            });
        }
        finally {
            facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
        }
    }

    private void restoreDynamicActions(FacesContext facesContext, StateContext stateContext, HashMap<String, Object> hashMap) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.restoreDynamicActions");
        }
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        List list = (List)uIViewRoot.getAttributes().get("com.sun.faces.DynamicActions");
        List<ComponentStruct> list2 = stateContext.getDynamicActions();
        if (list != null && !list.isEmpty()) {
            for (Object e : list) {
                ComponentStruct componentStruct = new ComponentStruct();
                componentStruct.restoreState(facesContext, e);
                if ("ADD".equals(componentStruct.action)) {
                    this.restoreDynamicAdd(facesContext, hashMap, componentStruct);
                }
                if ("REMOVE".equals(componentStruct.action)) {
                    this.restoreDynamicRemove(facesContext, componentStruct);
                }
                this.pruneAndReAddToDynamicActions(list2, componentStruct);
            }
        }
    }

    private void restoreDynamicAdd(FacesContext facesContext, Map<String, Object> map, ComponentStruct componentStruct) {
        UIComponent uIComponent;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.restoreDynamicAdd");
        }
        if ((uIComponent = this.locateComponentByClientId(facesContext, (UIComponent)facesContext.getViewRoot(), componentStruct.parentClientId)) != null) {
            Object object;
            UIComponent uIComponent2 = this.locateComponentByClientId(facesContext, uIComponent, componentStruct.clientId);
            if (uIComponent2 != null) {
                if (componentStruct.facetName == null) {
                    uIComponent.getChildren().remove(uIComponent2);
                } else {
                    uIComponent.getFacets().remove(componentStruct.facetName);
                }
            }
            if (uIComponent2 == null && (object = (StateHolderSaver)map.get(componentStruct.clientId)) != null) {
                uIComponent2 = (UIComponent)((StateHolderSaver)object).restore(facesContext);
            }
            object = StateContext.getStateContext(facesContext);
            if (uIComponent2 == null) {
                uIComponent2 = ((StateContext)object).getDynamicComponents().get(componentStruct.clientId);
            }
            if (uIComponent2 != null) {
                if (componentStruct.facetName != null) {
                    uIComponent.getFacets().put(componentStruct.facetName, uIComponent2);
                } else {
                    int n = -1;
                    if (uIComponent2.getAttributes().containsKey("com.sun.faces.DynamicComponent")) {
                        n = (Integer)uIComponent2.getAttributes().get("com.sun.faces.DynamicComponent");
                    }
                    uIComponent2.setId(componentStruct.id);
                    if (n >= uIComponent.getChildCount() || n == -1) {
                        uIComponent.getChildren().add(uIComponent2);
                    } else {
                        uIComponent.getChildren().add(n, uIComponent2);
                    }
                    uIComponent2.getClientId();
                }
                uIComponent2.getAttributes().put("com.sun.faces.DynamicComponent", uIComponent2.getParent().getChildren().indexOf(uIComponent2));
                ((StateContext)object).getDynamicComponents().put(componentStruct.clientId, uIComponent2);
            }
        }
    }

    private void restoreDynamicRemove(FacesContext facesContext, ComponentStruct componentStruct) {
        UIComponent uIComponent;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.restoreDynamicRemove");
        }
        if ((uIComponent = this.locateComponentByClientId(facesContext, (UIComponent)facesContext.getViewRoot(), componentStruct.clientId)) != null) {
            StateContext stateContext = StateContext.getStateContext(facesContext);
            stateContext.getDynamicComponents().put(componentStruct.clientId, uIComponent);
            UIComponent uIComponent2 = uIComponent.getParent();
            uIComponent2.getChildren().remove(uIComponent);
        }
    }

    private UIViewRoot restoreTree(FacesContext facesContext, String string, Object[] objectArray) throws FacesException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "FaceletFullStateManagementStrategy.restoreTree", string);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            UIComponent uIComponent;
            if (objectArray[i] instanceof FacetNode) {
                FacetNode facetNode = (FacetNode)objectArray[i];
                uIComponent = this.newInstance(facetNode);
                objectArray[i] = uIComponent;
                if (i == facetNode.parent) continue;
                ((UIComponent)objectArray[facetNode.parent]).getFacets().put(facetNode.facetName, uIComponent);
                continue;
            }
            TreeNode treeNode = (TreeNode)objectArray[i];
            uIComponent = this.newInstance(treeNode);
            objectArray[i] = uIComponent;
            if (i != treeNode.parent) {
                ((UIComponent)objectArray[treeNode.parent]).getChildren().add(uIComponent);
                continue;
            }
            assert (uIComponent instanceof UIViewRoot);
            UIViewRoot uIViewRoot = (UIViewRoot)uIComponent;
            facesContext.setViewRoot(uIViewRoot);
            uIViewRoot.setRenderKitId(string);
        }
        return (UIViewRoot)objectArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext facesContext, String string, String string2) {
        Object object;
        Object object2;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "FaceletFullStateManagementStrategy.restoreView", new Object[]{string, string2});
        }
        UIViewRoot uIViewRoot = null;
        ResponseStateManager responseStateManager = RenderKitUtils.getResponseStateManager(facesContext, string2);
        Object[] objectArray = (Object[])responseStateManager.getState(facesContext, string);
        if (objectArray != null && objectArray.length >= 2) {
            if (objectArray[0] != null) {
                uIViewRoot = this.restoreTree(facesContext, string2, (Object[])((Object[])objectArray[0]).clone());
                facesContext.setViewRoot(uIViewRoot);
            }
            if (uIViewRoot != null) {
                object2 = StateContext.getStateContext(facesContext);
                ((StateContext)object2).startTrackViewModifications(facesContext, uIViewRoot);
                ((StateContext)object2).setTrackViewModifications(false);
                try {
                    object = (HashMap)objectArray[1];
                    if (object != null) {
                        this.restoreComponentState(facesContext, (HashMap<String, Object>)object);
                        this.restoreDynamicActions(facesContext, (StateContext)object2, (HashMap<String, Object>)object);
                    }
                }
                finally {
                    ((StateContext)object2).setTrackViewModifications(true);
                }
            }
        }
        object2 = facesContext.getApplication().getViewHandler();
        object = object2.getViewDeclarationLanguage(facesContext, string);
        facesContext.setResourceLibraryContracts(object.calculateResourceLibraryContracts(facesContext, string));
        return uIViewRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object saveComponentState(FacesContext facesContext) {
        final HashMap hashMap = new HashMap();
        final StateContext stateContext = StateContext.getStateContext(facesContext);
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        final FacesContext facesContext2 = facesContext;
        facesContext.getAttributes().put(SKIP_ITERATION_HINT, true);
        EnumSet<VisitHint> enumSet = EnumSet.of(VisitHint.SKIP_ITERATION);
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, enumSet);
        try {
            uIViewRoot.visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext visitContext, UIComponent uIComponent) {
                    VisitResult visitResult = VisitResult.ACCEPT;
                    if (!uIComponent.isTransient()) {
                        Object object;
                        if (stateContext.componentAddedDynamically(uIComponent)) {
                            uIComponent.getAttributes().put("com.sun.faces.DynamicComponent", new Integer(FaceletFullStateManagementStrategy.this.getProperChildIndex(uIComponent)));
                            object = new StateHolderSaver(facesContext2, uIComponent);
                        } else {
                            object = uIComponent.saveState(facesContext2);
                        }
                        if (object != null) {
                            hashMap.put(uIComponent.getClientId(facesContext2), object);
                        }
                    } else {
                        visitResult = VisitResult.REJECT;
                    }
                    return visitResult;
                }
            });
        }
        finally {
            facesContext.getAttributes().remove(SKIP_ITERATION_HINT);
        }
        return hashMap;
    }

    private void saveDynamicActions(FacesContext facesContext, StateContext stateContext, UIViewRoot uIViewRoot) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.saveDynamicActions");
        }
        List<ComponentStruct> list = stateContext.getDynamicActions();
        HashMap<String, UIComponent> hashMap = stateContext.getDynamicComponents();
        if (list != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
            for (ComponentStruct componentStruct : list) {
                UIComponent uIComponent = hashMap.get(componentStruct.clientId);
                if (uIComponent == null && facesContext.isProjectStage(ProjectStage.Development)) {
                    LOGGER.log(Level.WARNING, "Unable to save dynamic action with clientId ''{0}'' because the UIComponent cannot be found", componentStruct.clientId);
                }
                if (uIComponent == null) continue;
                arrayList.add(componentStruct.saveState(facesContext));
            }
            uIViewRoot.getAttributes().put("com.sun.faces.DynamicActions", arrayList);
        }
    }

    public Object saveView(FacesContext facesContext) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.saveView");
        }
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        Util.checkIdUniqueness(facesContext, (UIComponent)uIViewRoot, new HashSet<String>(uIViewRoot.getChildCount() << 1));
        StateContext stateContext = StateContext.getStateContext(facesContext);
        this.saveDynamicActions(facesContext, stateContext, uIViewRoot);
        Object object = this.saveComponentState(facesContext);
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(32);
        this.captureChild(arrayList, 0, (UIComponent)uIViewRoot);
        Object[] objectArray = arrayList.toArray();
        Object[] objectArray2 = new Object[]{objectArray, object};
        StateContext.release(facesContext);
        return objectArray2;
    }

    private int getProperChildIndex(UIComponent uIComponent) {
        int n = -1;
        if (uIComponent.getParent().getChildren().indexOf(uIComponent) != -1) {
            UIComponent uIComponent2;
            UIComponent uIComponent3 = uIComponent.getParent();
            int n2 = 0;
            Iterator iterator = uIComponent3.getChildren().iterator();
            while (iterator.hasNext() && (uIComponent2 = (UIComponent)iterator.next()) != uIComponent) {
                if (uIComponent2.isTransient()) continue;
                ++n2;
            }
            if (n2 == 0 && !uIComponent3.getChildren().isEmpty() && ((UIComponent)uIComponent3.getChildren().get(0)).isTransient()) {
                n2 = -1;
            }
            n = n2;
        }
        return n;
    }

    private static class TreeNode
    implements Externalizable {
        private static final long serialVersionUID = -835775352718473281L;
        private static final String NULL_ID = "";
        public String componentType;
        public String id;
        public int parent;

        public TreeNode() {
        }

        public TreeNode(int n, UIComponent uIComponent) {
            this.parent = n;
            this.id = uIComponent.getId();
            this.componentType = uIComponent.getClass().getName();
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.parent = objectInput.readInt();
            this.componentType = objectInput.readUTF();
            this.id = objectInput.readUTF();
            if (this.id.length() == 0) {
                this.id = null;
            }
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.parent);
            objectOutput.writeUTF(this.componentType);
            if (this.id != null) {
                objectOutput.writeUTF(this.id);
            } else {
                objectOutput.writeUTF(NULL_ID);
            }
        }
    }

    private static final class FacetNode
    extends TreeNode {
        private static final long serialVersionUID = -3777170310958005106L;
        public String facetName;

        public FacetNode() {
        }

        public FacetNode(int n, String string, UIComponent uIComponent) {
            super(n, uIComponent);
            this.facetName = string;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this.facetName = objectInput.readUTF();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            super.writeExternal(objectOutput);
            objectOutput.writeUTF(this.facetName);
        }
    }
}

