/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.VersionInfo;

public class LibraryInfo {
    private String name;
    private VersionInfo version;
    private String localePrefix;
    private String contract;
    private ResourceHelper helper;
    private String path;
    private String nonLocalizedPath;

    LibraryInfo(String string, VersionInfo versionInfo, String string2, String string3, ResourceHelper resourceHelper) {
        this.name = string;
        this.version = versionInfo;
        this.localePrefix = string2;
        this.contract = string3;
        this.helper = resourceHelper;
        this.initPath();
    }

    LibraryInfo(LibraryInfo libraryInfo, boolean bl) {
        this.name = libraryInfo.name;
        this.version = libraryInfo.version;
        if (bl) {
            this.contract = libraryInfo.contract;
            this.localePrefix = libraryInfo.localePrefix;
        }
        this.helper = libraryInfo.helper;
        this.initPath();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        LibraryInfo libraryInfo = (LibraryInfo)object;
        if (this.name == null ? libraryInfo.name != null : !this.name.equals(libraryInfo.name)) {
            return false;
        }
        if (!(this.version == libraryInfo.version || this.version != null && this.version.equals(libraryInfo.version))) {
            return false;
        }
        if (this.localePrefix == null ? libraryInfo.localePrefix != null : !this.localePrefix.equals(libraryInfo.localePrefix)) {
            return false;
        }
        if (this.contract == null ? libraryInfo.contract != null : !this.contract.equals(libraryInfo.contract)) {
            return false;
        }
        return !(this.path == null ? libraryInfo.path != null : !this.path.equals(libraryInfo.path));
    }

    public int hashCode() {
        int n = 5;
        n = 37 * n + (this.name != null ? this.name.hashCode() : 0);
        n = 37 * n + (this.version != null ? this.version.hashCode() : 0);
        n = 37 * n + (this.localePrefix != null ? this.localePrefix.hashCode() : 0);
        n = 37 * n + (this.contract != null ? this.contract.hashCode() : 0);
        n = 37 * n + (this.path != null ? this.path.hashCode() : 0);
        return n;
    }

    public String getName() {
        return this.name;
    }

    public VersionInfo getVersion() {
        return this.version;
    }

    public ResourceHelper getHelper() {
        return this.helper;
    }

    public String getPath() {
        return this.path;
    }

    public String getPath(String string) {
        String string2 = null;
        string2 = null == string ? this.nonLocalizedPath : this.path;
        return string2;
    }

    public String getLocalePrefix() {
        return this.localePrefix;
    }

    public String getContract() {
        return this.contract;
    }

    public String toString() {
        return "LibraryInfo{name='" + (this.name != null ? this.name : "NONE") + '\'' + ", version=" + (this.version != null ? this.version : "NONE") + '\'' + ", localePrefix='" + (this.localePrefix != null ? this.localePrefix : "NONE") + '\'' + ", contract='" + (this.contract != null ? this.contract : "NONE") + '\'' + ", path='" + this.path + '\'' + '}';
    }

    private void initPath() {
        StringBuilder stringBuilder = new StringBuilder(64);
        StringBuilder stringBuilder2 = new StringBuilder(64);
        this.appendBasePath(stringBuilder);
        this.appendBasePath(stringBuilder2);
        if (this.localePrefix != null) {
            stringBuilder.append('/').append(this.localePrefix);
        }
        if (this.name != null) {
            stringBuilder.append('/').append(this.name);
            stringBuilder2.append('/').append(this.name);
        }
        if (this.version != null) {
            stringBuilder.append('/').append(this.version.getVersion());
            stringBuilder2.append('/').append(this.version.getVersion());
        }
        this.path = stringBuilder.toString();
        this.nonLocalizedPath = stringBuilder2.toString();
    }

    private void appendBasePath(StringBuilder stringBuilder) {
        if (this.contract == null) {
            stringBuilder.append(this.helper.getBaseResourcePath());
        } else {
            stringBuilder.append(this.helper.getBaseContractsPath()).append('/').append(this.contract);
        }
    }
}

