/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.annotation.BehaviorConfigHandler;
import com.sun.faces.application.annotation.ComponentConfigHandler;
import com.sun.faces.application.annotation.ConfigAnnotationHandler;
import com.sun.faces.application.annotation.ConverterConfigHandler;
import com.sun.faces.application.annotation.ListenerForScanner;
import com.sun.faces.application.annotation.ManagedBeanConfigHandler;
import com.sun.faces.application.annotation.NamedEventConfigHandler;
import com.sun.faces.application.annotation.RenderKitConfigHandler;
import com.sun.faces.application.annotation.ResourceDependencyScanner;
import com.sun.faces.application.annotation.RuntimeAnnotationHandler;
import com.sun.faces.application.annotation.Scanner;
import com.sun.faces.application.annotation.ValidatorConfigHandler;
import com.sun.faces.util.FacesLogger;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehaviorBase;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.SystemEvent;
import javax.faces.render.ClientBehaviorRenderer;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationManager {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final Scanner RESOURCE_DEPENDENCY_SCANNER = new ResourceDependencyScanner();
    private static final Scanner LISTENER_FOR_SCANNER = new ListenerForScanner();
    private static final Scanner[] BEHAVIOR_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER};
    private static final Scanner[] CLIENT_BEHAVIOR_RENDERER_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER};
    private static final Scanner[] UICOMPONENT_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER, LISTENER_FOR_SCANNER};
    private static final Scanner[] VALIDATOR_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER};
    private static final Scanner[] CONVERTER_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER};
    private static final Scanner[] RENDERER_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER, LISTENER_FOR_SCANNER};
    private static final Scanner[] EVENTS_SCANNERS = new Scanner[]{RESOURCE_DEPENDENCY_SCANNER};
    private ConcurrentMap<Class<?>, Future<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>>> cache = new ConcurrentHashMap(40, 0.75f, 32);

    public void applyConfigAnnotations(FacesContext facesContext, Class<? extends Annotation> clazz, Set<? extends Class> set) {
        if (set != null && !set.isEmpty()) {
            ConfigAnnotationHandler configAnnotationHandler = this.getConfigAnnotationHandlers().get(clazz);
            if (configAnnotationHandler == null) {
                throw new IllegalStateException("Internal Error: No ConfigAnnotationHandler for type: " + clazz);
            }
            for (Class clazz2 : set) {
                configAnnotationHandler.collect(clazz2, clazz2.getAnnotation(clazz));
            }
            configAnnotationHandler.push(facesContext);
        }
    }

    public void applyBehaviorAnnotations(FacesContext facesContext, Behavior behavior) {
        this.applyAnnotations(facesContext, behavior.getClass(), ProcessingTarget.Behavior, behavior);
        if (behavior instanceof ClientBehaviorBase) {
            ClientBehaviorRenderer clientBehaviorRenderer;
            ClientBehaviorBase clientBehaviorBase = (ClientBehaviorBase)behavior;
            String string = clientBehaviorBase.getRendererType();
            RenderKit renderKit = facesContext.getRenderKit();
            if (null != string && null != renderKit && null != (clientBehaviorRenderer = renderKit.getClientBehaviorRenderer(string))) {
                this.applyClientBehaviorRendererAnnotations(facesContext, clientBehaviorRenderer);
            }
        }
    }

    public void applyClientBehaviorRendererAnnotations(FacesContext facesContext, ClientBehaviorRenderer clientBehaviorRenderer) {
        this.applyAnnotations(facesContext, clientBehaviorRenderer.getClass(), ProcessingTarget.ClientBehaviorRenderer, clientBehaviorRenderer);
    }

    public void applyComponentAnnotations(FacesContext facesContext, UIComponent uIComponent) {
        this.applyAnnotations(facesContext, uIComponent.getClass(), ProcessingTarget.UIComponent, uIComponent);
    }

    public void applyValidatorAnnotations(FacesContext facesContext, Validator validator) {
        this.applyAnnotations(facesContext, validator.getClass(), ProcessingTarget.Validator, validator);
    }

    public void applyConverterAnnotations(FacesContext facesContext, Converter converter) {
        this.applyAnnotations(facesContext, converter.getClass(), ProcessingTarget.Converter, converter);
    }

    public void applyRendererAnnotations(FacesContext facesContext, Renderer renderer, UIComponent uIComponent) {
        this.applyAnnotations(facesContext, renderer.getClass(), ProcessingTarget.Renderer, renderer, uIComponent);
    }

    public void applySystemEventAnnotations(FacesContext facesContext, SystemEvent systemEvent) {
        this.applyAnnotations(facesContext, systemEvent.getClass(), ProcessingTarget.SystemEvent, systemEvent);
    }

    private Map<Class<? extends Annotation>, ConfigAnnotationHandler> getConfigAnnotationHandlers() {
        ConfigAnnotationHandler[] configAnnotationHandlerArray = new ConfigAnnotationHandler[]{new ComponentConfigHandler(), new ConverterConfigHandler(), new ValidatorConfigHandler(), new BehaviorConfigHandler(), new RenderKitConfigHandler(), new ManagedBeanConfigHandler(), new NamedEventConfigHandler()};
        HashMap<Class<? extends Annotation>, ConfigAnnotationHandler> hashMap = new HashMap<Class<? extends Annotation>, ConfigAnnotationHandler>();
        for (ConfigAnnotationHandler configAnnotationHandler : configAnnotationHandlerArray) {
            Collection<Class<? extends Annotation>> collection = configAnnotationHandler.getHandledAnnotations();
            for (Class<? extends Annotation> clazz : collection) {
                hashMap.put(clazz, configAnnotationHandler);
            }
        }
        return hashMap;
    }

    private void applyAnnotations(FacesContext facesContext, Class<?> clazz, ProcessingTarget processingTarget, Object ... objectArray) {
        Map<Class<? extends Annotation>, RuntimeAnnotationHandler> map = this.getHandlerMap(clazz, processingTarget);
        if (map != null && !map.isEmpty()) {
            for (RuntimeAnnotationHandler runtimeAnnotationHandler : map.values()) {
                runtimeAnnotationHandler.apply(facesContext, objectArray);
            }
        }
    }

    /*
     * Loose catch block
     */
    private Map<Class<? extends Annotation>, RuntimeAnnotationHandler> getHandlerMap(Class<?> clazz, ProcessingTarget processingTarget) {
        while (true) {
            ProcessAnnotationsTask processAnnotationsTask;
            FutureTask<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>> futureTask;
            FutureTask<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>> futureTask2;
            if ((futureTask2 = (FutureTask<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>>)this.cache.get(clazz)) == null && (futureTask2 = (Future)this.cache.putIfAbsent(clazz, futureTask = new FutureTask<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>>(processAnnotationsTask = new ProcessAnnotationsTask(clazz, processingTarget.scanners)))) == null) {
                futureTask2 = futureTask;
                futureTask.run();
            }
            try {
                return (Map)futureTask2.get();
            }
            catch (CancellationException cancellationException) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, cancellationException.toString(), cancellationException);
                }
                this.cache.remove(clazz);
                continue;
            }
            catch (InterruptedException interruptedException) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, interruptedException.toString(), interruptedException);
                }
                this.cache.remove(clazz);
                continue;
            }
            break;
        }
        catch (ExecutionException executionException) {
            throw new FacesException((Throwable)executionException);
        }
    }

    static /* synthetic */ Scanner[] access$000() {
        return BEHAVIOR_SCANNERS;
    }

    static /* synthetic */ Scanner[] access$100() {
        return CLIENT_BEHAVIOR_RENDERER_SCANNERS;
    }

    static /* synthetic */ Scanner[] access$200() {
        return UICOMPONENT_SCANNERS;
    }

    static /* synthetic */ Scanner[] access$300() {
        return VALIDATOR_SCANNERS;
    }

    static /* synthetic */ Scanner[] access$400() {
        return CONVERTER_SCANNERS;
    }

    static /* synthetic */ Scanner[] access$500() {
        return RENDERER_SCANNERS;
    }

    static /* synthetic */ Scanner[] access$600() {
        return EVENTS_SCANNERS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProcessAnnotationsTask
    implements Callable<Map<Class<? extends Annotation>, RuntimeAnnotationHandler>> {
        private static final Map<Class<? extends Annotation>, RuntimeAnnotationHandler> EMPTY = Collections.EMPTY_MAP;
        private Class<?> clazz;
        private Scanner[] scanners;

        public ProcessAnnotationsTask(Class<?> clazz, Scanner[] scannerArray) {
            this.clazz = clazz;
            this.scanners = scannerArray;
        }

        @Override
        public Map<Class<? extends Annotation>, RuntimeAnnotationHandler> call() throws Exception {
            Map<Class<? extends Annotation>, RuntimeAnnotationHandler> map = null;
            for (Scanner scanner : this.scanners) {
                RuntimeAnnotationHandler runtimeAnnotationHandler = scanner.scan(this.clazz);
                if (runtimeAnnotationHandler == null) continue;
                if (map == null) {
                    map = new HashMap<Class<? extends Annotation>, RuntimeAnnotationHandler>(2, 1.0f);
                }
                map.put(scanner.getAnnotation(), runtimeAnnotationHandler);
            }
            return map != null ? map : EMPTY;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ProcessingTarget {
        Behavior(AnnotationManager.access$000()),
        ClientBehaviorRenderer(AnnotationManager.access$100()),
        UIComponent(AnnotationManager.access$200()),
        Validator(AnnotationManager.access$300()),
        Converter(AnnotationManager.access$400()),
        Renderer(AnnotationManager.access$500()),
        SystemEvent(AnnotationManager.access$600());

        private Scanner[] scanners;

        private ProcessingTarget(Scanner[] scannerArray) {
            this.scanners = scannerArray;
        }
    }
}

