/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.MessageUtils;
import java.util.EnumSet;
import javax.faces.application.FacesMessage;
import javax.faces.component.ActionSource;
import javax.faces.component.ActionSource2;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewAction;
import javax.faces.component.UIViewParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

public class ValidateComponentNesting
implements SystemEventListener {
    public boolean isListenerForSource(Object object) {
        return object instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent systemEvent) throws AbortProcessingException {
        UIComponent uIComponent = (UIComponent)systemEvent.getSource();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        EnumSet<VisitHint> enumSet = EnumSet.of(VisitHint.SKIP_ITERATION);
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)facesContext, null, enumSet);
        uIComponent.visitTree(visitContext, (VisitCallback)new ValidateFormNestingCallback());
    }

    private static void addOmittedMessage(FacesContext facesContext, String string, String string2) {
        Object[] objectArray = new Object[]{};
        FacesMessage facesMessage = MessageUtils.getExceptionMessage(string2, objectArray);
        facesMessage.setSeverity(FacesMessage.SEVERITY_WARN);
        facesContext.addMessage(string, facesMessage);
    }

    static class ValidateFormNestingCallback
    implements VisitCallback {
        boolean reportedOmittedFormOnce = false;
        boolean reportedOmittedMetadataOnce = false;

        ValidateFormNestingCallback() {
        }

        public VisitResult visit(VisitContext visitContext, UIComponent uIComponent) {
            VisitResult visitResult = VisitResult.ACCEPT;
            if (uIComponent instanceof UIForm || uIComponent.getFamily().endsWith("Form") || "javax_faces_metadata".equals(uIComponent.getId())) {
                visitResult = VisitResult.REJECT;
            } else if (uIComponent instanceof UIViewParameter || uIComponent instanceof UIViewAction) {
                if (this.reportedOmittedMetadataOnce) {
                    visitResult = VisitResult.COMPLETE;
                }
                ValidateComponentNesting.addOmittedMessage(visitContext.getFacesContext(), uIComponent.getClientId(visitContext.getFacesContext()), "com.sun.faces.MISSING_METADATA_ERROR");
                this.reportedOmittedMetadataOnce = true;
            } else if (uIComponent instanceof EditableValueHolder || uIComponent instanceof ActionSource || uIComponent instanceof ActionSource2) {
                if (this.reportedOmittedFormOnce) {
                    visitResult = VisitResult.COMPLETE;
                }
                ValidateComponentNesting.addOmittedMessage(visitContext.getFacesContext(), uIComponent.getClientId(visitContext.getFacesContext()), "com.sun.faces.MISSING_FORM_ERROR");
                this.reportedOmittedFormOnce = true;
            }
            return visitResult;
        }
    }
}

