/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.SharedUtils;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.flow.FlowImpl;
import com.sun.faces.flow.builder.MutableNavigationCase;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationCase;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewAction;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.context.PartialViewContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowCallNode;
import javax.faces.flow.FlowHandler;
import javax.faces.flow.FlowNode;
import javax.faces.flow.MethodCallNode;
import javax.faces.flow.Parameter;
import javax.faces.flow.ReturnNode;
import javax.faces.flow.SwitchCase;
import javax.faces.flow.SwitchNode;
import javax.faces.flow.ViewNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationHandlerImpl
extends ConfigurableNavigationHandler {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    private volatile Map<String, NavigationInfo> navigationMaps;
    private boolean development;
    private static final Pattern REDIRECT_EQUALS_TRUE = Pattern.compile("(.*)(faces-redirect=true)(.*)");
    private static final Pattern INCLUDE_VIEW_PARAMS_EQUALS_TRUE = Pattern.compile("(.*)(includeViewParams=true)(.*)");
    private static final String ROOT_NAVIGATION_MAP_ID = NavigationHandlerImpl.class.getName() + ".NAVIGATION_MAP";
    private static final String DID_TRANSITION_FLAG = "com.sun.faces.NavigationHandlerDidTransition";

    public NavigationHandlerImpl() {
        ApplicationAssociate applicationAssociate;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created NavigationHandler instance ");
        }
        if ((applicationAssociate = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext())) != null) {
            this.development = applicationAssociate.isDevModeEnabled();
        }
    }

    public NavigationCase getNavigationCase(FacesContext facesContext, String string, String string2) {
        return this.getNavigationCase(facesContext, string, string2, "");
    }

    public NavigationCase getNavigationCase(FacesContext facesContext, String string, String string2, String string3) {
        Util.notNull("context", facesContext);
        Util.notNull("toFlowDocumentId", string3);
        NavigationCase navigationCase = null;
        CaseStruct caseStruct = this.getViewId(facesContext, string, string2, string3);
        if (null != caseStruct) {
            navigationCase = caseStruct.navCase;
        }
        return navigationCase;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map<String, Set<NavigationCase>> map = this.getNavigationMap(facesContext);
        return map;
    }

    public void inspectFlow(FacesContext facesContext, Flow flow) {
        this.initializeNavigationFromFlow(facesContext, flow);
    }

    public void handleNavigation(FacesContext facesContext, String string, String string2) {
        this.handleNavigation(facesContext, string, string2, "");
    }

    public void handleNavigation(FacesContext facesContext, String string, String string2, String string3) {
        Util.notNull("context", facesContext);
        CaseStruct caseStruct = this.getViewId(facesContext, string, string2, string3);
        if (caseStruct != null) {
            String string4;
            String string5;
            ExternalContext externalContext = facesContext.getExternalContext();
            ViewHandler viewHandler = Util.getViewHandler(facesContext);
            assert (null != viewHandler);
            Flash flash = externalContext.getFlash();
            boolean bl = false;
            if (UIViewAction.isProcessingBroadcast((FacesContext)facesContext)) {
                flash.setKeepMessages(true);
                string5 = facesContext.getViewRoot().getViewId();
                string5 = null == string5 ? "" : string5;
                string4 = caseStruct.navCase.getToViewId(facesContext);
                string4 = null == string4 ? "" : string4;
                boolean bl2 = bl = !string5.equals(string4);
            }
            if (caseStruct.navCase.isRedirect() || bl) {
                string5 = viewHandler.getRedirectURL(facesContext, caseStruct.viewId, SharedUtils.evaluateExpressions(facesContext, caseStruct.navCase.getParameters()), caseStruct.navCase.isIncludeViewParams());
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Redirecting to path {0} for outcome {1}and viewId {2}", new Object[]{string5, string2, caseStruct.viewId});
                    }
                    this.updateRenderTargets(facesContext, caseStruct.viewId);
                    flash.setRedirect(true);
                    externalContext.redirect(string5);
                }
                catch (IOException iOException) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "jsf.redirect_failed_error", string5);
                    }
                    throw new FacesException(iOException.getMessage(), (Throwable)iOException);
                }
                facesContext.responseComplete();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Response complete for {0}", caseStruct.viewId);
                }
            } else {
                string5 = viewHandler.createView(facesContext, caseStruct.viewId);
                this.updateRenderTargets(facesContext, caseStruct.viewId);
                facesContext.setViewRoot((UIViewRoot)string5);
                string4 = facesContext.getApplication().getFlowHandler();
                if (null != string4 && !this.isDidTransition(facesContext)) {
                    string4.transition(facesContext, caseStruct.currentFlow, caseStruct.newFlow, caseStruct.facesFlowCallNode, caseStruct.viewId);
                    this.setDidTransition(facesContext, false);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Set new view in FacesContext for {0}", caseStruct.viewId);
                }
            }
            this.clearViewMapIfNecessary(facesContext, caseStruct.viewId);
        }
    }

    private Map<String, Set<NavigationCase>> getRootNavigationMap(FacesContext facesContext) {
        Map<String, Set<NavigationCase>> map = null;
        NavigationInfo navigationInfo = null;
        if (null == this.navigationMaps) {
            this.createNavigationMaps();
            map = this.navigationMaps.get(ROOT_NAVIGATION_MAP_ID).ruleSet;
        } else {
            navigationInfo = this.navigationMaps.get(ROOT_NAVIGATION_MAP_ID);
            map = null == navigationInfo.ruleSet ? Collections.emptyMap() : navigationInfo.ruleSet;
        }
        return map;
    }

    private Map<String, Set<NavigationCase>> getNavigationMap(FacesContext facesContext) {
        Map<String, Set<NavigationCase>> map = null;
        NavigationInfo navigationInfo = null;
        if (null == this.navigationMaps) {
            this.createNavigationMaps();
            map = this.navigationMaps.get(ROOT_NAVIGATION_MAP_ID).ruleSet;
        } else {
            Flow flow;
            FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
            if (null != flowHandler && null != (flow = flowHandler.getCurrentFlow(facesContext)) && null == (navigationInfo = this.navigationMaps.get(flow.getDefiningDocumentId() + flow.getId()))) {
                return Collections.emptyMap();
            }
            if (null == navigationInfo) {
                navigationInfo = this.navigationMaps.get(ROOT_NAVIGATION_MAP_ID);
            }
            map = null == navigationInfo.ruleSet ? Collections.emptyMap() : navigationInfo.ruleSet;
        }
        return map;
    }

    private void createNavigationMaps() {
        if (null == this.navigationMaps) {
            ConcurrentHashMap<String, NavigationInfo> concurrentHashMap = new ConcurrentHashMap<String, NavigationInfo>();
            NavigationMap navigationMap = new NavigationMap();
            NavigationInfo navigationInfo = new NavigationInfo();
            navigationInfo.ruleSet = navigationMap;
            concurrentHashMap.put(ROOT_NAVIGATION_MAP_ID, navigationInfo);
            this.navigationMaps = concurrentHashMap;
        }
    }

    private Map<String, Set<NavigationCase>> getRootNavigationMap() {
        this.createNavigationMaps();
        return this.navigationMaps.get(ROOT_NAVIGATION_MAP_ID).ruleSet;
    }

    private Set<String> getWildCardMatchList(FacesContext facesContext) {
        Flow flow;
        TreeSet treeSet = Collections.emptySet();
        NavigationInfo navigationInfo = null;
        FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
        if (null != flowHandler && null != (flow = flowHandler.getCurrentFlow(facesContext))) {
            navigationInfo = this.navigationMaps.get(flow.getDefiningDocumentId() + flow.getId());
        }
        if (null == navigationInfo) {
            navigationInfo = this.navigationMaps.get(ROOT_NAVIGATION_MAP_ID);
        }
        if (null != navigationInfo.ruleSet && null != navigationInfo.ruleSet.wildcardMatchList) {
            treeSet = navigationInfo.ruleSet.wildcardMatchList;
        }
        return treeSet;
    }

    private NavigationInfo getNavigationInfo(FacesContext facesContext, String string, String string2) {
        Flow flow;
        FlowHandler flowHandler;
        NavigationInfo navigationInfo = null;
        assert (null != this.navigationMaps);
        navigationInfo = this.navigationMaps.get(string + string2);
        if (null == navigationInfo && null != (flowHandler = facesContext.getApplication().getFlowHandler()) && null != (flow = flowHandler.getCurrentFlow(facesContext))) {
            navigationInfo = this.navigationMaps.get(flow.getDefiningDocumentId() + flow.getId());
        }
        return navigationInfo;
    }

    private void initializeNavigationFromAssociate() {
        ApplicationAssociate applicationAssociate = ApplicationAssociate.getCurrentInstance();
        if (applicationAssociate != null) {
            Map<String, Set<NavigationCase>> map = applicationAssociate.getNavigationCaseListMappings();
            Map<String, Set<NavigationCase>> map2 = this.getRootNavigationMap();
            if (map != null) {
                map2.putAll(map);
            }
        }
    }

    private void initializeNavigationFromFlow(FacesContext facesContext, Flow flow) {
        if (facesContext instanceof InitFacesContext) {
            this.createNavigationMaps();
            this.initializeNavigationFromFlowNonThreadSafe(flow);
        } else {
            assert (null != this.navigationMaps);
            this.initializeNavigationFromFlowThreadSafe(flow);
        }
    }

    private void initializeNavigationFromFlowNonThreadSafe(Flow flow) {
        String string = flow.getDefiningDocumentId() + flow.getId();
        if (this.navigationMaps.containsKey(string)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "PENDING(edburns): merge existing map");
            }
        } else {
            Map map = flow.getNavigationCases();
            Map map2 = flow.getSwitches();
            if (!map.isEmpty() || !map2.isEmpty()) {
                NavigationInfo navigationInfo = new NavigationInfo();
                if (!map2.isEmpty()) {
                    navigationInfo.switches = new ConcurrentHashMap();
                    for (Map.Entry entry : map2.entrySet()) {
                        navigationInfo.switches.put(entry.getKey(), entry.getValue());
                    }
                }
                if (!map.isEmpty()) {
                    navigationInfo.ruleSet = new NavigationMap();
                    navigationInfo.ruleSet.putAll(map);
                }
                this.navigationMaps.put(string, navigationInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNavigationFromFlowThreadSafe(Flow flow) {
        NavigationHandlerImpl navigationHandlerImpl = this;
        synchronized (navigationHandlerImpl) {
            this.initializeNavigationFromFlowNonThreadSafe(flow);
        }
    }

    private void clearViewMapIfNecessary(FacesContext facesContext, String string) {
        Map map;
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        if (uIViewRoot != null && !uIViewRoot.getViewId().equals(string) && (map = uIViewRoot.getViewMap(false)) != null) {
            map.clear();
        }
    }

    private void updateRenderTargets(FacesContext facesContext, String string) {
        PartialViewContext partialViewContext;
        if (!(facesContext.getViewRoot() != null && facesContext.getViewRoot().getViewId().equals(string) || (partialViewContext = facesContext.getPartialViewContext()).isRenderAll())) {
            partialViewContext.setRenderAll(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseStruct getViewId(FacesContext facesContext, String string, String string2, String string3) {
        FacesMessage facesMessage;
        Object[] objectArray;
        Object object;
        NavigationHandlerImpl navigationHandlerImpl;
        if (this.navigationMaps == null) {
            navigationHandlerImpl = this;
            synchronized (navigationHandlerImpl) {
                this.initializeNavigationFromAssociate();
            }
        }
        String string4 = (navigationHandlerImpl = facesContext.getViewRoot()) != null ? navigationHandlerImpl.getViewId() : null;
        CaseStruct caseStruct = null;
        Map<String, Set<NavigationCase>> map = this.getNavigationMap(facesContext);
        if (string4 != null && (caseStruct = this.findExactMatch(facesContext, string4, string, string2, string3, map)) == null) {
            caseStruct = this.findWildCardMatch(facesContext, string4, string, string2, string3, map);
        }
        if (caseStruct == null) {
            caseStruct = this.findDefaultMatch(facesContext, string, string2, string3, map);
        }
        if (null != caseStruct && caseStruct.isFlowEntryFromExplicitRule) {
            string3 = null != caseStruct.navCase.getToFlowDocumentId() ? caseStruct.navCase.getToFlowDocumentId() : string3;
            caseStruct = this.findFacesFlowCallMatch(facesContext, string, string2, string3);
        }
        if (null == caseStruct && null != string && null != string2) {
            caseStruct = this.findViewNodeMatch(facesContext, string, string2, string3);
        }
        if (null == caseStruct && null != string && null != string2) {
            caseStruct = this.findSwitchMatch(facesContext, string, string2, string3);
        }
        if (null == caseStruct && null != string && null != string2) {
            caseStruct = this.findMethodCallMatch(facesContext, string, string2);
        }
        if (null == caseStruct && null != string2) {
            caseStruct = this.findFacesFlowCallMatch(facesContext, string, string2, string3);
        }
        if (null == caseStruct && null != string2) {
            caseStruct = this.findReturnMatch(facesContext, string, string2);
        }
        if (caseStruct == null && string2 != null && string4 != null) {
            if (0 == string2.length()) {
                string2 = null;
            } else {
                caseStruct = this.findImplicitMatch(facesContext, string4, string, string2, string3);
            }
        }
        if (caseStruct == null && string2 != null && string4 != null && null != (object = facesContext.getApplication().getFlowHandler())) {
            objectArray = null;
            facesMessage = null;
            objectArray = object.getCurrentFlow(facesContext);
            if (null != objectArray) {
                caseStruct = this.findRootNavigationMapAbandonedFlowMatch(facesContext, string4, string, string2, string3);
            }
        }
        if (caseStruct == null && string2 != null && this.development) {
            if (string == null) {
                object = "com.sun.faces.NAVIGATION_NO_MATCHING_OUTCOME";
                objectArray = new Object[]{string4, string2};
            } else {
                object = "com.sun.faces.NAVIGATION_NO_MATCHING_OUTCOME_ACTION";
                objectArray = new Object[]{string4, string, string2};
            }
            facesMessage = MessageUtils.getExceptionMessage((String)object, objectArray);
            facesMessage.setSeverity(FacesMessage.SEVERITY_WARN);
            facesContext.addMessage(null, facesMessage);
        }
        return caseStruct;
    }

    private CaseStruct findExactMatch(FacesContext facesContext, String string, String string2, String string3, String string4, Map<String, Set<NavigationCase>> map) {
        FlowHandler flowHandler;
        Set<NavigationCase> set = map.get(string);
        if (set == null) {
            return null;
        }
        CaseStruct caseStruct = this.determineViewFromActionOutcome(facesContext, set, string2, string3, string4);
        if (null != caseStruct && null != (flowHandler = facesContext.getApplication().getFlowHandler())) {
            caseStruct.newFlow = caseStruct.currentFlow = flowHandler.getCurrentFlow(facesContext);
        }
        return caseStruct;
    }

    private CaseStruct findWildCardMatch(FacesContext facesContext, String string, String string2, String string3, String string4, Map<String, Set<NavigationCase>> map) {
        CaseStruct caseStruct = null;
        FlowHandler flowHandler = this.getWildCardMatchList(facesContext).iterator();
        while (flowHandler.hasNext()) {
            String string5 = flowHandler.next();
            if (!string.startsWith(string5)) continue;
            String string6 = new StringBuilder(32).append(string5).append('*').toString();
            Set<NavigationCase> set = map.get(string6);
            if (set == null) {
                return null;
            }
            caseStruct = this.determineViewFromActionOutcome(facesContext, set, string2, string3, string4);
            if (caseStruct == null) continue;
            break;
        }
        if (null != caseStruct && null != (flowHandler = facesContext.getApplication().getFlowHandler())) {
            caseStruct.newFlow = caseStruct.currentFlow = flowHandler.getCurrentFlow(facesContext);
        }
        return caseStruct;
    }

    private CaseStruct findDefaultMatch(FacesContext facesContext, String string, String string2, String string3, Map<String, Set<NavigationCase>> map) {
        FlowHandler flowHandler;
        Set<NavigationCase> set = map.get("*");
        if (set == null) {
            return null;
        }
        CaseStruct caseStruct = this.determineViewFromActionOutcome(facesContext, set, string, string2, string3);
        if (null != caseStruct && null != (flowHandler = facesContext.getApplication().getFlowHandler())) {
            caseStruct.newFlow = caseStruct.currentFlow = flowHandler.getCurrentFlow(facesContext);
        }
        return caseStruct;
    }

    private CaseStruct findRootNavigationMapAbandonedFlowMatch(FacesContext facesContext, String string, String string2, String string3, String string4) {
        CaseStruct caseStruct = null;
        Map<String, Set<NavigationCase>> map = this.getRootNavigationMap(facesContext);
        if (string != null && (caseStruct = this.findExactMatch(facesContext, string, string2, string3, string4, map)) == null) {
            caseStruct = this.findWildCardMatch(facesContext, string, string2, string3, string4, map);
        }
        if (caseStruct == null) {
            caseStruct = this.findDefaultMatch(facesContext, string2, string3, string4, map);
        }
        if (null != caseStruct) {
            caseStruct.newFlow = FlowImpl.ABANDONED_FLOW;
        }
        return caseStruct;
    }

    private CaseStruct findImplicitMatch(FacesContext facesContext, String string, String string2, String string3, String string4) {
        FacesMessage facesMessage;
        String[] stringArray;
        Object object;
        int n;
        String string5 = string3;
        String string6 = string;
        LinkedHashMap<String, ArrayList<String>> linkedHashMap = null;
        boolean bl = false;
        boolean bl2 = false;
        CaseStruct caseStruct = null;
        int n2 = string5.indexOf(63);
        if (-1 != n2) {
            String string7;
            n = string5.length();
            if (n <= n2 + 1) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "jsf.navigation_invalid_query_string", string5);
                }
                if (this.development) {
                    object = "com.sun.faces.NAVIGATION_INVALID_QUERY_STRING";
                    stringArray = new Object[]{string5};
                    facesMessage = MessageUtils.getExceptionMessage((String)object, stringArray);
                    facesMessage.setSeverity(FacesMessage.SEVERITY_WARN);
                    facesContext.addMessage(null, facesMessage);
                }
                string7 = null;
                string5 = string5.substring(0, n2);
            } else {
                string7 = string5.substring(n2 + 1);
                string5 = string5.substring(0, n2);
                object = REDIRECT_EQUALS_TRUE.matcher(string7);
                if (((Matcher)object).find()) {
                    bl = true;
                    string7 = string7.replace(((Matcher)object).group(2), "");
                }
                if (((Matcher)(object = INCLUDE_VIEW_PARAMS_EQUALS_TRUE.matcher(string7))).find()) {
                    bl2 = true;
                    string7 = string7.replace(((Matcher)object).group(2), "");
                }
            }
            if (string7 != null && string7.length() > 0) {
                object = facesContext.getExternalContext().getApplicationMap();
                stringArray = Util.split((Map<String, Object>)object, string7, "&amp;|&");
                int n3 = stringArray.length;
                for (int i = 0; i < n3; ++i) {
                    ArrayList<String> arrayList;
                    String[] stringArray2 = Util.split((Map<String, Object>)object, stringArray[i], "=");
                    if (stringArray2.length != 2) continue;
                    if (linkedHashMap == null) {
                        linkedHashMap = new LinkedHashMap<String, ArrayList<String>>(n3 / 2, 1.0f);
                        arrayList = new ArrayList<String>(2);
                        arrayList.add(stringArray2[1]);
                        linkedHashMap.put(stringArray2[0], arrayList);
                        continue;
                    }
                    arrayList = (ArrayList<String>)linkedHashMap.get(stringArray2[0]);
                    if (arrayList == null) {
                        arrayList = new ArrayList(2);
                        linkedHashMap.put(stringArray2[0], arrayList);
                    }
                    arrayList.add(stringArray2[1]);
                }
            }
        }
        if (string5.lastIndexOf(46) == -1 && (n = string6.lastIndexOf(46)) != -1) {
            string5 = string5 + string6.substring(n);
        }
        if (!string5.startsWith("/")) {
            n = string6.lastIndexOf("/");
            if (n != -1) {
                string6 = string6.substring(0, n + 1);
                string5 = string6 + string5;
            } else {
                string5 = "/" + string5;
            }
        }
        ViewHandler viewHandler = Util.getViewHandler(facesContext);
        object = facesContext.getApplication().getFlowHandler();
        stringArray = null;
        facesMessage = null;
        if (null != object) {
            stringArray = object.getCurrentFlow(facesContext);
            facesMessage = stringArray;
            if (null != stringArray && null != string5 && !string5.startsWith("/" + stringArray.getId())) {
                if ("javax.faces.flow.NullFlow".equals(string4)) {
                    facesMessage = null;
                    string5 = null;
                } else {
                    facesMessage = FlowImpl.ABANDONED_FLOW;
                }
            }
        }
        if (null != string5) {
            string5 = viewHandler.deriveViewId(facesContext, string5);
        }
        if (null == caseStruct && null != string5) {
            caseStruct = new CaseStruct();
            caseStruct.viewId = string5;
            if (null == facesMessage && null == stringArray && !"javax.faces.flow.NullFlow".equals(string4)) {
                string4 = null;
            }
            caseStruct.navCase = new NavigationCase(string6, string2, string3, null, string5, string4, linkedHashMap, bl, bl2);
        }
        if (null != caseStruct) {
            caseStruct.currentFlow = stringArray;
            caseStruct.newFlow = facesMessage;
        }
        return caseStruct;
    }

    private CaseStruct findSwitchMatch(FacesContext facesContext, String string, String string2, String string3) {
        SwitchNode switchNode;
        CaseStruct caseStruct = null;
        NavigationInfo navigationInfo = this.getNavigationInfo(facesContext, string3, string);
        FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
        if (null != flowHandler && null != navigationInfo && null != navigationInfo.switches && !navigationInfo.switches.isEmpty() && null != (switchNode = (SwitchNode)navigationInfo.switches.get(string2))) {
            List list = switchNode.getCases();
            Flow flow = list.iterator();
            while (flow.hasNext()) {
                SwitchCase switchCase = (SwitchCase)flow.next();
                if (!switchCase.getCondition(facesContext).booleanValue()) continue;
                string2 = switchCase.getFromOutcome();
                Flow flow2 = flowHandler.getFlow(facesContext, string3, string);
                if (null != flow2) {
                    caseStruct = this.synthesizeCaseStruct(facesContext, flow2, string, string2);
                } else {
                    flow2 = flowHandler.getCurrentFlow(facesContext);
                    if (null != flow2) {
                        caseStruct = this.synthesizeCaseStruct(facesContext, flow2, string, string2);
                    }
                }
                if (null == caseStruct) continue;
                break;
            }
            if (null == caseStruct && null != (string2 = switchNode.getDefaultOutcome(facesContext)) && null != (flow = flowHandler.getCurrentFlow(facesContext)) && null != (caseStruct = this.synthesizeCaseStruct(facesContext, flow, string, string2))) {
                caseStruct.currentFlow = flow;
                caseStruct.newFlow = flow;
            }
        }
        return caseStruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CaseStruct synthesizeCaseStruct(FacesContext facesContext, Flow flow, String string, String string2) {
        CaseStruct caseStruct = null;
        FlowNode flowNode = flow.getNode(string2);
        if (null != flowNode) {
            if (flowNode instanceof ViewNode) {
                caseStruct = new CaseStruct();
                caseStruct.viewId = ((ViewNode)flowNode).getVdlDocumentId();
                caseStruct.navCase = new MutableNavigationCase(string, string, string2, null, caseStruct.viewId, flow.getDefiningDocumentId(), null, false, false);
                return caseStruct;
            } else {
                if (!(flowNode instanceof ReturnNode)) return caseStruct;
                String string3 = ((ReturnNode)flowNode).getFromOutcome(facesContext);
                FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
                try {
                    flowHandler.pushReturnMode(facesContext);
                    caseStruct = this.getViewId(facesContext, string, string3, "javax.faces.flow.NullFlow");
                    if (null == caseStruct) {
                        String string4;
                        Flow flow2 = flowHandler.getCurrentFlow(facesContext);
                        if (null == flow2 || null == (string4 = flowHandler.getLastDisplayedViewId(facesContext))) return caseStruct;
                        caseStruct = new CaseStruct();
                        caseStruct.viewId = string4;
                        caseStruct.navCase = new MutableNavigationCase(facesContext.getViewRoot().getViewId(), string, string2, null, string4, "javax.faces.flow.NullFlow", null, false, false);
                        return caseStruct;
                    }
                    caseStruct.newFlow = FlowImpl.SYNTHESIZED_RETURN_CASE_FLOW;
                    return caseStruct;
                }
                finally {
                    flowHandler.popReturnMode(facesContext);
                }
            }
        } else {
            String string5 = string2;
            int n = string5.lastIndexOf(46);
            String string6 = n != -1 ? string5.substring(n) : ".xhtml";
            String string7 = "/" + flow.getId() + "/" + string2 + string6;
            ViewHandler viewHandler = Util.getViewHandler(facesContext);
            string7 = viewHandler.deriveViewId(facesContext, string7);
            if (null == string7) return caseStruct;
            caseStruct = new CaseStruct();
            caseStruct.viewId = string7;
            caseStruct.navCase = new MutableNavigationCase(string, string, string2, null, caseStruct.viewId, null, false, false);
        }
        return caseStruct;
    }

    private CaseStruct findMethodCallMatch(FacesContext facesContext, String string, String string2) {
        MethodCallNode methodCallNode;
        MethodExpression methodExpression;
        FlowNode flowNode;
        CaseStruct caseStruct = null;
        FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
        if (null == flowHandler) {
            return null;
        }
        Flow flow = flowHandler.getCurrentFlow(facesContext);
        if (null != flow && (flowNode = flow.getNode(string2)) instanceof MethodCallNode && null != (methodExpression = (methodCallNode = (MethodCallNode)flowNode).getMethodExpression())) {
            Object object;
            ELContext eLContext;
            List list = methodCallNode.getParameters();
            Object[] objectArray = null;
            if (null != list) {
                objectArray = new Object[list.size()];
                int n = 0;
                eLContext = facesContext.getELContext();
                for (Parameter parameter : list) {
                    objectArray[n++] = parameter.getValue().getValue(eLContext);
                }
            }
            if (null == (object = methodExpression.invoke(facesContext.getELContext(), objectArray)) && null != (eLContext = methodCallNode.getOutcome())) {
                object = eLContext.getValue(facesContext.getELContext());
            }
            if (null != (caseStruct = this.synthesizeCaseStruct(facesContext, flow, string, string2 = object.toString()))) {
                caseStruct.currentFlow = flow;
                caseStruct.newFlow = caseStruct.newFlow == FlowImpl.SYNTHESIZED_RETURN_CASE_FLOW ? null : flow;
            }
        }
        return caseStruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseStruct findFacesFlowCallMatch(FacesContext facesContext, String string, String string2, String string3) {
        CaseStruct caseStruct = null;
        FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
        if (null == flowHandler) {
            return null;
        }
        Flow flow = flowHandler.getCurrentFlow(facesContext);
        Flow flow2 = null;
        FlowCallNode flowCallNode = null;
        if (null != flow) {
            FlowNode flowNode = flow.getNode(string2);
            if (flowNode instanceof FlowCallNode) {
                String string4;
                flowCallNode = (FlowCallNode)flowNode;
                String string5 = flowCallNode.getCalledFlowId(facesContext);
                String string6 = flowCallNode.getCalledFlowDocumentId(facesContext);
                if (null != string5 && null != (flow2 = flowHandler.getFlow(facesContext, string6, string5)) && null == (caseStruct = this.synthesizeCaseStruct(facesContext, flow2, string, string4 = flow2.getStartNodeId()))) {
                    assert (null != flow);
                    try {
                        this.setDidTransition(facesContext, true);
                        flowHandler.transition(facesContext, flow, flow2, null, string4);
                        caseStruct = this.getViewId(facesContext, string, string4, string3);
                    }
                    finally {
                        if (null == caseStruct) {
                            flowHandler.transition(facesContext, flow2, flow, null, string2);
                            this.setDidTransition(facesContext, false);
                        }
                    }
                }
            }
        } else {
            flow2 = flowHandler.getFlow(facesContext, string3, string2);
            if (null != flow2) {
                String string7 = flow2.getStartNodeId();
                caseStruct = this.synthesizeCaseStruct(facesContext, flow2, string, string7);
                if (null == caseStruct) {
                    assert (null == flow);
                    try {
                        this.setDidTransition(facesContext, true);
                        flowHandler.transition(facesContext, null, flow2, null, string7);
                        caseStruct = this.getViewId(facesContext, string, string7, string3);
                    }
                    finally {
                        if (null == caseStruct) {
                            flowHandler.transition(facesContext, flow2, null, null, string2);
                            this.setDidTransition(facesContext, false);
                        }
                    }
                } else if (!string2.equals(string7) && null != caseStruct.navCase) {
                    ((MutableNavigationCase)caseStruct.navCase).setFromOutcome(string2);
                }
            }
        }
        if (null != caseStruct) {
            caseStruct.currentFlow = flow;
            caseStruct.newFlow = flow2;
            caseStruct.facesFlowCallNode = flowCallNode;
        }
        return caseStruct;
    }

    private boolean isDidTransition(FacesContext facesContext) {
        boolean bl = facesContext.getAttributes().containsKey(DID_TRANSITION_FLAG);
        return bl;
    }

    private void setDidTransition(FacesContext facesContext, boolean bl) {
        Map map = facesContext.getAttributes();
        if (bl) {
            map.put(DID_TRANSITION_FLAG, Boolean.TRUE);
        } else {
            map.remove(DID_TRANSITION_FLAG);
        }
    }

    private CaseStruct findViewNodeMatch(FacesContext facesContext, String string, String string2, String string3) {
        FlowNode flowNode;
        CaseStruct caseStruct = null;
        FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
        if (null == flowHandler) {
            return null;
        }
        Flow flow = flowHandler.getCurrentFlow(facesContext);
        if (null != flow && null != (flowNode = flow.getNode(string2)) && flowNode instanceof ViewNode) {
            caseStruct = this.synthesizeCaseStruct(facesContext, flow, string, string2);
        }
        if (null != caseStruct) {
            caseStruct.currentFlow = flow;
            caseStruct.newFlow = flow;
            caseStruct.facesFlowCallNode = null;
        }
        return caseStruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseStruct findReturnMatch(FacesContext facesContext, String string, String string2) {
        ReturnNode returnNode;
        CaseStruct caseStruct = null;
        FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
        if (null == flowHandler) {
            return null;
        }
        Flow flow = flowHandler.getCurrentFlow(facesContext);
        if (null != flow && null != (returnNode = (ReturnNode)flow.getReturns().get(string2))) {
            String string3 = returnNode.getFromOutcome(facesContext);
            try {
                String string4;
                Flow flow2;
                flowHandler.pushReturnMode(facesContext);
                caseStruct = this.getViewId(facesContext, string, string3, "javax.faces.flow.NullFlow");
                if (null == caseStruct && null != (flow2 = flowHandler.getCurrentFlow(facesContext)) && null != (string4 = flowHandler.getLastDisplayedViewId(facesContext))) {
                    caseStruct = new CaseStruct();
                    caseStruct.viewId = string4;
                    caseStruct.navCase = new NavigationCase(facesContext.getViewRoot().getViewId(), string, string2, null, string4, "javax.faces.flow.NullFlow", null, false, false);
                }
            }
            finally {
                flowHandler.popReturnMode(facesContext);
            }
        }
        if (null != caseStruct) {
            caseStruct.currentFlow = flow;
            caseStruct.newFlow = null;
        }
        return caseStruct;
    }

    private CaseStruct determineViewFromActionOutcome(FacesContext facesContext, Set<NavigationCase> set, String string, String string2, String string3) {
        CaseStruct caseStruct = new CaseStruct();
        boolean bl = false;
        for (NavigationCase navigationCase : set) {
            String string4 = navigationCase.getFromAction();
            String string5 = navigationCase.getFromOutcome();
            boolean bl2 = navigationCase.hasCondition();
            String string6 = navigationCase.getToViewId(facesContext);
            if (string4 != null && string5 != null) {
                if (string4.equals(string) && string5.equals(string2)) {
                    caseStruct.viewId = string6;
                    caseStruct.navCase = navigationCase;
                    bl = true;
                }
            } else if (string4 == null && string5 != null) {
                if (string5.equals(string2)) {
                    caseStruct.viewId = string6;
                    caseStruct.navCase = navigationCase;
                    bl = true;
                }
            } else if (string4 != null && string5 == null) {
                if (string4.equals(string) && (string2 != null || bl2)) {
                    caseStruct.viewId = string6;
                    caseStruct.navCase = navigationCase;
                    bl = true;
                }
            } else if (string4 == null && string5 == null && (string2 != null || bl2)) {
                caseStruct.viewId = string6;
                caseStruct.navCase = navigationCase;
                bl = true;
            }
            if (!bl) continue;
            if (bl2 && Boolean.FALSE.equals(navigationCase.getCondition(facesContext))) {
                bl = false;
                continue;
            }
            String string7 = string3 = null != navigationCase.getToFlowDocumentId() ? navigationCase.getToFlowDocumentId() : string3;
            if (null != string3) {
                FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
                if (null != string2) {
                    caseStruct.isFlowEntryFromExplicitRule = null != flowHandler.getFlow(facesContext, string3, string2);
                }
            }
            return caseStruct;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NavigationMap
    extends AbstractMap<String, Set<NavigationCase>> {
        private HashMap<String, Set<NavigationCase>> navigationMap = new HashMap();
        private TreeSet<String> wildcardMatchList = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return -string.compareTo(string2);
            }
        });

        private NavigationMap() {
        }

        @Override
        public int size() {
            return this.navigationMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.navigationMap.isEmpty();
        }

        @Override
        public Set<NavigationCase> put(String string, Set<NavigationCase> set) {
            if (string == null) {
                throw new IllegalArgumentException(string);
            }
            if (set == null) {
                throw new IllegalArgumentException();
            }
            this.updateWildcards(string);
            Set<NavigationCase> set2 = this.navigationMap.get(string);
            if (set2 == null) {
                this.navigationMap.put(string, set);
                return null;
            }
            set2.addAll(set);
            return set2;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Set<NavigationCase>> map) {
            if (map == null) {
                return;
            }
            for (Map.Entry<? extends String, ? extends Set<NavigationCase>> entry : map.entrySet()) {
                String string = entry.getKey();
                this.updateWildcards(string);
                Set<NavigationCase> set = this.navigationMap.get(string);
                if (set == null) {
                    this.navigationMap.put(string, entry.getValue());
                    continue;
                }
                set.addAll((Collection<NavigationCase>)entry.getValue());
            }
        }

        @Override
        public Set<String> keySet() {
            return new AbstractSet<String>(){

                @Override
                public Iterator<String> iterator() {
                    return new Iterator<String>(){
                        Iterator<Map.Entry<String, Set<NavigationCase>>> i;
                        {
                            this.i = NavigationMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public String next() {
                            return this.i.next().getKey();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return NavigationMap.this.size();
                }
            };
        }

        @Override
        public Collection<Set<NavigationCase>> values() {
            return new AbstractCollection<Set<NavigationCase>>(){

                @Override
                public Iterator<Set<NavigationCase>> iterator() {
                    return new Iterator<Set<NavigationCase>>(){
                        Iterator<Map.Entry<String, Set<NavigationCase>>> i;
                        {
                            this.i = NavigationMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public Set<NavigationCase> next() {
                            return this.i.next().getValue();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return NavigationMap.this.size();
                }
            };
        }

        @Override
        public Set<Map.Entry<String, Set<NavigationCase>>> entrySet() {
            return new AbstractSet<Map.Entry<String, Set<NavigationCase>>>(){

                @Override
                public Iterator<Map.Entry<String, Set<NavigationCase>>> iterator() {
                    return new Iterator<Map.Entry<String, Set<NavigationCase>>>(){
                        Iterator<Map.Entry<String, Set<NavigationCase>>> i;
                        {
                            this.i = NavigationMap.this.navigationMap.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public Map.Entry<String, Set<NavigationCase>> next() {
                            return this.i.next();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return NavigationMap.this.size();
                }
            };
        }

        private void updateWildcards(String string) {
            if (!this.navigationMap.containsKey(string) && string.endsWith("*")) {
                this.wildcardMatchList.add(string.substring(0, string.lastIndexOf(42)));
            }
        }
    }

    private static final class NavigationInfo {
        private NavigationMap ruleSet;
        private Map<String, SwitchNode> switches;

        private NavigationInfo() {
        }
    }

    private static class CaseStruct {
        String viewId;
        NavigationCase navCase;
        Flow currentFlow;
        Flow newFlow;
        FlowCallNode facesFlowCallNode;
        boolean isFlowEntryFromExplicitRule = false;

        private CaseStruct() {
        }
    }
}

