/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context.flash;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.tag.ui.UIDebug;
import com.sun.faces.util.ByteArrayGuardAESCTR;
import com.sun.faces.util.FacesLogger;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.event.PhaseId;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELFlash
extends Flash {
    private Map<String, Map<String, Object>> flashInnerMap;
    private final AtomicLong sequenceNumber;
    private int numberOfConcurentFlashUsers;
    private long numberOfFlashesBetweenFlashReapings;
    private ByteArrayGuardAESCTR guard;
    private static final Logger LOGGER = FacesLogger.FLASH.getLogger();
    static final String PREFIX = "csfcf";
    static final String FLASH_ATTRIBUTE_NAME = "csfcff";
    static final String FLASH_COOKIE_NAME = "csfcfc";
    static final String FLASH_NOW_REQUEST_KEY = "csfcffn";

    private ELFlash() {
        block5: {
            String value;
            WebConfiguration config;
            block4: {
                this.flashInnerMap = null;
                this.sequenceNumber = new AtomicLong(0L);
                this.numberOfConcurentFlashUsers = Integer.parseInt(WebConfiguration.WebContextInitParameter.NumberOfConcurrentFlashUsers.getDefaultValue());
                this.numberOfFlashesBetweenFlashReapings = Long.parseLong(WebConfiguration.WebContextInitParameter.NumberOfFlashesBetweenFlashReapings.getDefaultValue());
                this.flashInnerMap = new ConcurrentHashMap<String, Map<String, Object>>();
                config = WebConfiguration.getInstance();
                try {
                    value = config.getOptionValue(WebConfiguration.WebContextInitParameter.NumberOfConcurrentFlashUsers);
                    this.numberOfConcurentFlashUsers = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                    LOGGER.log(Level.WARNING, "Unable to set number of concurrent flash users.  Defaulting to {0}", this.numberOfConcurentFlashUsers);
                }
            }
            try {
                value = config.getOptionValue(WebConfiguration.WebContextInitParameter.NumberOfFlashesBetweenFlashReapings);
                this.numberOfFlashesBetweenFlashReapings = Long.parseLong(value);
            }
            catch (NumberFormatException nfe) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block5;
                LOGGER.log(Level.WARNING, "Unable to set number flashes between flash repaings.  Defaulting to {0}", this.numberOfFlashesBetweenFlashReapings);
            }
        }
        this.guard = new ByteArrayGuardAESCTR();
    }

    public static Map<String, Object> getFlash() {
        FacesContext context = FacesContext.getCurrentInstance();
        return ELFlash.getFlash(context.getExternalContext(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ELFlash getFlash(ExternalContext extContext, boolean create) {
        Map appMap = extContext.getApplicationMap();
        ELFlash flash = (ELFlash)((Object)appMap.get(FLASH_ATTRIBUTE_NAME));
        if (null == flash && create) {
            Object object = extContext.getContext();
            synchronized (object) {
                flash = (ELFlash)((Object)appMap.get(FLASH_ATTRIBUTE_NAME));
                if (null == flash) {
                    flash = new ELFlash();
                    appMap.put(FLASH_ATTRIBUTE_NAME, flash);
                }
            }
        }
        return flash;
    }

    public boolean isKeepMessages() {
        boolean result = false;
        Map<String, Object> phaseMap = this.loggingGetPhaseMapForReading(false);
        if (null != phaseMap) {
            Object value = phaseMap.get(CONSTANTS.KeepAllMessagesAttributeName.toString());
            result = null != value ? (Boolean)value : false;
        }
        return result;
    }

    public void setKeepMessages(boolean newValue) {
        this.loggingGetPhaseMapForWriting(false).put(CONSTANTS.KeepAllMessagesAttributeName.toString(), newValue);
    }

    public boolean isRedirect() {
        boolean result = false;
        FacesContext context = FacesContext.getCurrentInstance();
        Map contextMap = context.getAttributes();
        PreviousNextFlashInfoManager flashManager = this.getCurrentFlashManager(contextMap, false);
        if (null != flashManager) {
            result = flashManager.getPreviousRequestFlashInfo().isIsRedirect();
        }
        return result;
    }

    public void setRedirect(boolean newValue) {
    }

    public Object get(Object key) {
        Object result = null;
        if (null != key) {
            if (key.equals("keepMessages")) {
                result = this.isKeepMessages();
            } else if (key.equals("redirect")) {
                result = this.isRedirect();
            } else {
                FacesContext context = FacesContext.getCurrentInstance();
                if (this.isKeepFlagSet(context)) {
                    result = this.getPhaseMapForReading().get(key);
                    this.keep(key.toString());
                    this.clearKeepFlag(context);
                    return result;
                }
            }
        }
        if (null == result) {
            result = this.getPhaseMapForReading().get(key);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "get({0}) = {1}", new Object[]{key, result});
        }
        return result;
    }

    public Object put(String key, Object value) {
        Object b = null;
        Object result = null;
        if (null != key) {
            if (key.equals("keepMessages")) {
                b = Boolean.parseBoolean((String)value);
                this.setKeepMessages((Boolean)b);
            }
            if (key.equals("redirect")) {
                b = Boolean.parseBoolean((String)value);
                this.setRedirect((Boolean)b);
            }
        }
        Object object = result = null == b ? this.getPhaseMapForWriting().put(key, value) : b;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "put({0},{1})", new Object[]{key, value});
        }
        return result;
    }

    public Object remove(Object key) {
        Object result = null;
        result = this.getPhaseMapForWriting().remove(key);
        return result;
    }

    public boolean containsKey(Object key) {
        boolean result = false;
        result = this.getPhaseMapForReading().containsKey(key);
        return result;
    }

    public boolean containsValue(Object value) {
        boolean result = false;
        result = this.getPhaseMapForReading().containsValue(value);
        return result;
    }

    public void putAll(Map<? extends String, ?> t) {
        this.getPhaseMapForWriting().putAll(t);
    }

    public Collection<Object> values() {
        Collection<Object> result = null;
        result = this.getPhaseMapForReading().values();
        return result;
    }

    public int size() {
        int result = 0;
        result = this.getPhaseMapForReading().size();
        return result;
    }

    public void clear() {
        this.getPhaseMapForWriting().clear();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        Set<Map.Entry<String, Object>> readingMapEntrySet = this.getPhaseMapForReading().entrySet();
        Set<Map.Entry<String, Object>> writingMapEntrySet = this.getPhaseMapForWriting().entrySet();
        HashSet<Map.Entry<String, Object>> result = null;
        result = new HashSet<Map.Entry<String, Object>>();
        result.addAll(readingMapEntrySet);
        result.addAll(writingMapEntrySet);
        return result;
    }

    public boolean isEmpty() {
        boolean readingMapIsEmpty = this.getPhaseMapForReading().isEmpty();
        boolean writingMapIsEmpty = this.getPhaseMapForWriting().isEmpty();
        boolean result = false;
        result = readingMapIsEmpty && writingMapIsEmpty;
        return result;
    }

    public Set<String> keySet() {
        Set<String> readingMapKeySet = this.getPhaseMapForReading().keySet();
        Set<String> writingMapKeySet = this.getPhaseMapForWriting().keySet();
        HashSet<String> result = null;
        result = new HashSet<String>();
        result.addAll(readingMapKeySet);
        result.addAll(writingMapKeySet);
        return result;
    }

    public void keep(String key) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestMap = context.getExternalContext().getRequestMap();
        Map contextMap = context.getAttributes();
        PreviousNextFlashInfoManager flashManager = this.getCurrentFlashManager(contextMap, true);
        if (null != flashManager) {
            Object toKeep = requestMap.remove(key);
            if (null == toKeep) {
                FlashInfo flashInfo = null;
                flashInfo = flashManager.getPreviousRequestFlashInfo();
                if (null != flashInfo) {
                    toKeep = flashInfo.getFlashMap().remove(key);
                }
            }
            if (null != toKeep) {
                this.getPhaseMapForWriting().put(key, toKeep);
            }
        }
    }

    public void putNow(String key, Object value) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map contextMap = context.getAttributes();
        PreviousNextFlashInfoManager flashManager = this.getCurrentFlashManager(contextMap, true);
        if (null != flashManager) {
            FlashInfo flashInfo = null;
            flashInfo = flashManager.getPreviousRequestFlashInfo();
            if (null != flashInfo) {
                flashInfo.getFlashMap().put(key, value);
            }
        }
    }

    public void doPrePhaseActions(FacesContext context) {
        PhaseId currentPhase = context.getCurrentPhaseId();
        Map contextMap = context.getAttributes();
        contextMap.put(CONSTANTS.SavedResponseCompleteFlagValue, context.getResponseComplete());
        if (currentPhase.equals(PhaseId.RESTORE_VIEW)) {
            Cookie cookie = null;
            cookie = this.getCookie(context.getExternalContext());
            if (null != cookie) {
                this.getCurrentFlashManager(context, contextMap, cookie);
            }
            if (this.isKeepMessages()) {
                this.restoreAllMessages(context);
            }
        }
    }

    public void doPostPhaseActions(FacesContext context) {
        boolean lastPhaseForThisRequest;
        PhaseId currentPhase = context.getCurrentPhaseId();
        Map contextMap = context.getAttributes();
        boolean responseCompleteJustSetTrue = this.responseCompleteWasJustSetTrue(context, contextMap);
        boolean bl = lastPhaseForThisRequest = responseCompleteJustSetTrue || currentPhase == PhaseId.RENDER_RESPONSE;
        if (lastPhaseForThisRequest) {
            this.doLastPhaseActions(context, false);
        }
    }

    public void doLastPhaseActions(FacesContext context, boolean outgoingResponseIsRedirect) {
        Map contextMap = context.getAttributes();
        PreviousNextFlashInfoManager flashManager = this.getCurrentFlashManager(contextMap, false);
        if (null == flashManager) {
            return;
        }
        if (this.isKeepMessages()) {
            this.saveAllMessages(context);
        }
        this.releaseCurrentFlashManager(contextMap);
        if (outgoingResponseIsRedirect) {
            FlashInfo previousRequestFlashInfo = flashManager.getPreviousRequestFlashInfo();
            previousRequestFlashInfo.setIsRedirect(true);
            flashManager.expireNext_MovePreviousToNext();
        } else {
            FlashInfo flashInfo = flashManager.getPreviousRequestFlashInfo();
            if (null != flashInfo && flashInfo.getLifetimeMarker() == LifetimeMarker.SecondTimeThru) {
                flashManager.expirePrevious();
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "---------------------------------------");
        }
        this.setCookie(context, flashManager, flashManager.encode());
    }

    private void maybeWriteCookie(FacesContext context, PreviousNextFlashInfoManager flashManager) {
        FlashInfo flashInfo = flashManager.getPreviousRequestFlashInfo();
        if (null != flashInfo && flashInfo.getLifetimeMarker() == LifetimeMarker.SecondTimeThru) {
            PreviousNextFlashInfoManager copiedFlashManager = flashManager.copyWithoutInnerMap();
            copiedFlashManager.expirePrevious();
            this.setCookie(context, flashManager, copiedFlashManager.encode());
        }
    }

    void setKeepFlag(FacesContext context) {
        context.getAttributes().put(CONSTANTS.KeepFlagAttributeName, Boolean.TRUE);
    }

    void clearKeepFlag(FacesContext context) {
        context.getAttributes().remove((Object)CONSTANTS.KeepFlagAttributeName);
    }

    boolean isKeepFlagSet(FacesContext context) {
        return Boolean.TRUE == context.getAttributes().get((Object)CONSTANTS.KeepFlagAttributeName);
    }

    private long getNewSequenceNumber() {
        long result = this.sequenceNumber.incrementAndGet();
        if (0L == result % this.numberOfFlashesBetweenFlashReapings) {
            this.reapFlashes();
        }
        if (result == Long.MAX_VALUE) {
            result = 1L;
            this.sequenceNumber.set(1L);
        }
        return result;
    }

    private void reapFlashes() {
        if (this.flashInnerMap.size() < this.numberOfConcurentFlashUsers) {
            return;
        }
        Set<String> keys = this.flashInnerMap.keySet();
        long currentSequenceNumber = this.sequenceNumber.get();
        for (String cur : keys) {
            long sequenceNumberToTest = Long.parseLong(cur);
            if ((long)this.numberOfConcurentFlashUsers >= currentSequenceNumber - sequenceNumberToTest) continue;
            Map<String, Object> curFlash = this.flashInnerMap.get(cur);
            if (null != curFlash) {
                curFlash.clear();
            }
            this.flashInnerMap.remove(cur);
        }
    }

    private boolean responseCompleteWasJustSetTrue(FacesContext context, Map<Object, Object> contextMap) {
        boolean result = false;
        result = Boolean.FALSE == contextMap.get((Object)CONSTANTS.SavedResponseCompleteFlagValue) && context.getResponseComplete();
        return result;
    }

    private static String getLogPrefix(FacesContext context) {
        String viewId;
        UIViewRoot root;
        StringBuilder result = new StringBuilder();
        ExternalContext extContext = context.getExternalContext();
        Object request = extContext.getRequest();
        if (request instanceof HttpServletRequest) {
            result.append(((HttpServletRequest)request).getMethod()).append(" ");
        }
        if (null != (root = context.getViewRoot()) && null != (viewId = root.getViewId())) {
            result.append(viewId).append(" ");
        }
        return result.toString();
    }

    private Map<String, Object> loggingGetPhaseMapForWriting(boolean loggingEnabled) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map<String, Object> result = null;
        PhaseId currentPhase = context.getCurrentPhaseId();
        Map contextMap = context.getAttributes();
        PreviousNextFlashInfoManager flashManager = this.getCurrentFlashManager(contextMap, true);
        if (null != flashManager) {
            FlashInfo flashInfo;
            boolean isDebugLog;
            boolean bl = isDebugLog = loggingEnabled && LOGGER.isLoggable(Level.FINEST);
            if (currentPhase.getOrdinal() < PhaseId.RENDER_RESPONSE.getOrdinal()) {
                flashInfo = flashManager.getPreviousRequestFlashInfo();
                if (isDebugLog) {
                    LOGGER.log(Level.FINEST, "{0}previous[{1}]", new Object[]{ELFlash.getLogPrefix(context), flashInfo.getSequenceNumber()});
                }
            } else {
                flashInfo = flashManager.getNextRequestFlashInfo(this, true);
                if (isDebugLog) {
                    LOGGER.log(Level.FINEST, "{0}next[{1}]", new Object[]{ELFlash.getLogPrefix(context), flashInfo.getSequenceNumber()});
                }
                this.maybeWriteCookie(context, flashManager);
            }
            result = flashInfo.getFlashMap();
        }
        return result;
    }

    private Map<String, Object> getPhaseMapForWriting() {
        return this.loggingGetPhaseMapForWriting(true);
    }

    private Map<String, Object> loggingGetPhaseMapForReading(boolean loggingEnabled) {
        FlashInfo flashInfo;
        FacesContext context = FacesContext.getCurrentInstance();
        Map<String, Object> result = Collections.emptyMap();
        Map contextMap = context.getAttributes();
        PreviousNextFlashInfoManager flashManager = this.getCurrentFlashManager(contextMap, false);
        if (null != flashManager && null != (flashInfo = flashManager.getPreviousRequestFlashInfo())) {
            boolean isDebugLog;
            boolean bl = isDebugLog = loggingEnabled && LOGGER.isLoggable(Level.FINEST);
            if (isDebugLog) {
                LOGGER.log(Level.FINEST, "{0}previous[{1}]", new Object[]{ELFlash.getLogPrefix(context), flashInfo.getSequenceNumber()});
            }
            result = flashInfo.getFlashMap();
        }
        return result;
    }

    private Map<String, Object> getPhaseMapForReading() {
        return this.loggingGetPhaseMapForReading(true);
    }

    void saveAllMessages(FacesContext context) {
        ArrayList facesMessages;
        Iterator messageIter;
        Map contextMap = context.getAttributes();
        PreviousNextFlashInfoManager flashManager = this.getCurrentFlashManager(contextMap, true);
        if (null == flashManager) {
            return;
        }
        if (flashManager.getPreviousRequestFlashInfo().isIsRedirect()) {
            return;
        }
        Iterator messageClientIds = context.getClientIdsWithMessages();
        HashMap allFacesMessages = null;
        while (messageClientIds.hasNext()) {
            String curMessageId = (String)messageClientIds.next();
            messageIter = context.getMessages(curMessageId);
            facesMessages = new ArrayList();
            while (messageIter.hasNext()) {
                facesMessages.add(messageIter.next());
            }
            if (null == allFacesMessages) {
                allFacesMessages = new HashMap();
            }
            allFacesMessages.put(curMessageId, facesMessages);
        }
        facesMessages = null;
        messageIter = context.getMessages(null);
        facesMessages = new ArrayList();
        while (messageIter.hasNext()) {
            facesMessages.add(messageIter.next());
        }
        if (null != facesMessages) {
            if (null == allFacesMessages) {
                allFacesMessages = new HashMap();
            }
            allFacesMessages.put(null, facesMessages);
        }
        this.getPhaseMapForWriting().put(CONSTANTS.FacesMessageAttributeName.toString(), allFacesMessages);
    }

    void restoreAllMessages(FacesContext context) {
        Map<String, Object> phaseMap = this.getPhaseMapForReading();
        Map allFacesMessages = (Map)phaseMap.get(CONSTANTS.FacesMessageAttributeName.toString());
        if (null != allFacesMessages) {
            for (Map.Entry cur : allFacesMessages.entrySet()) {
                List facesMessages = (List)allFacesMessages.get(cur.getKey());
                if (null == facesMessages) continue;
                for (FacesMessage curMessage : facesMessages) {
                    context.addMessage((String)cur.getKey(), curMessage);
                }
            }
            phaseMap.remove(CONSTANTS.FacesMessageAttributeName.toString());
        }
    }

    private Cookie getCookie(ExternalContext extContext) {
        Cookie result = null;
        result = (Cookie)extContext.getRequestCookieMap().get(FLASH_COOKIE_NAME);
        return result;
    }

    private void setCookie(FacesContext context, PreviousNextFlashInfoManager flashManager, Cookie toSet) {
        Map contextMap = context.getAttributes();
        ExternalContext extContext = context.getExternalContext();
        if (contextMap.containsKey((Object)CONSTANTS.DidWriteCookieAttributeName)) {
            return;
        }
        FlashInfo nextFlash = flashManager.getNextRequestFlashInfo();
        FlashInfo prevFlash = flashManager.getPreviousRequestFlashInfo();
        if (null != nextFlash && !nextFlash.getFlashMap().isEmpty() || null != prevFlash && !prevFlash.getFlashMap().isEmpty()) {
            if (extContext.isResponseCommitted()) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.externalcontext.flash.response.already.committed");
                }
            } else {
                boolean isSecure;
                Object val;
                HashMap<String, Object> properties;
                block25: {
                    properties = new HashMap<String, Object>();
                    val = toSet.getComment();
                    if (null != val) {
                        properties.put("comment", val);
                    }
                    if (null != (val = toSet.getDomain())) {
                        properties.put("domain", val);
                    }
                    if (null != (val = Integer.valueOf(toSet.getMaxAge()))) {
                        properties.put("maxAge", val);
                    }
                    isSecure = false;
                    Object request = extContext.getRequest();
                    if (request instanceof ServletRequest) {
                        isSecure = ((ServletRequest)request).isSecure();
                    } else {
                        try {
                            isSecure = extContext.isSecure();
                        }
                        catch (UnsupportedOperationException uoe) {
                            if (!LOGGER.isLoggable(Level.SEVERE)) break block25;
                            LOGGER.log(Level.SEVERE, "ExternalContext {0} does not implement isSecure().  Please implement this per the JSF 2.1 specification.", new Object[]{extContext});
                        }
                    }
                }
                if (isSecure) {
                    properties.put("secure", Boolean.TRUE);
                } else {
                    val = toSet.getSecure();
                    if (null != val) {
                        properties.put("secure", val);
                    }
                }
                val = toSet.getPath();
                if (null != val) {
                    properties.put("path", val);
                }
                extContext.addResponseCookie(toSet.getName(), toSet.getValue(), !properties.isEmpty() ? properties : null);
                properties = null;
            }
            contextMap.put(CONSTANTS.DidWriteCookieAttributeName, Boolean.TRUE);
        } else if (!extContext.isResponseCommitted()) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            toSet.setMaxAge(0);
            Object val = toSet.getComment();
            if (null != val) {
                properties.put("comment", val);
            }
            if (null != (val = toSet.getDomain())) {
                properties.put("domain", val);
            }
            if (null != (val = Integer.valueOf(toSet.getMaxAge()))) {
                properties.put("maxAge", val);
            }
            if (context.getExternalContext().isSecure()) {
                properties.put("secure", Boolean.TRUE);
            } else {
                val = toSet.getSecure();
                if (null != val) {
                    properties.put("secure", val);
                }
            }
            val = toSet.getPath();
            if (null != val) {
                properties.put("path", val);
            }
            extContext.addResponseCookie(toSet.getName(), toSet.getValue(), !properties.isEmpty() ? properties : null);
            properties = null;
        }
    }

    private void releaseCurrentFlashManager(Map<Object, Object> contextMap) {
        contextMap.remove((Object)CONSTANTS.RequestFlashManager);
    }

    private PreviousNextFlashInfoManager getCurrentFlashManager(Map<Object, Object> contextMap, boolean create) {
        PreviousNextFlashInfoManager result = (PreviousNextFlashInfoManager)contextMap.get((Object)CONSTANTS.RequestFlashManager);
        if (null == result && create) {
            result = new PreviousNextFlashInfoManager(this.guard, this.flashInnerMap);
            result.initializeBaseCase(this);
            contextMap.put((Object)CONSTANTS.RequestFlashManager, result);
        }
        return result;
    }

    private PreviousNextFlashInfoManager getCurrentFlashManager(FacesContext context, Map<Object, Object> contextMap, Cookie cookie) {
        PreviousNextFlashInfoManager result;
        block3: {
            result = (PreviousNextFlashInfoManager)contextMap.get((Object)CONSTANTS.RequestFlashManager);
            if (null == result) {
                result = new PreviousNextFlashInfoManager(this.guard, this.flashInnerMap);
                try {
                    result.decode(context, this, cookie);
                    contextMap.put((Object)CONSTANTS.RequestFlashManager, result);
                }
                catch (InvalidKeyException ike) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                    result = this.getCurrentFlashManager(contextMap, true);
                    LOGGER.log(Level.SEVERE, "jsf.externalcontext.flash.bad.cookie", new Object[]{ike.getMessage()});
                }
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FlashInfo {
        private boolean isRedirect;
        private LifetimeMarker lifetimeMarker;
        private long sequenceNumber;
        private Map<String, Object> flashMap;

        private FlashInfo() {
        }

        FlashInfo(long sequenceNumber, LifetimeMarker lifetimeMarker, boolean isRedirect) {
            this.setSequenceNumber(sequenceNumber);
            this.setLifetimeMarker(lifetimeMarker);
            this.setIsRedirect(isRedirect);
        }

        FlashInfo copyWithoutInnerMap() {
            FlashInfo result = new FlashInfo(this.sequenceNumber, this.lifetimeMarker, this.isRedirect);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FlashInfo other = (FlashInfo)obj;
            if (this.isRedirect != other.isRedirect) {
                return false;
            }
            if (!(this.lifetimeMarker == other.lifetimeMarker || this.lifetimeMarker != null && this.lifetimeMarker.equals((Object)other.lifetimeMarker))) {
                return false;
            }
            return this.sequenceNumber == other.sequenceNumber;
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + (this.isRedirect ? 1 : 0);
            hash = 71 * hash + (this.lifetimeMarker != null ? this.lifetimeMarker.hashCode() : 0);
            hash = 71 * hash + (int)(this.sequenceNumber ^ this.sequenceNumber >>> 32);
            return hash;
        }

        void decode(String value) {
            if (null == value || 0 == value.length()) {
                return;
            }
            int i = value.indexOf(88);
            this.setSequenceNumber(Long.parseLong(value.substring(0, i++)));
            this.setLifetimeMarker(LifetimeMarker.decode(value.charAt(i++)));
            this.setIsRedirect(LifetimeMarker.IsRedirect == LifetimeMarker.decode(value.charAt(i++)));
        }

        String encode() {
            String value = null;
            value = this.isIsRedirect() ? Long.toString(this.getSequenceNumber()) + "X" + this.getLifetimeMarker().encode() + LifetimeMarker.IsRedirect.encode() : Long.toString(this.getSequenceNumber()) + "X" + this.getLifetimeMarker().encode() + LifetimeMarker.IsNormal.encode();
            return value;
        }

        boolean isIsRedirect() {
            return this.isRedirect;
        }

        void setIsRedirect(boolean isRedirect) {
            this.isRedirect = isRedirect;
        }

        long getSequenceNumber() {
            return this.sequenceNumber;
        }

        void setSequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        LifetimeMarker getLifetimeMarker() {
            return this.lifetimeMarker;
        }

        void setLifetimeMarker(LifetimeMarker lifetimeMarker) {
            this.lifetimeMarker = lifetimeMarker;
        }

        Map<String, Object> getFlashMap() {
            return this.flashMap;
        }

        void setFlashMap(Map<String, Object> flashMap) {
            this.flashMap = flashMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PreviousNextFlashInfoManager {
        private FlashInfo previousRequestFlashInfo;
        private FlashInfo nextRequestFlashInfo;
        private boolean incomingCookieCameFromRedirect = false;
        private Map<String, Map<String, Object>> innerMap;
        private ByteArrayGuardAESCTR guard;

        private PreviousNextFlashInfoManager(ByteArrayGuardAESCTR guard) {
            this.guard = guard;
        }

        private PreviousNextFlashInfoManager(ByteArrayGuardAESCTR guard, Map<String, Map<String, Object>> innerMap) {
            this.guard = guard;
            this.innerMap = innerMap;
        }

        protected PreviousNextFlashInfoManager copyWithoutInnerMap() {
            PreviousNextFlashInfoManager result = new PreviousNextFlashInfoManager(this.guard);
            result.innerMap = Collections.emptyMap();
            if (null != this.previousRequestFlashInfo) {
                result.previousRequestFlashInfo = this.previousRequestFlashInfo.copyWithoutInnerMap();
            }
            if (null != this.nextRequestFlashInfo) {
                result.nextRequestFlashInfo = this.nextRequestFlashInfo.copyWithoutInnerMap();
            }
            result.incomingCookieCameFromRedirect = this.incomingCookieCameFromRedirect;
            return result;
        }

        public String toString() {
            String result = null;
            result = "previousRequestSequenceNumber: " + (null != this.previousRequestFlashInfo ? Long.valueOf(this.previousRequestFlashInfo.getSequenceNumber()) : "null") + " nextRequestSequenceNumber: " + (null != this.nextRequestFlashInfo ? Long.valueOf(this.nextRequestFlashInfo.getSequenceNumber()) : "null");
            return result;
        }

        void initializeBaseCase(ELFlash flash) {
            HashMap<String, Object> flashMap = null;
            this.previousRequestFlashInfo = new FlashInfo(flash.getNewSequenceNumber(), LifetimeMarker.FirstTimeThru, false);
            flashMap = new HashMap<String, Object>();
            this.innerMap.put(this.previousRequestFlashInfo.getSequenceNumber() + "", flashMap);
            this.previousRequestFlashInfo.setFlashMap(flashMap);
            this.nextRequestFlashInfo = new FlashInfo(flash.getNewSequenceNumber(), LifetimeMarker.FirstTimeThru, false);
            flashMap = new HashMap();
            this.innerMap.put(this.nextRequestFlashInfo.getSequenceNumber() + "", flashMap);
            this.nextRequestFlashInfo.setFlashMap(flashMap);
        }

        void expirePrevious() {
            if (null != this.previousRequestFlashInfo) {
                Map<String, Object> flashMap = this.previousRequestFlashInfo.getFlashMap();
                if (null != flashMap) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "{0} expire previous[{1}]", new Object[]{ELFlash.getLogPrefix(FacesContext.getCurrentInstance()), this.previousRequestFlashInfo.getSequenceNumber()});
                    }
                    flashMap.clear();
                }
                this.innerMap.remove(this.previousRequestFlashInfo.getSequenceNumber() + "");
                this.previousRequestFlashInfo = null;
            }
        }

        void expireNext_MovePreviousToNext() {
            if (null != this.nextRequestFlashInfo) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "{0} expire next[{1}], move previous to next", new Object[]{ELFlash.getLogPrefix(FacesContext.getCurrentInstance()), this.nextRequestFlashInfo.getSequenceNumber()});
                }
                this.nextRequestFlashInfo.getFlashMap().clear();
                this.innerMap.remove(this.nextRequestFlashInfo.getSequenceNumber() + "");
                this.nextRequestFlashInfo = null;
            }
            this.nextRequestFlashInfo = this.previousRequestFlashInfo;
            this.previousRequestFlashInfo = null;
        }

        void decode(FacesContext context, ELFlash flash, Cookie cookie) throws InvalidKeyException {
            block11: {
                String urlDecodedValue = null;
                try {
                    urlDecodedValue = URLDecoder.decode(cookie.getValue(), "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    urlDecodedValue = cookie.getValue();
                }
                String value = this.guard.decrypt(urlDecodedValue);
                try {
                    int i = value.indexOf("_");
                    String temp = value.substring(0, i++);
                    if (0 < temp.length()) {
                        this.nextRequestFlashInfo = new FlashInfo();
                        this.nextRequestFlashInfo.decode(temp);
                    }
                    this.previousRequestFlashInfo = new FlashInfo();
                    this.previousRequestFlashInfo.decode(value.substring(i));
                    if (this.previousRequestFlashInfo.isIsRedirect()) {
                        this.setIncomingCookieCameFromRedirect(true);
                        this.previousRequestFlashInfo.setIsRedirect(false);
                    } else if (!UIDebug.debugRequest(context)) {
                        this.previousRequestFlashInfo.setLifetimeMarker(LifetimeMarker.SecondTimeThru);
                        this.nextRequestFlashInfo = null;
                    }
                    Map<String, Object> flashMap = this.innerMap.get(this.previousRequestFlashInfo.getSequenceNumber() + "");
                    if (null == flashMap) {
                        this.previousRequestFlashInfo = new FlashInfo();
                        this.previousRequestFlashInfo.setSequenceNumber(flash.getNewSequenceNumber());
                        this.previousRequestFlashInfo.setLifetimeMarker(LifetimeMarker.FirstTimeThru);
                        this.previousRequestFlashInfo.setIsRedirect(false);
                        flashMap = new HashMap<String, Object>();
                        this.innerMap.put(this.previousRequestFlashInfo.getSequenceNumber() + "", flashMap);
                    }
                    this.previousRequestFlashInfo.setFlashMap(flashMap);
                    if (null != this.nextRequestFlashInfo) {
                        flashMap = this.innerMap.get(this.nextRequestFlashInfo.getSequenceNumber() + "");
                        if (null == flashMap) {
                            this.nextRequestFlashInfo = new FlashInfo();
                            this.nextRequestFlashInfo.setSequenceNumber(flash.getNewSequenceNumber());
                            this.nextRequestFlashInfo.setLifetimeMarker(LifetimeMarker.FirstTimeThru);
                            this.nextRequestFlashInfo.setIsRedirect(false);
                            flashMap = new HashMap<String, Object>();
                            this.innerMap.put(this.nextRequestFlashInfo.getSequenceNumber() + "", flashMap);
                        }
                        this.nextRequestFlashInfo.setFlashMap(flashMap);
                    }
                }
                catch (Throwable t) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block11;
                    LOGGER.log(Level.SEVERE, "jsf.externalcontext.flash.bad.cookie", new Object[]{value});
                }
            }
        }

        Cookie encode() {
            String requestContextPath;
            Cookie result = null;
            String value = (null != this.previousRequestFlashInfo ? this.previousRequestFlashInfo.encode() : "") + "_" + (null != this.nextRequestFlashInfo ? this.nextRequestFlashInfo.encode() : "");
            String encryptedValue = this.guard.encrypt(value);
            try {
                result = new Cookie(ELFlash.FLASH_COOKIE_NAME, URLEncoder.encode(encryptedValue, "UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                result = new Cookie(ELFlash.FLASH_COOKIE_NAME, encryptedValue);
            }
            if (1 == value.length()) {
                result.setMaxAge(0);
            }
            if ((requestContextPath = FacesContext.getCurrentInstance().getExternalContext().getRequestContextPath()).isEmpty()) {
                requestContextPath = "/";
            }
            result.setPath(requestContextPath);
            return result;
        }

        FlashInfo getPreviousRequestFlashInfo() {
            return this.previousRequestFlashInfo;
        }

        void setPreviousRequestFlashInfo(FlashInfo thisRequestFlashInfo) {
            this.previousRequestFlashInfo = thisRequestFlashInfo;
        }

        FlashInfo getNextRequestFlashInfo() {
            return this.nextRequestFlashInfo;
        }

        FlashInfo getNextRequestFlashInfo(ELFlash flash, boolean create) {
            if (create && null == this.nextRequestFlashInfo) {
                this.nextRequestFlashInfo = new FlashInfo();
                this.nextRequestFlashInfo.setSequenceNumber(flash.getNewSequenceNumber());
                this.nextRequestFlashInfo.setLifetimeMarker(LifetimeMarker.FirstTimeThru);
                this.nextRequestFlashInfo.setIsRedirect(false);
                HashMap<String, Object> flashMap = null;
                flashMap = new HashMap<String, Object>();
                this.innerMap.put(this.nextRequestFlashInfo.getSequenceNumber() + "", flashMap);
                this.nextRequestFlashInfo.setFlashMap(flashMap);
            }
            return this.nextRequestFlashInfo;
        }

        void setNextRequestFlashInfo(FlashInfo nextRequestFlashInfo) {
            this.nextRequestFlashInfo = nextRequestFlashInfo;
        }

        boolean isIncomingCookieCameFromRedirect() {
            return this.incomingCookieCameFromRedirect;
        }

        void setIncomingCookieCameFromRedirect(boolean incomingCookieCameFromRedirect) {
            this.incomingCookieCameFromRedirect = incomingCookieCameFromRedirect;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LifetimeMarker {
        FirstTimeThru("f"),
        SecondTimeThru("s"),
        IsRedirect("r"),
        IsNormal("n");

        private static char FIRST_TIME_THRU;
        private static char SECOND_TIME_THRU;
        private static char IS_REDIRECT;
        private static char IS_NORMAL;
        private String name;

        private LifetimeMarker(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public char encode() {
            return this.name.charAt(0);
        }

        public static LifetimeMarker decode(char c) {
            LifetimeMarker result = FirstTimeThru;
            if (FIRST_TIME_THRU == c) {
                result = FirstTimeThru;
            } else if (SECOND_TIME_THRU == c) {
                result = SecondTimeThru;
            } else if (IS_REDIRECT == c) {
                result = IsRedirect;
            } else if (IS_NORMAL == c) {
                result = IsNormal;
            } else {
                throw new IllegalStateException("class invariant failed: invalid lifetime marker");
            }
            return result;
        }

        static {
            FIRST_TIME_THRU = (char)102;
            SECOND_TIME_THRU = (char)115;
            IS_REDIRECT = (char)114;
            IS_NORMAL = (char)110;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CONSTANTS {
        RequestFlashManager,
        SavedResponseCompleteFlagValue,
        FacesMessageAttributeName,
        KeepAllMessagesAttributeName,
        KeepFlagAttributeName,
        DidWriteCookieAttributeName;

    }
}

