/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component.behavior;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.Behavior;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.BehaviorListener;

public class BehaviorBase
implements Behavior,
PartialStateHolder {
    private List<BehaviorListener> listeners;
    private boolean transientFlag = false;
    private boolean initialState = false;

    public void broadcast(BehaviorEvent behaviorEvent) throws AbortProcessingException {
        if (null == behaviorEvent) {
            throw new NullPointerException();
        }
        if (null != this.listeners) {
            for (BehaviorListener behaviorListener : this.listeners) {
                if (!behaviorEvent.isAppropriateListener(behaviorListener)) continue;
                behaviorEvent.processListener(behaviorListener);
            }
        }
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean bl) {
        this.transientFlag = bl;
    }

    public Object saveState(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (this.initialStateMarked()) {
            return null;
        }
        return UIComponentBase.saveAttachedState(facesContext, this.listeners);
    }

    public void restoreState(FacesContext facesContext, Object object) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (object != null) {
            this.listeners = (List)UIComponentBase.restoreAttachedState(facesContext, object);
            this.clearInitialState();
        }
    }

    public void markInitialState() {
        this.initialState = true;
    }

    public boolean initialStateMarked() {
        return this.initialState;
    }

    public void clearInitialState() {
        this.initialState = false;
    }

    protected void addBehaviorListener(BehaviorListener behaviorListener) {
        if (behaviorListener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<BehaviorListener>();
        }
        this.listeners.add(behaviorListener);
        this.clearInitialState();
    }

    protected void removeBehaviorListener(BehaviorListener behaviorListener) {
        if (behaviorListener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(behaviorListener);
        this.clearInitialState();
    }
}

