/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class FacesServlet
implements Servlet {
    private static final String ALLOWED_HTTP_METHODS_ATTR = "com.sun.faces.allowedHttpMethods";
    private Set<String> allowedUnknownHttpMethods;
    private Set<HttpMethod> allowedKnownHttpMethods;
    private final Set<HttpMethod> defaultAllowedHttpMethods = EnumSet.range(HttpMethod.OPTIONS, HttpMethod.CONNECT);
    private Set<HttpMethod> allHttpMethods;
    private boolean allowAllMethods;
    public static final String CONFIG_FILES_ATTR = "javax.faces.CONFIG_FILES";
    public static final String LIFECYCLE_ID_ATTR = "javax.faces.LIFECYCLE_ID";
    private static final Logger LOGGER = Logger.getLogger("javax.faces.webapp", "javax.faces.LogStrings");
    private FacesContextFactory facesContextFactory = null;
    private Lifecycle lifecycle = null;
    private ServletConfig servletConfig = null;
    private boolean initFacesContextReleased = false;

    public void destroy() {
        this.facesContextFactory = null;
        this.lifecycle = null;
        this.servletConfig = null;
        this.uninitHttpMethodValidityVerification();
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletInfo() {
        return this.getClass().getName();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        try {
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory("javax.faces.context.FacesContextFactory");
        }
        catch (FacesException facesException) {
            ResourceBundle resourceBundle = LOGGER.getResourceBundle();
            String string = resourceBundle.getString("severe.webapp.facesservlet.init_failed");
            Throwable throwable = facesException.getCause() != null ? facesException.getCause() : facesException;
            LOGGER.log(Level.SEVERE, string, throwable);
            throw new UnavailableException(string);
        }
        try {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
            String string = servletConfig.getInitParameter(LIFECYCLE_ID_ATTR);
            if (null == string) {
                string = servletConfig.getServletContext().getInitParameter(LIFECYCLE_ID_ATTR);
            }
            if (string == null) {
                string = "DEFAULT";
            }
            this.lifecycle = lifecycleFactory.getLifecycle(string);
            this.initHttpMethodValidityVerification();
        }
        catch (FacesException facesException) {
            Throwable throwable = facesException.getCause();
            if (throwable == null) {
                throw facesException;
            }
            throw new ServletException(facesException.getMessage(), throwable);
        }
    }

    private void initHttpMethodValidityVerification() {
        assert (null == this.allowedUnknownHttpMethods);
        assert (null != this.defaultAllowedHttpMethods);
        assert (null == this.allHttpMethods);
        this.allHttpMethods = EnumSet.allOf(HttpMethod.class);
        this.allowedUnknownHttpMethods = Collections.emptySet();
        this.allowedKnownHttpMethods = this.defaultAllowedHttpMethods;
        String[] stringArray = new String[]{};
        String string = this.servletConfig.getServletContext().getInitParameter(ALLOWED_HTTP_METHODS_ATTR);
        if (null != string) {
            stringArray = string.split("\\s+");
            assert (null != stringArray);
            this.allowedUnknownHttpMethods = new HashSet<String>(stringArray.length);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : stringArray) {
                boolean bl;
                if (string2.equals("*")) {
                    this.allowAllMethods = true;
                    this.allowedUnknownHttpMethods = Collections.emptySet();
                    return;
                }
                try {
                    HttpMethod.valueOf(string2);
                    bl = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = false;
                }
                if (!bl) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        HttpMethod[] httpMethodArray = HttpMethod.values();
                        Object[] objectArray = new Object[httpMethodArray.length + 1];
                        objectArray[0] = string2;
                        System.arraycopy(httpMethodArray, HttpMethod.OPTIONS.ordinal(), objectArray, 1, httpMethodArray.length);
                        LOGGER.log(Level.WARNING, "warning.webapp.facesservlet.init_invalid_http_method", objectArray);
                    }
                    if (this.allowedUnknownHttpMethods.contains(string2)) continue;
                    this.allowedUnknownHttpMethods.add(string2);
                    continue;
                }
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
            if (5 == arrayList.size()) {
                this.allowedKnownHttpMethods = EnumSet.of(HttpMethod.valueOf((String)arrayList.get(0)), HttpMethod.valueOf((String)arrayList.get(1)), HttpMethod.valueOf((String)arrayList.get(2)), HttpMethod.valueOf((String)arrayList.get(3)), HttpMethod.valueOf((String)arrayList.get(4)));
            } else if (4 == arrayList.size()) {
                this.allowedKnownHttpMethods = EnumSet.of(HttpMethod.valueOf((String)arrayList.get(0)), HttpMethod.valueOf((String)arrayList.get(1)), HttpMethod.valueOf((String)arrayList.get(2)), HttpMethod.valueOf((String)arrayList.get(3)));
            } else if (3 == arrayList.size()) {
                this.allowedKnownHttpMethods = EnumSet.of(HttpMethod.valueOf((String)arrayList.get(0)), HttpMethod.valueOf((String)arrayList.get(1)), HttpMethod.valueOf((String)arrayList.get(2)));
            } else if (2 == arrayList.size()) {
                this.allowedKnownHttpMethods = EnumSet.of(HttpMethod.valueOf((String)arrayList.get(0)), HttpMethod.valueOf((String)arrayList.get(1)));
            } else if (1 == arrayList.size()) {
                this.allowedKnownHttpMethods = EnumSet.of(HttpMethod.valueOf((String)arrayList.get(0)));
            } else {
                ArrayList arrayList2 = new ArrayList(arrayList.size() - 1);
                for (int i = 1; i < arrayList.size() - 1; ++i) {
                    arrayList2.add(HttpMethod.valueOf((String)arrayList.get(i)));
                }
                HttpMethod httpMethod = HttpMethod.valueOf((String)arrayList.get(0));
                HttpMethod[] httpMethodArray = new HttpMethod[arrayList2.size()];
                arrayList2.toArray(httpMethodArray);
                this.allowedKnownHttpMethods = EnumSet.of(httpMethod, httpMethodArray);
            }
        }
    }

    private void uninitHttpMethodValidityVerification() {
        assert (null != this.allowedUnknownHttpMethods);
        assert (null != this.defaultAllowedHttpMethods);
        assert (null != this.allHttpMethods);
        this.allowedUnknownHttpMethods.clear();
        this.allowedUnknownHttpMethods = null;
        this.allowedKnownHttpMethods.clear();
        this.allowedKnownHttpMethods = null;
        this.allHttpMethods.clear();
        this.allHttpMethods = null;
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        FacesContext facesContext;
        String string;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        this.requestStart(httpServletRequest.getRequestURI());
        if (!this.isHttpMethodValid(httpServletRequest)) {
            httpServletResponse.sendError(400);
            return;
        }
        if (Thread.currentThread().isInterrupted() && LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINE, "Thread {0} given to FacesServlet.service() in interrupted state", Thread.currentThread().getName());
        }
        if ((string = httpServletRequest.getPathInfo()) != null && ((string = string.toUpperCase()).contains("/WEB-INF/") || string.contains("/WEB-INF") || string.contains("/META-INF/") || string.contains("/META-INF"))) {
            httpServletResponse.sendError(404);
            return;
        }
        if (!this.initFacesContextReleased) {
            facesContext = FacesContext.getCurrentInstance();
            if (null != facesContext) {
                facesContext.release();
            }
            this.initFacesContextReleased = true;
        }
        facesContext = this.facesContextFactory.getFacesContext(this.servletConfig.getServletContext(), httpServletRequest, httpServletResponse, this.lifecycle);
        try {
            ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
            if (resourceHandler.isResourceRequest(facesContext)) {
                resourceHandler.handleResourceRequest(facesContext);
            } else {
                this.lifecycle.execute(facesContext);
                this.lifecycle.render(facesContext);
            }
        }
        catch (FacesException facesException) {
            Throwable throwable = facesException.getCause();
            if (throwable == null) {
                throw new ServletException(facesException.getMessage(), (Throwable)facesException);
            }
            if (throwable instanceof ServletException) {
                throw (ServletException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new ServletException(throwable.getMessage(), throwable);
        }
        finally {
            facesContext.release();
        }
        this.requestEnd();
    }

    private boolean isHttpMethodValid(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        if (this.allowAllMethods) {
            bl = true;
        } else {
            boolean bl2;
            String string = httpServletRequest.getMethod();
            HttpMethod httpMethod = null;
            try {
                httpMethod = HttpMethod.valueOf(string);
                bl2 = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl2 = false;
            }
            bl = bl2 ? this.allowedKnownHttpMethods.contains((Object)httpMethod) : this.allowedUnknownHttpMethods.contains(string);
        }
        return bl;
    }

    private void requestStart(String string) {
    }

    private void requestEnd() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HttpMethod {
        OPTIONS("OPTIONS"),
        GET("GET"),
        HEAD("HEAD"),
        POST("POST"),
        PUT("PUT"),
        DELETE("DELETE"),
        TRACE("TRACE"),
        CONNECT("CONNECT");

        private String name;

        private HttpMethod(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }
}

