/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.MessageFactory;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.faces.validator.ValueExpressionAnalyzer;
import javax.faces.validator.ValueReference;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;

public class BeanValidator
implements Validator,
PartialStateHolder {
    private static final Logger LOGGER = Logger.getLogger("javax.faces.validator", "javax.faces.LogStrings");
    private String validationGroups;
    private transient Class[] cachedValidationGroups;
    public static final String VALIDATOR_ID = "javax.faces.Bean";
    public static final String MESSAGE_ID = "javax.faces.validator.BeanValidator.MESSAGE";
    public static final String VALIDATOR_FACTORY_KEY = "javax.faces.validator.beanValidator.ValidatorFactory";
    public static final String VALIDATION_GROUPS_DELIMITER = ",";
    public static final String EMPTY_VALIDATION_GROUPS_PATTERN = "^[\\W,]*$";
    public static final String DISABLE_DEFAULT_BEAN_VALIDATOR_PARAM_NAME = "javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR";
    private boolean initialState;
    private boolean transientValue = false;

    public void setValidationGroups(String string) {
        this.clearInitialState();
        if (string != null && string.matches(EMPTY_VALIDATION_GROUPS_PATTERN)) {
            string = null;
        }
        if (string == null && this.validationGroups != null || string != null && !string.equals(this.validationGroups)) {
            this.cachedValidationGroups = null;
        }
        this.validationGroups = string;
    }

    public String getValidationGroups() {
        return this.validationGroups;
    }

    public void validate(FacesContext facesContext, UIComponent uIComponent, Object object) {
        ValidatorFactory validatorFactory;
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (uIComponent == null) {
            throw new NullPointerException();
        }
        ValueExpression valueExpression = uIComponent.getValueExpression("value");
        if (valueExpression == null) {
            return;
        }
        Object object2 = facesContext.getExternalContext().getApplicationMap().get(VALIDATOR_FACTORY_KEY);
        if (object2 instanceof ValidatorFactory) {
            validatorFactory = (ValidatorFactory)object2;
        } else {
            try {
                validatorFactory = Validation.buildDefaultValidatorFactory();
            }
            catch (ValidationException validationException) {
                throw new FacesException("Could not build a default Bean Validator factory", validationException);
            }
            facesContext.getExternalContext().getApplicationMap().put(VALIDATOR_FACTORY_KEY, validatorFactory);
        }
        ValidatorContext validatorContext = validatorFactory.usingContext();
        JsfAwareMessageInterpolator jsfAwareMessageInterpolator = new JsfAwareMessageInterpolator(facesContext, validatorFactory.getMessageInterpolator());
        validatorContext.messageInterpolator((MessageInterpolator)jsfAwareMessageInterpolator);
        javax.validation.Validator validator = validatorContext.getValidator();
        Class[] classArray = this.parseValidationGroups(this.getValidationGroups());
        ValueExpressionAnalyzer valueExpressionAnalyzer = new ValueExpressionAnalyzer(valueExpression);
        ValueReference valueReference = valueExpressionAnalyzer.getReference(facesContext.getELContext());
        if (valueReference == null) {
            return;
        }
        if (this.isResolvable(valueReference, valueExpression)) {
            Object object3;
            Set set = null;
            try {
                set = validator.validateValue(valueReference.getBaseClass(), valueReference.getProperty(), object, classArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object3 = "Unable to validate expression " + valueExpression.getExpressionString() + " using Bean Validation.  Unable to get value of expression. " + " Message from Bean Validation: " + illegalArgumentException.getMessage();
                LOGGER.fine((String)object3);
            }
            if (set != null && !set.isEmpty()) {
                ValidatorException validatorException;
                if (1 == set.size()) {
                    object3 = (ConstraintViolation)set.iterator().next();
                    validatorException = new ValidatorException(MessageFactory.getMessage(facesContext, MESSAGE_ID, object3.getMessage(), MessageFactory.getLabel(facesContext, uIComponent)));
                } else {
                    object3 = new LinkedHashSet(set.size());
                    for (ConstraintViolation constraintViolation : set) {
                        object3.add(MessageFactory.getMessage(facesContext, MESSAGE_ID, constraintViolation.getMessage(), MessageFactory.getLabel(facesContext, uIComponent)));
                    }
                    validatorException = new ValidatorException((Collection<FacesMessage>)object3);
                }
                throw validatorException;
            }
        }
    }

    private boolean isResolvable(ValueReference valueReference, ValueExpression valueExpression) {
        Boolean bl = null;
        String string = null;
        if (null == valueExpression) {
            string = "Unable to validate expression using Bean Validation.  Expression must not be null.";
            bl = false;
        } else if (null == valueReference) {
            string = "Unable to validate expression " + valueExpression.getExpressionString() + " using Bean Validation.  Unable to get value of expression.";
            bl = false;
        } else {
            Class clazz = valueReference.getBaseClass();
            if (null != clazz && (Map.class.isAssignableFrom(clazz) || Collection.class.isAssignableFrom(clazz) || Array.class.isAssignableFrom(clazz))) {
                string = "Unable to validate expression " + valueExpression.getExpressionString() + " using Bean Validation.  Expression evaluates to a Map, List or array.";
                bl = false;
            }
        }
        bl = null != bl ? bl : true;
        if (!bl.booleanValue()) {
            LOGGER.fine(string);
        }
        return bl;
    }

    private Class[] parseValidationGroups(String string) {
        String[] stringArray;
        if (this.cachedValidationGroups != null) {
            return this.cachedValidationGroups;
        }
        if (string == null) {
            this.cachedValidationGroups = new Class[]{Default.class};
            return this.cachedValidationGroups;
        }
        ArrayList arrayList = new ArrayList();
        for (String string2 : stringArray = string.split(VALIDATION_GROUPS_DELIMITER)) {
            if ((string2 = string2.trim()).length() == 0) continue;
            if (string2.equals(Default.class.getName())) {
                arrayList.add(Default.class);
                continue;
            }
            try {
                arrayList.add(Class.forName(string2, false, Thread.currentThread().getContextClassLoader()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    arrayList.add(Class.forName(string2));
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    throw new FacesException("Validation group not found: " + string2);
                }
            }
        }
        this.cachedValidationGroups = arrayList.toArray(new Class[arrayList.size()]);
        return this.cachedValidationGroups;
    }

    public Object saveState(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.initialStateMarked()) {
            Object[] objectArray = new Object[]{this.validationGroups};
            return objectArray;
        }
        return null;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (object != null) {
            Object[] objectArray = (Object[])object;
            this.validationGroups = (String)objectArray[0];
        }
    }

    public void markInitialState() {
        this.initialState = true;
    }

    public boolean initialStateMarked() {
        return this.initialState;
    }

    public void clearInitialState() {
        this.initialState = false;
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean bl) {
        this.transientValue = bl;
    }

    private static class JsfAwareMessageInterpolator
    implements MessageInterpolator {
        private FacesContext context;
        private MessageInterpolator delegate;

        public JsfAwareMessageInterpolator(FacesContext facesContext, MessageInterpolator messageInterpolator) {
            this.context = facesContext;
            this.delegate = messageInterpolator;
        }

        public String interpolate(String string, MessageInterpolator.Context context) {
            Locale locale = this.context.getViewRoot().getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            return this.delegate.interpolate(string, context, locale);
        }

        public String interpolate(String string, MessageInterpolator.Context context, Locale locale) {
            return this.delegate.interpolate(string, context, locale);
        }
    }
}

