/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component.behavior;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.ClientBehaviorBase;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxBehavior
extends ClientBehaviorBase {
    public static final String BEHAVIOR_ID = "javax.faces.behavior.Ajax";
    private static final Set<ClientBehaviorHint> HINTS = Collections.unmodifiableSet(EnumSet.of(ClientBehaviorHint.SUBMITTING));
    private String onerror;
    private String onevent;
    private List<String> execute;
    private List<String> render;
    private Boolean disabled;
    private Boolean immediate;
    private Map<String, ValueExpression> bindings;
    private static final String ONEVENT = "onevent";
    private static final String ONERROR = "onerror";
    private static final String IMMEDIATE = "immediate";
    private static final String DISABLED = "disabled";
    private static final String EXECUTE = "execute";
    private static final String RENDER = "render";
    private static String ALL = "@all";
    private static String FORM = "@form";
    private static String THIS = "@this";
    private static String NONE = "@none";
    private static List<String> ALL_LIST = Collections.singletonList("@all");
    private static List<String> FORM_LIST = Collections.singletonList("@form");
    private static List<String> THIS_LIST = Collections.singletonList("@this");
    private static List<String> NONE_LIST = Collections.singletonList("@none");
    private static Pattern SPLIT_PATTERN = Pattern.compile(" ");

    @Override
    public String getRendererType() {
        return BEHAVIOR_ID;
    }

    @Override
    public Set<ClientBehaviorHint> getHints() {
        return HINTS;
    }

    public String getOnerror() {
        return (String)this.eval(ONERROR, this.onerror);
    }

    public void setOnerror(String string) {
        this.onerror = string;
        this.clearInitialState();
    }

    public String getOnevent() {
        return (String)this.eval(ONEVENT, this.onevent);
    }

    public void setOnevent(String string) {
        this.onevent = string;
        this.clearInitialState();
    }

    public Collection<String> getExecute() {
        return this.getCollectionValue(EXECUTE, this.execute);
    }

    public void setExecute(Collection<String> collection) {
        this.execute = this.copyToList(collection);
        this.clearInitialState();
    }

    public Collection<String> getRender() {
        return this.getCollectionValue(RENDER, this.render);
    }

    public void setRender(Collection<String> collection) {
        this.render = this.copyToList(collection);
        this.clearInitialState();
    }

    public boolean isDisabled() {
        Boolean bl = (Boolean)this.eval(DISABLED, this.disabled);
        return bl != null ? bl : false;
    }

    public void setDisabled(boolean bl) {
        this.disabled = bl;
        this.clearInitialState();
    }

    public boolean isImmediate() {
        Boolean bl = (Boolean)this.eval(IMMEDIATE, this.immediate);
        return bl != null ? bl : false;
    }

    public void setImmediate(boolean bl) {
        this.immediate = bl;
        this.clearInitialState();
    }

    public boolean isImmediateSet() {
        return this.immediate != null || this.getValueExpression(IMMEDIATE) != null;
    }

    public ValueExpression getValueExpression(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return this.bindings == null ? null : this.bindings.get(string);
    }

    public void setValueExpression(String string, ValueExpression valueExpression) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (valueExpression != null) {
            if (valueExpression.isLiteralText()) {
                this.setLiteralValue(string, valueExpression);
            } else {
                if (this.bindings == null) {
                    this.bindings = new HashMap<String, ValueExpression>(6, 1.0f);
                }
                this.bindings.put(string, valueExpression);
            }
        } else if (this.bindings != null) {
            this.bindings.remove(string);
            if (this.bindings.isEmpty()) {
                this.bindings = null;
            }
        }
        this.clearInitialState();
    }

    public void addAjaxBehaviorListener(AjaxBehaviorListener ajaxBehaviorListener) {
        this.addBehaviorListener(ajaxBehaviorListener);
    }

    public void removeAjaxBehaviorListener(AjaxBehaviorListener ajaxBehaviorListener) {
        this.removeBehaviorListener(ajaxBehaviorListener);
    }

    @Override
    public Object saveState(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        Object object = super.saveState(facesContext);
        Object object2 = this.initialStateMarked() ? (object == null ? null : new Object[]{object}) : new Object[]{object, this.onerror, this.onevent, this.disabled, this.immediate, AjaxBehavior.saveList(this.execute), AjaxBehavior.saveList(this.render), AjaxBehavior.saveBindings(facesContext, this.bindings)};
        return object2;
    }

    @Override
    public void restoreState(FacesContext facesContext, Object object) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (object != null) {
            Object[] objectArray = (Object[])object;
            super.restoreState(facesContext, objectArray[0]);
            if (objectArray.length != 1) {
                this.onerror = (String)objectArray[1];
                this.onevent = (String)objectArray[2];
                this.disabled = (Boolean)objectArray[3];
                this.immediate = (Boolean)objectArray[4];
                this.execute = AjaxBehavior.restoreList(EXECUTE, objectArray[5]);
                this.render = AjaxBehavior.restoreList(RENDER, objectArray[6]);
                this.bindings = AjaxBehavior.restoreBindings(facesContext, objectArray[7]);
                this.clearInitialState();
            }
        }
    }

    private static Object saveBindings(FacesContext facesContext, Map<String, ValueExpression> map) {
        if (map == null) {
            return null;
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = map.keySet().toArray(new String[map.size()]);
        Object[] objectArray2 = map.values().toArray();
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = UIComponentBase.saveAttachedState(facesContext, objectArray2[i]);
        }
        objectArray[1] = objectArray2;
        return objectArray;
    }

    private static Map<String, ValueExpression> restoreBindings(FacesContext facesContext, Object object) {
        if (object == null) {
            return null;
        }
        Object[] objectArray = (Object[])object;
        String[] stringArray = (String[])objectArray[0];
        Object[] objectArray2 = (Object[])objectArray[1];
        HashMap<String, ValueExpression> hashMap = new HashMap<String, ValueExpression>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], (ValueExpression)UIComponentBase.restoreAttachedState(facesContext, objectArray2[i]));
        }
        return hashMap;
    }

    private static Object saveList(List<String> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int n = list.size();
        if (n == 1) {
            return list.get(0);
        }
        return list.toArray(new String[n]);
    }

    private static List<String> restoreList(String string, Object object) {
        if (object == null) {
            return null;
        }
        List<String> list = null;
        if (object instanceof String) {
            list = AjaxBehavior.toSingletonList(string, (String)object);
        } else if (object instanceof String[]) {
            list = Collections.unmodifiableList(Arrays.asList((String[])object));
        }
        return list;
    }

    private Object eval(String string, Object object) {
        if (object != null) {
            return object;
        }
        ValueExpression valueExpression = this.getValueExpression(string);
        if (valueExpression != null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            return valueExpression.getValue(facesContext.getELContext());
        }
        return null;
    }

    private Collection<String> getCollectionValue(String string, Collection<String> collection) {
        FacesContext facesContext;
        Object object;
        if (collection != null) {
            return collection;
        }
        List<String> list = null;
        ValueExpression valueExpression = this.getValueExpression(string);
        if (valueExpression != null && (object = valueExpression.getValue((facesContext = FacesContext.getCurrentInstance()).getELContext())) != null) {
            if (object instanceof Collection) {
                return (Collection)object;
            }
            list = AjaxBehavior.toList(string, valueExpression, object);
        }
        return list == null ? Collections.emptyList() : list;
    }

    private void setLiteralValue(String string, ValueExpression valueExpression) {
        Object object;
        assert (valueExpression.isLiteralText());
        ELContext eLContext = FacesContext.getCurrentInstance().getELContext();
        try {
            object = valueExpression.getValue(eLContext);
        }
        catch (ELException eLException) {
            throw new FacesException(eLException);
        }
        if (ONEVENT.equals(string)) {
            this.onevent = (String)object;
        } else if (ONERROR.equals(string)) {
            this.onerror = (String)object;
        } else if (IMMEDIATE.equals(string)) {
            this.immediate = (Boolean)object;
        } else if (DISABLED.equals(string)) {
            this.disabled = (Boolean)object;
        } else if (EXECUTE.equals(string)) {
            this.execute = AjaxBehavior.toList(string, valueExpression, object);
        } else if (RENDER.equals(string)) {
            this.render = AjaxBehavior.toList(string, valueExpression, object);
        }
    }

    private static List<String> toList(String string, ValueExpression valueExpression, Object object) {
        if (object instanceof String) {
            String string2 = (String)object;
            if (string2.indexOf(32) == -1) {
                return AjaxBehavior.toSingletonList(string, string2);
            }
            String[] stringArray = SPLIT_PATTERN.split(string2);
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            return Collections.unmodifiableList(Arrays.asList(stringArray));
        }
        throw new FacesException(valueExpression.toString() + " : '" + string + "' attribute value must be either a String or a Collection");
    }

    private static List<String> toSingletonList(String string, String string2) {
        if (null == string2 || string2.length() == 0) {
            return null;
        }
        if (string2.charAt(0) == '@') {
            List<String> list;
            if (ALL.equals(string2)) {
                list = ALL_LIST;
            } else if (FORM.equals(string2)) {
                list = FORM_LIST;
            } else if (THIS.equals(string2)) {
                list = THIS_LIST;
            } else if (NONE.equals(string2)) {
                list = NONE_LIST;
            } else {
                throw new FacesException(string2 + " : Invalid id keyword specified for '" + string + "' attribute");
            }
            return list;
        }
        return Collections.singletonList(string2);
    }

    private List<String> copyToList(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableList(new ArrayList<String>(collection));
    }
}

