/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.StateHelper;
import javax.faces.component.StateHolder;
import javax.faces.component.StateHolderSaver;
import javax.faces.component.TransientStateHelper;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComponentStateHelper
implements StateHelper,
TransientStateHelper {
    private UIComponent component;
    private boolean isTransient;
    private Map<Serializable, Object> deltaMap;
    private Map<Serializable, Object> defaultMap;
    private Map<Object, Object> transientState;

    public ComponentStateHelper(UIComponent uIComponent) {
        this.component = uIComponent;
        this.deltaMap = new HashMap<Serializable, Object>();
        this.defaultMap = new HashMap<Serializable, Object>();
        this.transientState = null;
    }

    @Override
    public Object put(Serializable serializable, Object object) {
        if (this.component.initialStateMarked() || object instanceof PartialStateHolder) {
            Object object2 = this.deltaMap.put(serializable, object);
            if (object2 == null) {
                return this.defaultMap.put(serializable, object);
            }
            this.defaultMap.put(serializable, object);
            return object2;
        }
        return this.defaultMap.put(serializable, object);
    }

    @Override
    public Object remove(Serializable serializable) {
        if (this.component.initialStateMarked()) {
            Object object = this.deltaMap.remove(serializable);
            if (object == null) {
                return this.defaultMap.remove(serializable);
            }
            this.defaultMap.remove(serializable);
            return object;
        }
        return this.defaultMap.remove(serializable);
    }

    @Override
    public Object put(Serializable serializable, String string, Object object) {
        Map<String, Object> map;
        Object object2 = null;
        if (this.component.initialStateMarked()) {
            map = (Map)this.deltaMap.get(serializable);
            if (map == null) {
                map = new HashMap(5);
                this.deltaMap.put(serializable, map);
            }
            object2 = map.put(string, object);
        }
        if ((map = (HashMap<String, Object>)this.get(serializable)) == null) {
            map = new HashMap<String, Object>(8);
            this.defaultMap.put(serializable, map);
        }
        if (object2 == null) {
            return map.put(string, object);
        }
        map.put(string, object);
        return object2;
    }

    @Override
    public Object get(Serializable serializable) {
        return this.defaultMap.get(serializable);
    }

    @Override
    public Object eval(Serializable serializable) {
        return this.eval(serializable, null);
    }

    @Override
    public Object eval(Serializable serializable, Object object) {
        ValueExpression valueExpression;
        Object object2 = this.get(serializable);
        if (object2 == null && (valueExpression = this.component.getValueExpression(serializable.toString())) != null) {
            object2 = valueExpression.getValue(this.component.getFacesContext().getELContext());
        }
        return object2 != null ? object2 : object;
    }

    @Override
    public void add(Serializable serializable, Object object) {
        List<Object> list;
        if (this.component.initialStateMarked()) {
            list = (List)this.deltaMap.get(serializable);
            if (list == null) {
                list = new ArrayList(4);
                this.deltaMap.put(serializable, list);
            }
            list.add(object);
        }
        if ((list = (ArrayList<Object>)this.get(serializable)) == null) {
            list = new ArrayList<Object>(4);
            this.defaultMap.put(serializable, list);
        }
        list.add(object);
    }

    @Override
    public Object remove(Serializable serializable, Object object) {
        Object object2 = this.get(serializable);
        if (object2 instanceof Collection) {
            return this.removeFromList(serializable, object);
        }
        if (object2 instanceof Map) {
            return this.removeFromMap(serializable, object.toString());
        }
        return null;
    }

    @Override
    public Object saveState(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (this.component.initialStateMarked()) {
            return this.saveMap(facesContext, this.deltaMap);
        }
        return this.saveMap(facesContext, this.defaultMap);
    }

    @Override
    public void restoreState(FacesContext facesContext, Object object) {
        Object[] objectArray;
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (object == null) {
            return;
        }
        if (!this.component.initialStateMarked() && !this.defaultMap.isEmpty()) {
            this.defaultMap.clear();
            if (this.deltaMap != null && !this.deltaMap.isEmpty()) {
                this.deltaMap.clear();
            }
        }
        if ((objectArray = (Object[])object)[objectArray.length - 1] != null) {
            this.component.initialState = (Boolean)objectArray[objectArray.length - 1];
        }
        int n = (objectArray.length - 1) / 2;
        for (int i = 0; i < n; ++i) {
            Object object2 = objectArray[i * 2 + 1];
            if (Void.TYPE.equals(object2)) {
                object2 = null;
            }
            Serializable serializable = (Serializable)objectArray[i * 2];
            if (object2 != null) {
                if (object2 instanceof Collection) {
                    object2 = UIComponentBase.restoreAttachedState(facesContext, object2);
                } else if (object2 instanceof StateHolderSaver) {
                    object2 = ((StateHolderSaver)object2).restore(facesContext);
                } else {
                    Object object3 = object2 = object2 instanceof Serializable ? object2 : UIComponentBase.restoreAttachedState(facesContext, object2);
                }
            }
            if (object2 instanceof Map) {
                for (Map.Entry entry : ((Map)object2).entrySet()) {
                    this.put(serializable, (String)entry.getKey(), entry.getValue());
                }
                continue;
            }
            if (object2 instanceof List) {
                List list = (List)this.get(serializable);
                for (Object e : (List)object2) {
                    if (list != null && list.contains(e)) continue;
                    this.add(serializable, e);
                }
                continue;
            }
            this.put(serializable, object2);
        }
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public void setTransient(boolean bl) {
        this.isTransient = bl;
    }

    private Object saveMap(FacesContext facesContext, Map<Serializable, Object> map) {
        if (map.isEmpty()) {
            if (!this.component.initialStateMarked()) {
                return new Object[]{this.component.initialStateMarked()};
            }
            return null;
        }
        Object[] objectArray = new Object[map.size() * 2 + 1];
        int n = 0;
        for (Map.Entry<Serializable, Object> entry : map.entrySet()) {
            Class<Void> clazz = entry.getValue();
            if (clazz == null) {
                clazz = Void.TYPE;
            }
            objectArray[n * 2] = entry.getKey();
            if (clazz instanceof Collection || clazz instanceof StateHolder || clazz instanceof Map || !(clazz instanceof Serializable)) {
                clazz = UIComponentBase.saveAttachedState(facesContext, clazz);
            }
            objectArray[n * 2 + 1] = clazz;
            ++n;
        }
        if (!this.component.initialStateMarked()) {
            objectArray[objectArray.length - 1] = this.component.initialStateMarked();
        }
        return objectArray;
    }

    private Object removeFromList(Serializable serializable, Object object) {
        Collection collection;
        Boolean bl = null;
        if ((this.component.initialStateMarked() || object instanceof PartialStateHolder) && (collection = (Collection)this.deltaMap.get(serializable)) != null) {
            bl = collection.remove(object);
            if (collection.isEmpty()) {
                this.deltaMap.remove(serializable);
            }
        }
        if ((collection = (Collection)this.get(serializable)) != null) {
            if (bl == null) {
                bl = collection.remove(object);
            } else {
                collection.remove(object);
            }
            if (collection.isEmpty()) {
                this.defaultMap.remove(serializable);
            }
        }
        return bl;
    }

    private Object removeFromMap(Serializable serializable, String string) {
        Map map;
        Object var3_3 = null;
        if (this.component.initialStateMarked() && (map = (Map)this.deltaMap.get(serializable)) != null) {
            var3_3 = map.remove(string);
            if (map.isEmpty()) {
                this.deltaMap.remove(serializable);
            }
        }
        if ((map = (Map)this.get(serializable)) != null) {
            if (var3_3 == null) {
                var3_3 = map.remove(string);
            } else {
                map.remove(string);
            }
            if (map.isEmpty()) {
                this.defaultMap.remove(serializable);
            }
        }
        if (var3_3 != null && !this.component.initialStateMarked()) {
            this.deltaMap.remove(serializable);
        }
        return var3_3;
    }

    @Override
    public Object getTransient(Object object) {
        return this.transientState == null ? null : this.transientState.get(object);
    }

    @Override
    public Object getTransient(Object object, Object object2) {
        Object object3;
        Object object4 = object3 = this.transientState == null ? null : this.transientState.get(object);
        if (object3 != null) {
            return object3;
        }
        return object2;
    }

    @Override
    public Object putTransient(Object object, Object object2) {
        if (this.transientState == null) {
            this.transientState = new HashMap<Object, Object>();
        }
        return this.transientState.put(object, object2);
    }

    @Override
    public void restoreTransientState(FacesContext facesContext, Object object) {
        this.transientState = (Map)object;
    }

    @Override
    public Object saveTransientState(FacesContext facesContext) {
        return this.transientState;
    }
}

