/*
 * Decompiled with CFR 0.152.
 */
package com.sun.facelets.tag;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.BeanPropertyTagRule;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.MetaRuleset;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataImpl;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.MetadataTargetImpl;
import com.sun.facelets.tag.Tag;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagException;
import com.sun.facelets.util.ParameterCheck;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

final class MetaRulesetImpl
extends MetaRuleset {
    private static final WeakHashMap metadata = new WeakHashMap();
    private static final Logger log = Logger.getLogger("facelets.tag.meta");
    private final Tag tag;
    private final Class type;
    private final Map attributes;
    private final List mappers;
    private final List rules;
    private static final Metadata NONE = new Metadata(){

        public void applyMetadata(FaceletContext ctx, Object instance) {
        }
    };

    public MetaRulesetImpl(Tag tag, Class type, boolean recreateValueExpressionsOnly) {
        this.tag = tag;
        this.type = type;
        this.attributes = new HashMap();
        this.mappers = new ArrayList();
        this.rules = new ArrayList();
        TagAttribute[] attrs = this.tag.getAttributes().getAll();
        for (int i = 0; i < attrs.length; ++i) {
            if (attrs[i].isLiteral() && recreateValueExpressionsOnly) continue;
            this.attributes.put(attrs[i].getLocalName(), attrs[i]);
        }
        this.rules.add(BeanPropertyTagRule.Instance);
    }

    public MetaRuleset ignore(String attribute) {
        ParameterCheck.notNull("attribute", attribute);
        this.attributes.remove(attribute);
        return this;
    }

    public MetaRuleset alias(String attribute, String property) {
        ParameterCheck.notNull("attribute", attribute);
        ParameterCheck.notNull("property", property);
        TagAttribute attr = (TagAttribute)this.attributes.remove(attribute);
        if (attr != null) {
            this.attributes.put(property, attr);
        }
        return this;
    }

    public MetaRuleset add(Metadata mapper) {
        ParameterCheck.notNull("mapper", mapper);
        if (!this.mappers.contains(mapper)) {
            this.mappers.add(mapper);
        }
        return this;
    }

    public MetaRuleset addRule(MetaRule rule) {
        ParameterCheck.notNull("rule", rule);
        this.rules.add(rule);
        return this;
    }

    private final MetadataTarget getMetadataTarget() {
        MetadataTarget meta = (MetadataTarget)metadata.get(this.type);
        if (meta == null) {
            try {
                meta = new MetadataTargetImpl(this.type);
            }
            catch (IntrospectionException e) {
                throw new TagException(this.tag, "Error Creating TargetMetadata", e);
            }
            metadata.put(this.type, meta);
        }
        return meta;
    }

    public Metadata finish() {
        if (!this.attributes.isEmpty()) {
            if (this.rules.isEmpty()) {
                if (log.isLoggable(Level.SEVERE)) {
                    Iterator itr = this.attributes.values().iterator();
                    while (itr.hasNext()) {
                        log.severe(itr.next() + " Unhandled by MetaTagHandler for type " + this.type.getName());
                    }
                }
            } else {
                MetadataTarget target = this.getMetadataTarget();
                int ruleEnd = this.rules.size() - 1;
                Iterator itr = this.attributes.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Metadata data = null;
                    for (int i = ruleEnd; data == null && i >= 0; --i) {
                        MetaRule rule = (MetaRule)this.rules.get(i);
                        data = rule.applyRule((String)entry.getKey(), (TagAttribute)entry.getValue(), target);
                    }
                    if (data == null) {
                        if (!log.isLoggable(Level.SEVERE)) continue;
                        log.severe(entry.getValue() + " Unhandled by MetaTagHandler for type " + this.type.getName());
                        continue;
                    }
                    this.mappers.add(data);
                }
            }
        }
        if (this.mappers.isEmpty()) {
            return NONE;
        }
        return new MetadataImpl(this.mappers.toArray(new Metadata[this.mappers.size()]));
    }

    public MetaRuleset ignoreAll() {
        this.attributes.clear();
        return this;
    }
}

