/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.maven.sc;

import com.sun.enterprise.module.maven.sc.ScriptCreationException;
import com.sun.enterprise.module.maven.sc.Section;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class ScriptCreator {
    private final File src;
    private final File dest;
    private final Properties env;
    private Map<String, Section> sections;

    public ScriptCreator(Properties env) {
        if (env == null) {
            throw new IllegalArgumentException("Null arguments");
        }
        this.env = env;
        this.src = new File(env.getProperty("SourceFile"));
        this.dest = new File(env.getProperty("DestinationFile"));
        if (!this.src.exists() || !this.dest.getParentFile().exists()) {
            throw new IllegalArgumentException("Either of these does not exist: " + this.src.getAbsolutePath() + ", " + this.dest.getParentFile().getAbsolutePath());
        }
        this.sections = new HashMap<String, Section>();
    }

    public void create() throws ScriptCreationException {
        try {
            this.parseSections();
            this.writeSections();
        }
        catch (Exception e) {
            throw new ScriptCreationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSections() throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.src));
            Section s = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || this.isEmpty(line)) continue;
                if (this.isSection(line)) {
                    String name = line.substring(1, line.length() - 1);
                    s = new Section(name, this.env);
                    this.sections.put(name, s);
                    continue;
                }
                s.put(line);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean isEmpty(String line) {
        return line.trim().length() == 0;
    }

    private boolean isSection(String line) {
        return line.startsWith("[") && line.endsWith("]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSections() throws IOException {
        PrintWriter writer = new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.dest))){

            public void println(String s) {
                if (ScriptCreator.this.windows()) {
                    super.print(ScriptCreator.backwards(s) + "\r\n");
                } else {
                    super.println(ScriptCreator.forwards(s));
                }
            }
        };
        try {
            this.writePreamble(this.sections.get("copyright"), writer);
            this.writeHeader(this.sections.get("header"), writer);
            this.writeSourceFiles(this.sections.get("source"), writer);
            this.writeEnvironmentVariables(this.sections.get("env.vars"), writer);
            this.writeShellVariables(this.sections.get("shell.vars"), writer);
            this.writeJava(this.sections.get("jvm"), this.sections.get("classpath"), this.sections.get("java.system.properties"), writer);
            this.writeEpilog(writer);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void writePreamble(Section cprsec, PrintWriter writer) {
        if (this.windows()) {
            writer.println("@echo off");
            writer.println(this.commentIt(ScriptCreator.getCopyrightText(cprsec)));
            writer.println("setlocal");
        } else {
            writer.println("#!/bin/sh");
            writer.println(this.commentIt(ScriptCreator.getCopyrightText(cprsec)));
        }
    }

    private void writeEpilog(PrintWriter writer) {
        if (this.windows()) {
            writer.println("endlocal");
        }
    }

    private void writeHeader(Section header, PrintWriter writer) {
        Map<String, String> props = null;
        if (header == null || (props = header.getProps()) == null) {
            return;
        }
        String line = null;
        for (String value : props.values()) {
            line = this.commentIt(value);
            writer.println(line);
        }
    }

    private String commentIt(String s) {
        if (this.windows()) {
            return "REM " + s;
        }
        return "#" + s;
    }

    private static String getCopyrightText(Section cps) {
        String text = "";
        if (cps != null) {
            Map<String, String> props = cps.getProps();
            for (String value : props.values()) {
                text = text + value + " ";
            }
        }
        return text;
    }

    private void writeSourceFiles(Section s, PrintWriter writer) {
        Map<String, String> props = null;
        if (s == null || (props = s.getProps()) == null) {
            return;
        }
        String line = null;
        for (String value : props.values()) {
            line = this.windows() ? "call " + value + ".bat" : ". " + value;
            writer.println(line);
        }
    }

    private void writeEnvironmentVariables(Section s, PrintWriter writer) {
        Map<String, String> props = null;
        if (s == null || (props = s.getProps()) == null) {
            return;
        }
        String line = null;
        for (String key : props.keySet()) {
            line = this.windows() ? "set " + key + "=" + props.get(key) : "export " + key + "=" + props.get(key);
            writer.println(line);
        }
        this.writeJavaBlock(writer);
    }

    private void writeJavaBlock(PrintWriter writer) {
        if (this.windows()) {
            writer.println("if defined JAVA_HOME (");
            writer.println("set JAVA=%JAVA_HOME%/bin/java");
            writer.println(") else (");
            writer.println("set JAVA=java");
            writer.println(")");
        } else {
            writer.println("if [ ${JAVA_HOME}abc = \"abc\" ]");
            writer.println("then");
            writer.println("  export JAVA=${JAVA_HOME}/bin/java");
            writer.println("else");
            writer.println("  export JAVA=java");
        }
    }

    private void writeShellVariables(Section s, PrintWriter writer) {
        Map<String, String> props = null;
        if (s == null || (props = s.getProps()) == null) {
            return;
        }
        String line = null;
        for (String key : props.keySet()) {
            line = this.windows() ? "set " + key + "=" + props.get(key) : key + "=" + props.get(key);
            writer.println(line);
        }
    }

    private void writeJava(Section jvm, Section cp, Section sysPropsSection, PrintWriter writer) {
        if (jvm == null) {
            return;
        }
        String javaPath = this.getJavaPath() + " ";
        String jvmOptions = "";
        if (jvm.getProperty("jvm.options") != null) {
            jvmOptions = jvm.getProperty("jvm.options") + " ";
        }
        String thingThatRuns = this.getMainClassOrJarFile(jvm) + " ";
        String classpath = this.getClasspathStr(cp) + " ";
        String systemProps = this.getSystemProps(sysPropsSection) + " ";
        String params = this.getParams();
        StringBuffer sb = new StringBuffer();
        sb = sb.append(javaPath).append(jvmOptions).append(classpath).append(systemProps).append(thingThatRuns).append(params);
        writer.println(sb.toString());
    }

    private String getJavaPath() {
        if (this.windows()) {
            return "%JAVA%";
        }
        return "$JAVA";
    }

    private String getMainClassOrJarFile(Section jvm) {
        Map<String, String> props = jvm.getProps();
        String runner = null;
        String jar = props.get("jar");
        if (jar != null) {
            runner = "-jar " + jar;
        } else {
            String mc = props.get("main.class");
            if (mc == null) {
                throw new IllegalArgumentException("Either: jar or main.classneeds to be specified");
            }
            runner = mc;
        }
        return runner;
    }

    private String getClasspathStr(Section cp) {
        Map<String, String> props = null;
        if (cp == null || (props = cp.getProps()) == null) {
            return "";
        }
        String delim = null;
        delim = this.windows() ? ";" : ":";
        StringBuilder sb = new StringBuilder("-cp ");
        int i = 0;
        for (String value : props.values()) {
            value = ScriptCreator.quote(value);
            if (i++ < props.size() - 1) {
                value = value + delim;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    private String getSystemProps(Section section) {
        Map<String, String> sp = null;
        String line = "";
        if (section == null || (sp = section.getProps()) == null) {
            return line;
        }
        for (String key : sp.keySet()) {
            line = line + ScriptCreator.quote("-D" + key + "=" + sp.get(key));
            line = line + " ";
        }
        return line;
    }

    private String getParams() {
        if (this.windows()) {
            return ScriptCreator.quote("%*");
        }
        return ScriptCreator.quote("${@}");
    }

    boolean windows() {
        return "windows".equals(this.env.get("os"));
    }

    private static String quote(String s) {
        if (s != null) {
            s = "\"" + s + "\"";
        }
        return s;
    }

    private static String forwards(String s) {
        if (s != null) {
            s = s.replace('\\', '/');
        }
        return s;
    }

    private static String backwards(String s) {
        if (s != null) {
            s = s.replace('/', '\\');
        }
        return s;
    }
}

