/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.maven;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.bootstrap.BootException;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import com.sun.enterprise.module.maven.MaskingClassLoader;
import com.sun.enterprise.module.maven.MavenProjectRepository;
import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class RunMojo
extends AbstractMojo {
    private MavenProject project;
    private ArtifactResolver artifactResolver;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private File rootDir;
    private String[] args = new String[0];
    private String mainModule;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        if (this.project.getPackaging().equals("hk2-jar") && (this.project.getArtifact() == null || this.project.getArtifact().getFile() == null)) {
            this.getLog().warn((CharSequence)"This project isn't compiled yet. Perhaps you meant 'mvn compile hk2:run'?");
        }
        if (this.rootDir == null) {
            this.rootDir = this.project.getBasedir();
        }
        try {
            StartupContext context = new StartupContext(this.rootDir, this.args);
            if (this.mainModule == null) {
                new Main().launch(this.createModuleRegistry(), context);
            } else {
                new Main().launch(this.createModuleRegistry(), this.mainModule, context);
            }
        }
        catch (BootException e) {
            throw new MojoExecutionException("Failed to boot up the module system", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to boot up the module system", (Exception)e);
        }
    }

    protected ModulesRegistry createModuleRegistry() throws IOException {
        ModulesRegistry r = AbstractFactory.getInstance().createModulesRegistry();
        r.setParentClassLoader((ClassLoader)new MaskingClassLoader(((Object)((Object)this)).getClass().getClassLoader(), "org.jvnet.hk2", "com.sun.enterprise"));
        MavenProjectRepository.prepareProject((MavenProject)this.project);
        MavenProjectRepository lib = new MavenProjectRepository(this.project, this.artifactResolver, this.localRepository, this.artifactFactory);
        r.addRepository((Repository)lib);
        lib.initialize();
        return r;
    }

    public static String toModuleName(String groupId, String artifactId) {
        return groupId + ':' + artifactId;
    }
}

