/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.maven;

import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.maven.MavenProjectRepository;
import com.sun.enterprise.tools.verifier.hk2.PackageAnalyser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class PackageAnalyserMojo
extends AbstractMojo {
    private static Logger logger = Logger.getAnonymousLogger();
    protected MavenProject project;
    protected Artifact artifact;
    private ArtifactResolver artifactResolver;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        logger.logp(Level.INFO, "PackageAnalyserMojo", "execute", "Analysing modules");
        try {
            MavenProjectRepository repo = new MavenProjectRepository(this.project, this.artifactResolver, this.localRepository, this.artifactFactory);
            repo.initialize();
            PackageAnalyser analyser = new PackageAnalyser((Repository)repo, logger);
            Collection wires = analyser.analyseWirings();
            StringBuilder sb = new StringBuilder("Wiring details are given below:\n");
            for (PackageAnalyser.Wire w : wires) {
                sb.append(w + "\n");
            }
            sb.append("Total number of wires = " + wires.size() + "\n");
            sb.append("Split-Package details are given below:\n");
            Collection splitPkgs = analyser.findSplitPackages();
            for (PackageAnalyser.SplitPackage p : splitPkgs) {
                sb.append(p + "\n");
            }
            sb.append("Total number of Split Packages = " + splitPkgs.size() + "\n");
            sb.append("******** GROSS STATISTICS *********\n");
            sb.append("Total number of bundles in this repository: " + analyser.findAllBundles().size() + "\n");
            sb.append("Total number of wires = " + wires.size() + "\n");
            Collection exportedPkgs = analyser.findAllExportedPackages();
            sb.append("Total number of exported packages = " + exportedPkgs.size() + "\n");
            sb.append("Total number of split-packages = " + splitPkgs.size() + "\n");
            logger.logp(Level.INFO, "PackageAnalyserMojo", "execute", "{0}", new Object[]{sb});
            String reportFilePath = System.getProperty("WiringReportPath", System.getProperty("java.io.tmpdir") + File.separator + "wires.xml");
            analyser.generateWiringReport(exportedPkgs, wires, new PrintStream(new FileOutputStream(new File(reportFilePath))));
            System.out.println("Wiring reported can be found at " + reportFilePath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unexpected exception", (Exception)e);
        }
    }
}

