/*
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.sun.enterprise.module.common_impl;

import com.sun.enterprise.module.InhabitantsDescriptor;
import com.sun.hk2.component.InhabitantParser;
import com.sun.hk2.component.InhabitantsScanner;
import com.sun.hk2.component.KeyValuePairParser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;

/**
 * Implementation of {@link InhabitantsDescriptor} that loads the inhabitants
 * meta-data from a byte array (usually coming from a inhabitant file).
 *
 * @author Jerome Dochez
 */
public class ByteArrayInhabitantsDescriptor implements InhabitantsDescriptor, Serializable {

    public final String systemId;
    private final byte[] data;

    public ByteArrayInhabitantsDescriptor(String systemId, byte[] data) {
        this.systemId = systemId;
        this.data = data;
    }

    public ByteArrayInhabitantsDescriptor(URL systemId, byte[] data) {
        this(systemId.toExternalForm(), data);
    }

    public String getSystemId() {
        return systemId;
    }

    public Iterable<InhabitantParser> createScanner() throws IOException {
        return new InhabitantsScanner(new ByteArrayInputStream(data), systemId);
    }

}
