/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.impl;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleLifecycleListener;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.ResolveError;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import com.sun.enterprise.module.common_impl.AbstractModulesRegistryImpl;
import com.sun.enterprise.module.common_impl.ModuleId;
import com.sun.enterprise.module.impl.ClassLoaderProxy;
import com.sun.enterprise.module.impl.ModuleClassLoader;
import com.sun.enterprise.module.impl.ModuleImpl;
import com.sun.hk2.component.InhabitantsParser;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulesRegistryImpl
extends AbstractModulesRegistryImpl {
    private ClassLoader parentLoader;
    final List<ModuleLifecycleListener> lifecycleListeners = new CopyOnWriteArrayList<ModuleLifecycleListener>();

    public ModulesRegistryImpl(AbstractModulesRegistryImpl parent) {
        super(parent);
    }

    @Override
    public ModulesRegistry createChild() {
        return new ModulesRegistryImpl(this);
    }

    @Override
    protected Module newModule(ModuleDefinition moduleDef) {
        return new ModuleImpl(this, moduleDef);
    }

    @Override
    public void parseInhabitants(Module module, String name, InhabitantsParser inhabitantsParser) throws IOException {
        ((ModuleImpl)ModuleImpl.class.cast(module)).parseInhabitants(name, inhabitantsParser);
    }

    ModuleImpl newPrivateModuleFor(String moduleName, String version) {
        ModuleImpl m;
        if (this.parent != null && (m = ((ModulesRegistryImpl)ModulesRegistryImpl.class.cast(this.parent)).newPrivateModuleFor(moduleName, version)) != null) {
            return m;
        }
        ModuleId id = AbstractFactory.getInstance().createModuleId(moduleName, version);
        Module module = (Module)this.modules.get(id);
        if (module != null) {
            ModuleImpl privateModule = (ModuleImpl)this.newModule(module.getModuleDefinition());
            privateModule.resolve();
            return privateModule;
        }
        return (ModuleImpl)this.loadFromRepository(moduleName, version);
    }

    @Override
    public ModuleImpl getProvidingModule(String providerClassName) {
        return (ModuleImpl)ModuleImpl.class.cast(super.getProvidingModule(providerClassName));
    }

    @Override
    public void setParentClassLoader(ClassLoader parent) {
        this.parentLoader = parent;
    }

    @Override
    public ClassLoader getParentClassLoader() {
        return this.parentLoader;
    }

    @Override
    public ClassLoader getModulesClassLoader(ClassLoader parent, Collection<ModuleDefinition> defs, URL[] urls) throws ResolveError {
        if (parent == null) {
            parent = this.getParentClassLoader();
        }
        ClassLoaderProxy cl = new ClassLoaderProxy(new URL[0], parent);
        for (ModuleDefinition def : defs) {
            Module module = this.makeModuleFor(def.getName(), def.getVersion());
            cl.addDelegate(module.getClassLoader());
        }
        if (urls != null) {
            for (URL url : urls) {
                cl.addURL(url);
            }
        }
        return cl;
    }

    @Override
    public ClassLoader getModulesClassLoader(ClassLoader parent, Collection<ModuleDefinition> defs) throws ResolveError {
        return this.getModulesClassLoader(parent, defs, null);
    }

    @Override
    public Module find(Class clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl == null) {
            return null;
        }
        if (cl instanceof ModuleClassLoader) {
            return ((ModuleClassLoader)cl).getOwner();
        }
        return null;
    }

    @Override
    public void register(ModuleLifecycleListener listener) {
        this.lifecycleListeners.add(listener);
    }

    @Override
    public void unregister(ModuleLifecycleListener listener) {
        this.lifecycleListeners.remove(listener);
    }

    public List<ModuleLifecycleListener> getLifecycleListeners() {
        return Collections.unmodifiableList(this.lifecycleListeners);
    }

    @Override
    public void detachAll() {
        this.modules.clear();
    }

    @Override
    public void shutdown() {
        this.detachAll();
        for (Repository repo : this.repositories.values()) {
            try {
                repo.shutdown();
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Error while closing repository " + repo, e);
            }
        }
    }
}

