/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.common_impl;

import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.impl.Utils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.zip.ZipException;

public abstract class Jar {
    private static final String SERVICE_LOCATION = "META-INF/services";

    private Jar() {
    }

    public abstract Manifest getManifest() throws IOException;

    public abstract void loadMetadata(ModuleMetadata var1);

    public abstract String getBaseName();

    public static Jar create(File file) throws IOException {
        if (file.isDirectory()) {
            return new Directory(file);
        }
        return new Archive(file);
    }

    private static final class Archive
    extends Jar {
        private final JarFile jar;
        private final File file;

        public Archive(File jar) throws IOException {
            try {
                this.jar = new JarFile(jar);
                this.file = jar;
            }
            catch (ZipException e) {
                IOException x = new IOException("Failed to open " + jar);
                x.initCause(e);
                throw x;
            }
        }

        public Manifest getManifest() throws IOException {
            return this.jar.getManifest();
        }

        public void loadMetadata(ModuleMetadata result) {
            if (this.jar.getJarEntry("META-INF/inhabitants") == null && this.jar.getJarEntry(Jar.SERVICE_LOCATION) == null) {
                return;
            }
            Enumeration<JarEntry> entries = this.jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.isDirectory() && entry.getName().startsWith("META-INF/inhabitants")) {
                    String habitatName = entry.getName().substring("META-INF/inhabitants".length() + 1);
                    try {
                        result.addHabitat(habitatName, new ModuleMetadata.InhabitantsDescriptor("jar:" + this.file.toURL() + "!/" + entry.getName(), this.loadFully(entry)));
                    }
                    catch (IOException e) {
                        Utils.getDefaultLogger().log(Level.SEVERE, "Error reading inhabitants list in " + this.jar.getName(), e);
                    }
                    continue;
                }
                if (!entry.getName().startsWith(Jar.SERVICE_LOCATION)) continue;
                String serviceName = entry.getName().substring(Jar.SERVICE_LOCATION.length() + 1);
                try {
                    result.load(new URL("jar:" + this.file.toURL() + "!/" + entry.getName()), serviceName, this.jar.getInputStream(entry));
                }
                catch (IOException e) {
                    Utils.getDefaultLogger().log(Level.SEVERE, "Error reading service provider in " + this.jar.getName(), e);
                }
            }
        }

        public String getBaseName() {
            String name = this.file.getName();
            int idx = name.lastIndexOf(46);
            if (idx >= 0) {
                name = name.substring(0, idx);
            }
            return name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] loadFully(JarEntry e) throws IOException {
            byte[] buf = new byte[(int)e.getSize()];
            DataInputStream in = new DataInputStream(this.jar.getInputStream(e));
            try {
                in.readFully(buf);
                byte[] byArray = buf;
                return byArray;
            }
            finally {
                in.close();
            }
        }
    }

    private static final class Directory
    extends Jar {
        private final File dir;

        public Directory(File dir) {
            this.dir = dir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Manifest getManifest() throws IOException {
            File mf = new File(this.dir, "META-INF/MANIFEST.MF");
            if (mf.exists()) {
                FileInputStream in = new FileInputStream(mf);
                try {
                    Manifest manifest = new Manifest(in);
                    return manifest;
                }
                finally {
                    in.close();
                }
            }
            return null;
        }

        private File[] fixNull(File[] f) {
            if (f == null) {
                return new File[0];
            }
            return f;
        }

        public void loadMetadata(ModuleMetadata result) {
            for (File svc : this.fixNull(new File(this.dir, "META-INF/inhabitants").listFiles())) {
                if (svc.isDirectory()) continue;
                try {
                    result.addHabitat(svc.getName(), new ModuleMetadata.InhabitantsDescriptor(svc.getPath(), this.readFully(svc)));
                }
                catch (IOException e) {
                    Utils.getDefaultLogger().log(Level.SEVERE, "Error reading habitats file from " + svc, e);
                }
            }
            for (File svc : this.fixNull(new File(this.dir, Jar.SERVICE_LOCATION).listFiles())) {
                if (svc.isDirectory()) continue;
                try {
                    result.load(svc.toURL(), svc.getName());
                }
                catch (IOException e) {
                    Utils.getDefaultLogger().log(Level.SEVERE, "Error reading service provider from " + svc, e);
                }
            }
        }

        public String getBaseName() {
            return this.dir.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] readFully(File f) throws IOException {
            byte[] buf = new byte[(int)f.length()];
            DataInputStream in = new DataInputStream(new FileInputStream(f));
            try {
                in.readFully(buf);
                byte[] byArray = buf;
                return byArray;
            }
            finally {
                in.close();
            }
        }
    }
}

