/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jvnet.hk2.config.RetryableException;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.Transactor;
import org.jvnet.hk2.config.WriteableView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction {
    final LinkedList<Transactor> participants = new LinkedList();

    synchronized void addParticipant(Transactor t) {
        this.participants.addFirst(t);
    }

    public synchronized void rollback() {
        for (Transactor t : this.participants) {
            t.abort(this);
        }
    }

    public synchronized List<PropertyChangeEvent> commit() throws RetryableException, TransactionFailure {
        for (Transactor t : this.participants) {
            if (t.canCommit(this)) continue;
            throw new RetryableException();
        }
        ArrayList<PropertyChangeEvent> transactionChanges = new ArrayList<PropertyChangeEvent>();
        for (Transactor t : this.participants) {
            transactionChanges.addAll(t.commit(this));
        }
        for (Transactor t : this.participants) {
            if (!(t instanceof WriteableView)) continue;
            ((Transactions)((WriteableView)t).getMasterView().getHabitat().getComponent(Transactions.class)).addTransaction(transactionChanges);
            break;
        }
        return transactionChanges;
    }
}

