/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.component.internal.runlevel;

import com.sun.hk2.component.AbstractInhabitantImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.RunLevel;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Recorder
implements InhabitantListener {
    private final int runLevel;
    private final List<Inhabitant<?>> activations;

    Recorder(int runLevel) {
        this(new ArrayList(), runLevel);
    }

    Recorder(List<Inhabitant<?>> list, int runLevel) {
        this.activations = list;
        this.runLevel = runLevel;
    }

    public int getRunLevel() {
        return this.runLevel;
    }

    List<Inhabitant<?>> getActivations() {
        return Collections.unmodifiableList(this.activations);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.getRunLevel() + ", " + this.activations + ")";
    }

    @Override
    public synchronized boolean inhabitantChanged(InhabitantListener.EventType eventType, Inhabitant<?> inhabitant) {
        if (InhabitantListener.EventType.INHABITANT_ACTIVATED == eventType) {
            assert (inhabitant.isInstantiated());
            assert (AbstractInhabitantImpl.class.isInstance(inhabitant));
            RunLevel rl = ((AbstractInhabitantImpl)inhabitant).getAnnotation(RunLevel.class);
            if (null != rl) {
                this.activations.add(0, inhabitant);
                if (rl.value() > this.runLevel) {
                    throw new ComponentException("Invalid RunLevel dependency to: " + inhabitant);
                }
            }
        }
        return true;
    }

    public synchronized void release() {
        int pos = this.activations.size();
        while (--pos >= 0) {
            Inhabitant<?> i = this.activations.get(pos);
            try {
                i.release();
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.WARNING, "exception caught during release:", e);
            }
        }
        this.activations.clear();
    }
}

