/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.impl.ModelBuilder;

public class AnnotatedElementImpl
implements AnnotatedElement {
    public final String name;
    public final Set<AnnotationModel> annotations = Collections.synchronizedSet(new HashSet());

    public AnnotatedElementImpl(ModelBuilder tb) {
        this.name = tb.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void addAnnotation(AnnotationModel annotation) {
        this.annotations.add(annotation);
    }

    @Override
    public Collection<AnnotationModel> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    @Override
    public AnnotationModel getAnnotation(String name) {
        for (AnnotationModel am : this.annotations) {
            if (!am.getType().getName().equals(name)) continue;
            return am;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName()).append("{");
        this.print(sb);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String shortDesc() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName()).append("{");
        sb.append(this.getName());
        sb.append("}");
        return sb.toString();
    }

    protected void print(StringBuffer sb) {
        sb.append("name='").append(this.name).append("', annotations=");
        sb.append("[");
        for (AnnotationModel am : this.getAnnotations()) {
            sb.append(" ").append(am.getType().getName());
        }
        sb.append("]");
    }
}

