/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.EventPublishingInhabitant;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantListener;
import org.jvnet.hk2.component.RunLevelState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunLevelInhabitant<T, V>
extends EventPublishingInhabitant<T> {
    private final int runLevel;
    private final RunLevelState<V> state;

    RunLevelInhabitant(Inhabitant<T> delegate, int runLevel, RunLevelState<V> state) {
        this(delegate, runLevel, state, null);
    }

    RunLevelInhabitant(Inhabitant<T> delegate, int runLevel, RunLevelState<V> state, InhabitantListener listener) {
        super(delegate, listener);
        this.runLevel = runLevel;
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<T> type() {
        boolean wasInstantiated = this.isInstantiated();
        try {
            Class clazz = super.type();
            return clazz;
        }
        finally {
            if (this.isInstantiated() != wasInstantiated) {
                this.verifyState();
            }
        }
    }

    @Override
    public T get(Inhabitant onBehalfOf) {
        this.verifyState();
        return super.get(onBehalfOf);
    }

    protected void verifyState() throws ComponentException {
        if (!this.isInstantiated()) {
            Integer planned = this.state.getPlannedRunLevel();
            Integer current = this.state.getCurrentRunLevel();
            current = null == current ? 0 : current;
            if (null == planned || this.runLevel > planned || this.runLevel > current + 1) {
                throw new ComponentException("minimum expected RunLevel is: " + this.runLevel + "; planned is: " + planned + "; current is: " + current);
            }
        }
    }
}

