/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.Holder;
import com.sun.hk2.component.Inhabitants;
import com.sun.hk2.component.InjectionResolver;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.tiger_types.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InjectInjectionResolver
extends InjectionResolver<Inject> {
    private final Habitat habitat;
    private final Inhabitant<?> onBehalfOf;

    InjectInjectionResolver(Habitat habitat, Inhabitant<?> onBehalfOf) {
        super(Inject.class);
        this.habitat = habitat;
        this.onBehalfOf = onBehalfOf;
    }

    @Override
    public boolean isOptional(AnnotatedElement element, Inject annotation) {
        return annotation.optional();
    }

    @Override
    public <V> V getValue(Object component, AnnotatedElement target, Class<V> type) throws ComponentException {
        V result;
        if (type.isArray()) {
            Class<?> ct = type.getComponentType();
            Collection<?> instances = this.habitat.isContract(ct) ? this.habitat.getAllByContract(ct) : this.habitat.getAllByType(ct);
            result = type.cast(instances.toArray((Object[])Array.newInstance(ct, instances.size())));
        } else if (Types.isSubClassOf(type, Holder.class)) {
            Type t = Types.getTypeArgument(((Field)target).getGenericType(), 0);
            Class finalType = Types.erasure(t);
            if (this.habitat.isContract(finalType)) {
                return type.cast(this.habitat.getInhabitants(finalType, target.getAnnotation(Inject.class).name()));
            }
            try {
                if (finalType.cast(component) != null) {
                    return type.cast(this.onBehalfOf);
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            result = type.cast(this.habitat.getInhabitantByType(finalType));
        } else {
            if (this.habitat.isContract(type)) {
                V res = this.habitat.getComponent(type, target.getAnnotation(Inject.class).name());
                return res;
            }
            result = this.habitat.getByType(type);
        }
        return this.validate(component, result);
    }

    protected <V> V validate(Object component, V toBeInjected) {
        Inhabitants.validate(component, toBeInjected);
        return toBeInjected;
    }
}

