/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.InhabitantFileBasedParser;
import com.sun.hk2.component.InhabitantParser;
import com.sun.hk2.component.KeyValuePairParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import org.jvnet.hk2.component.ComponentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InhabitantsScanner
implements Iterable<InhabitantParser>,
Closeable {
    private int lineNumber = 0;
    private final String systemId;
    private BufferedReader r;
    private final KeyValuePairParser kvpp = new KeyValuePairParser();

    public InhabitantsScanner(InputStream in, String systemId) throws IOException {
        this.r = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        this.systemId = systemId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public Iterator<InhabitantParser> iterator() {
        return new Iterator<InhabitantParser>(){
            private String nextLine;

            @Override
            public boolean hasNext() {
                this.fetch();
                return this.nextLine != null;
            }

            private void fetch() {
                if (null == InhabitantsScanner.this.r || this.nextLine != null) {
                    return;
                }
                try {
                    while ((this.nextLine = InhabitantsScanner.this.r.readLine()) != null) {
                        InhabitantsScanner.this.lineNumber++;
                        if (this.nextLine.startsWith("#")) continue;
                        return;
                    }
                }
                catch (IOException e) {
                    throw new ComponentException("Failed to parse line " + InhabitantsScanner.this.lineNumber + " of " + InhabitantsScanner.this.systemId, e);
                }
            }

            @Override
            public InhabitantParser next() {
                this.fetch();
                InhabitantsScanner.this.kvpp.set(this.nextLine);
                this.nextLine = null;
                return new InhabitantFileBasedParser(InhabitantsScanner.this.kvpp);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void close() throws IOException {
        if (null != this.r) {
            this.r.close();
            this.r = null;
        }
    }
}

