/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hk2.component;

import com.sun.hk2.component.AbstractInhabitantImpl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.component.InhabitantListener;
import org.jvnet.hk2.component.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventPublishingInhabitant<T>
extends AbstractInhabitantImpl<T> {
    private final Inhabitant<T> delegate;
    private HashSet<InhabitantListener> listeners;

    EventPublishingInhabitant(Inhabitant<T> delegate) {
        this(delegate, null);
    }

    EventPublishingInhabitant(Inhabitant<T> delegate, InhabitantListener listener) {
        this.delegate = delegate;
        if (null != listener) {
            this.addInhabitantListener(listener);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.delegate + ")";
    }

    @Override
    public String typeName() {
        return this.delegate.typeName();
    }

    @Override
    public MultiMap<String, String> metadata() {
        return this.delegate.metadata();
    }

    @Override
    public void release() {
        boolean wasActive = this.delegate.isInstantiated();
        this.delegate.release();
        if (wasActive && !this.delegate.isInstantiated()) {
            this.notify(InhabitantListener.EventType.INHABITANT_RELEASED);
        }
    }

    @Override
    public boolean isInstantiated() {
        return this.delegate.isInstantiated();
    }

    @Override
    public Class<T> type() {
        boolean wasActive = this.delegate.isInstantiated();
        Class<T> t = this.delegate.type();
        if (!wasActive && this.delegate.isInstantiated()) {
            this.notify(InhabitantListener.EventType.INHABITANT_ACTIVATED);
        }
        return t;
    }

    @Override
    public T get(Inhabitant onBehalfOf) {
        boolean wasActive = this.delegate.isInstantiated();
        T result = this.delegate.get(onBehalfOf);
        if (!wasActive && this.delegate.isInstantiated()) {
            this.notify(InhabitantListener.EventType.INHABITANT_ACTIVATED);
        }
        return result;
    }

    public synchronized void addInhabitantListener(InhabitantListener listener) {
        if (null == listener) {
            throw new IllegalArgumentException();
        }
        if (null == this.listeners) {
            this.listeners = new HashSet();
        }
        this.listeners.add(listener);
    }

    public boolean removeInhabitantListener(InhabitantListener listener) {
        return null == this.listeners ? false : this.listeners.remove(listener);
    }

    private synchronized void notify(InhabitantListener.EventType eventType) {
        if (null != this.listeners) {
            Iterator<InhabitantListener> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                InhabitantListener listener = iter.next();
                try {
                    boolean keepListening = listener.inhabitantChanged(eventType, this);
                    if (keepListening) continue;
                    iter.remove();
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().log(Level.WARNING, "exception caught from listener:", e);
                }
            }
        }
    }
}

