/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.apt;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.InterfaceType;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class TypeHierarchyVisitor<P> {
    protected final Set<InterfaceDeclaration> visited = new HashSet<InterfaceDeclaration>();

    TypeHierarchyVisitor() {
    }

    protected void check(TypeDeclaration d, P param) {
        if (d instanceof ClassDeclaration) {
            this.checkClass((ClassDeclaration)d, param);
        } else {
            this.checkInterface((InterfaceDeclaration)d, param);
        }
    }

    protected void checkInterface(InterfaceDeclaration id, P param) {
        this.checkSuperInterfaces((TypeDeclaration)id, param);
    }

    protected void checkClass(ClassDeclaration cd, P param) {
        ClassType sc = cd.getSuperclass();
        if (sc != null) {
            this.check((TypeDeclaration)sc.getDeclaration(), param);
        }
        this.checkSuperInterfaces((TypeDeclaration)cd, param);
    }

    protected void checkSuperInterfaces(TypeDeclaration d, P param) {
        for (InterfaceType intf : d.getSuperinterfaces()) {
            InterfaceDeclaration i = intf.getDeclaration();
            if (!this.visited.add(i)) continue;
            this.check((TypeDeclaration)i, param);
        }
    }
}

