/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.apt;

import com.sun.enterprise.tools.apt.ContractFinder;
import com.sun.enterprise.tools.apt.DescriptorList;
import com.sun.enterprise.tools.apt.InhabitantMetadataProcessor;
import com.sun.enterprise.tools.apt.InhabitantsDescriptor;
import com.sun.hk2.component.CompanionSeed;
import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorListener;
import com.sun.mirror.apt.RoundCompleteEvent;
import com.sun.mirror.apt.RoundCompleteListener;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.DeclarationVisitors;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jvnet.hk2.annotations.CompanionOf;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Index;
import org.jvnet.hk2.annotations.InhabitantAnnotation;
import org.jvnet.hk2.annotations.Scoped;

public class InhabitantsGenerator
implements AnnotationProcessor,
RoundCompleteListener {
    private final AnnotationProcessorEnvironment env;
    private final boolean debug;
    private final DescriptorList list;
    private final InhabitantMetadataProcessor inhabitantMetadataProcessor = new InhabitantMetadataProcessor();

    public InhabitantsGenerator(AnnotationProcessorEnvironment env, DescriptorList list) {
        this.env = env;
        this.debug = env.getOptions().containsKey("-Adebug");
        env.addListener((AnnotationProcessorListener)this);
        this.list = list;
    }

    public void process() {
        DeclarationVisitor scanner = DeclarationVisitors.getDeclarationScanner((DeclarationVisitor)new ListClassVisitor(), (DeclarationVisitor)DeclarationVisitors.NO_OP);
        for (TypeDeclaration typeDecl : this.env.getTypeDeclarations()) {
            typeDecl.accept(scanner);
        }
    }

    public void roundComplete(RoundCompleteEvent event) {
        if (!event.getRoundState().finalRound()) {
            return;
        }
        this.list.write(this.env);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListClassVisitor
    extends SimpleDeclarationVisitor {
        private final List<String> indices = new ArrayList<String>();
        private final Set<InterfaceDeclaration> checkedInterfaces = new HashSet<InterfaceDeclaration>();

        private ListClassVisitor() {
        }

        private AnnotationMirror find(Declaration d, Class<? extends Annotation> annType) {
            for (AnnotationMirror am : d.getAnnotationMirrors()) {
                if (!am.getAnnotationType().getDeclaration().getQualifiedName().equals(annType.getName())) continue;
                return am;
            }
            return null;
        }

        public void visitClassDeclaration(ClassDeclaration d) {
            if (InhabitantsGenerator.this.debug) {
                InhabitantsGenerator.this.env.getMessager().printNotice("Visiting " + d.getQualifiedName());
            }
            InhabitantAnnotation ia = null;
            AnnotationMirror a = null;
            for (AnnotationMirror am : d.getAnnotationMirrors()) {
                ia = (InhabitantAnnotation)am.getAnnotationType().getDeclaration().getAnnotation(InhabitantAnnotation.class);
                if (ia == null) continue;
                a = am;
                break;
            }
            if (ia == null) {
                for (InhabitantsDescriptor id : ((InhabitantsGenerator)InhabitantsGenerator.this).list.descriptors.values()) {
                    id.remove(d.getQualifiedName());
                }
                return;
            }
            if (InhabitantsGenerator.this.debug) {
                InhabitantsGenerator.this.env.getMessager().printNotice("Found component annotation " + a + " on " + d.getQualifiedName());
            }
            InhabitantsDescriptor descriptor = InhabitantsGenerator.this.list.get(ia.value());
            descriptor.put(d.getQualifiedName(), this.getInhabitantDeclaration(a, d));
        }

        public String getInhabitantDeclaration(AnnotationMirror a, ClassDeclaration d) {
            String metadata;
            this.indices.clear();
            this.checkedInterfaces.clear();
            String name = this.geIndexValue(a);
            for (TypeDeclaration t : ContractFinder.find((TypeDeclaration)d)) {
                this.enforceContractLevelScope(t, d);
                this.addIndex(t.getQualifiedName(), name);
            }
            for (AnnotationMirror am : d.getAnnotationMirrors()) {
                AnnotationTypeDeclaration atd = am.getAnnotationType().getDeclaration();
                Contract c = (Contract)atd.getAnnotation(Contract.class);
                if (c != null) {
                    this.enforceContractLevelScope((TypeDeclaration)atd, d);
                    this.addIndex(atd.getQualifiedName(), this.geIndexValue(am));
                }
                for (AnnotationMirror mam : atd.getAnnotationMirrors()) {
                    AnnotationTypeDeclaration matd = mam.getAnnotationType().getDeclaration();
                    Contract mc = (Contract)matd.getAnnotation(Contract.class);
                    if (mc == null) continue;
                    this.addIndex(matd.getQualifiedName(), this.geIndexValue(mam));
                }
            }
            StringBuilder buf = new StringBuilder();
            buf.append("class").append('=').append(d.getQualifiedName());
            for (String contract : this.indices) {
                this.addMetadata(buf, "index", contract);
            }
            this.findInhabitantMetadata(d, buf);
            CompanionSeed seed = (CompanionSeed)d.getAnnotation(CompanionSeed.class);
            if (seed != null) {
                try {
                    seed.companion();
                }
                catch (MirroredTypeException e) {
                    ClassDeclaration companion = ((ClassType)e.getTypeMirror()).getDeclaration();
                    this.addMetadata(buf, "companionClassMetadata", this.quote(this.getInhabitantDeclaration(this.find((Declaration)companion, CompanionOf.class), companion)));
                }
            }
            if ((metadata = this.getStringValue(a, "metadata")) != null && metadata.length() > 0) {
                buf.append(',').append(metadata);
            }
            return buf.toString();
        }

        private void addMetadata(StringBuilder buf, String key, String value) {
            buf.append(',').append(key).append('=').append(value);
        }

        private String quote(String s) {
            StringBuilder buf = new StringBuilder();
            buf.append('\"');
            block4: for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\\': {
                        buf.append("\\\\");
                        continue block4;
                    }
                    case '\"': {
                        buf.append("\\\"");
                        continue block4;
                    }
                    default: {
                        buf.append(ch);
                    }
                }
            }
            buf.append('\"');
            return buf.toString();
        }

        private void findInhabitantMetadata(ClassDeclaration d, StringBuilder buf) {
            for (Map.Entry<String, String> e : InhabitantsGenerator.this.inhabitantMetadataProcessor.process((TypeDeclaration)d).entrySet()) {
                buf.append(',').append(e.getKey()).append('=').append(e.getValue());
            }
        }

        private String geIndexValue(AnnotationMirror a) {
            AnnotationTypeDeclaration decl = a.getAnnotationType().getDeclaration();
            for (AnnotationTypeElementDeclaration e : decl.getMethods()) {
                if (e.getAnnotation(Index.class) == null) continue;
                AnnotationValue v = (AnnotationValue)a.getElementValues().get(e);
                if (v != null) {
                    return v.getValue().toString();
                }
                return e.getDefaultValue().getValue().toString();
            }
            return null;
        }

        private String getStringValue(AnnotationMirror a, String name) {
            AnnotationTypeDeclaration decl = a.getAnnotationType().getDeclaration();
            for (AnnotationTypeElementDeclaration e : decl.getMethods()) {
                if (!e.getSimpleName().equals(name)) continue;
                AnnotationValue v = (AnnotationValue)a.getElementValues().get(e);
                if (v != null) {
                    return v.getValue().toString();
                }
                return e.getDefaultValue().getValue().toString();
            }
            return null;
        }

        private void addIndex(String primary, String secondary) {
            if (secondary == null || secondary.length() == 0) {
                this.indices.add(primary);
            } else {
                this.indices.add(primary + ':' + secondary);
            }
        }

        private void enforceContractLevelScope(TypeDeclaration ctrct, ClassDeclaration impl) {
            Scoped s = (Scoped)ctrct.getAnnotation(Scoped.class);
            if (s == null) {
                return;
            }
            try {
                s.value();
                throw new AssertionError();
            }
            catch (MirroredTypeException e) {
                TypeMirror forcedScope;
                block6: {
                    forcedScope = e.getTypeMirror();
                    s = (Scoped)impl.getAnnotation(Scoped.class);
                    if (s != null) {
                        try {
                            s.value();
                            throw new AssertionError();
                        }
                        catch (MirroredTypeException f) {
                            if (!forcedScope.equals(f.getTypeMirror())) break block6;
                            return;
                        }
                    }
                }
                InhabitantsGenerator.this.env.getMessager().printError(impl.getPosition(), "@Scoped(" + forcedScope + ") is required because of the contract " + ctrct.getQualifiedName());
                return;
            }
        }
    }
}

