/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.apt;

import com.sun.hk2.component.InhabitantsScanner;
import com.sun.hk2.component.KeyValuePairParser;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InhabitantsDescriptor
extends HashMap<String, String> {
    private boolean dirty = false;

    public InhabitantsDescriptor() {
    }

    public InhabitantsDescriptor(File f) throws IOException {
        this.load(f);
    }

    public void load(File f) throws IOException {
        InhabitantsScanner scanner = new InhabitantsScanner((InputStream)new FileInputStream(f), f.getPath());
        for (KeyValuePairParser kvpp : scanner) {
            this.put(kvpp.find("class"), kvpp.getLine());
        }
    }

    @Override
    public String put(String key, String value) {
        this.dirty = true;
        return super.put(key, value);
    }

    @Override
    public String remove(Object key) {
        this.dirty = true;
        return (String)super.remove(key);
    }

    public void write(File outputDir, AnnotationProcessorEnvironment env, String habitatName) {
        if (!this.dirty) {
            return;
        }
        try {
            File out = new File(new File(outputDir, "META-INF/inhabitants"), habitatName);
            out.getParentFile().mkdirs();
            PrintWriter w = new PrintWriter(out, "UTF-8");
            w.println("# generated on " + new Date().toGMTString());
            for (String line : this.values()) {
                w.println(line);
            }
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            env.getMessager().printError("Failed to write inhabitants file " + habitatName);
        }
    }
}

