/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.math;

import com.sun.electric.util.math.AbstractFixpPoint;
import com.sun.electric.util.math.FixpCoord;
import com.sun.electric.util.math.FixpTransform;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.HashMap;

public class Orientation
implements Serializable {
    private final short jAngle;
    private final boolean jMirrorX;
    private final boolean jMirrorY;
    private final String jString;
    private final short cAngle;
    private final boolean cTranspose;
    private final Orientation inverse;
    final double m00;
    final double m01;
    final double m10;
    final double m11;
    private final FixpTransform trans;
    private final int affineTransformType;
    private static final HashMap<Integer, Orientation> map = new HashMap();
    private static final Orientation[] map45;
    private static final int OCTANT = 7;
    private static final int XMIRROR45 = 8;
    private static final int YMIRROR45 = 16;
    public static final Orientation IDENT;
    public static final Orientation R;
    public static final Orientation RR;
    public static final Orientation RRR;
    public static final Orientation X;
    public static final Orientation XR;
    public static final Orientation XRR;
    public static final Orientation XRRR;
    public static final Orientation Y;
    public static final Orientation YR;
    public static final Orientation YRR;
    public static final Orientation YRRR;
    public static final Orientation XY;
    public static final Orientation XYR;
    public static final Orientation XYRR;
    public static final Orientation XYRRR;
    private static final byte MNONE = -1;
    private static final byte MIDENT = 0;
    private static final byte MR = 1;
    private static final byte MRR = 2;
    private static final byte MRRR = 3;
    private static final byte MY = 4;
    private static final byte MYR = 5;
    private static final byte MYRR = 6;
    private static final byte MYRRR = 7;
    private final byte manh;

    private Orientation(int jAngle, boolean jMirrorX, boolean jMirrorY, Orientation inverse) {
        double sin0;
        double cos0;
        assert (0 <= jAngle && jAngle < 3600);
        this.jAngle = (short)jAngle;
        this.jMirrorX = jMirrorX;
        this.jMirrorY = jMirrorY;
        int cAngle = jAngle;
        boolean cTranspose = false;
        if (jMirrorX) {
            if (jMirrorY) {
                cAngle = (cAngle + 1800) % 3600;
            } else {
                cAngle = (cAngle + 900) % 3600;
                cTranspose = true;
            }
        } else if (jMirrorY) {
            cAngle = (cAngle + 2700) % 3600;
            cTranspose = true;
        }
        this.cAngle = (short)cAngle;
        this.cTranspose = cTranspose;
        switch (cAngle) {
            case 0: {
                if (cTranspose) {
                    this.manh = (byte)5;
                    this.affineTransformType = 72;
                    break;
                }
                this.manh = 0;
                this.affineTransformType = 0;
                break;
            }
            case 900: {
                if (cTranspose) {
                    this.manh = (byte)6;
                    this.affineTransformType = 64;
                    break;
                }
                this.manh = 1;
                this.affineTransformType = 8;
                break;
            }
            case 1800: {
                if (cTranspose) {
                    this.manh = (byte)7;
                    this.affineTransformType = 72;
                    break;
                }
                this.manh = (byte)2;
                this.affineTransformType = 8;
                break;
            }
            case 2700: {
                if (cTranspose) {
                    this.manh = (byte)4;
                    this.affineTransformType = 64;
                    break;
                }
                this.manh = (byte)3;
                this.affineTransformType = 8;
                break;
            }
            default: {
                this.manh = (byte)-1;
                this.affineTransformType = cTranspose ? 80 : 16;
            }
        }
        if (inverse == null) {
            inverse = cTranspose || jAngle == 0 || jAngle == 1800 ? this : new Orientation(3600 - jAngle, jMirrorX, jMirrorY, this);
        }
        this.inverse = inverse;
        double[] matrix = new double[4];
        int sect = jAngle / 450;
        assert (0 <= sect && sect < 8);
        int ang = jAngle % 450;
        if (sect % 2 != 0) {
            ang = 450 - ang;
        }
        assert (0 <= ang && ang <= 450);
        if (ang == 0) {
            cos0 = 1.0;
            sin0 = 0.0;
        } else if (ang == 450) {
            cos0 = sin0 = StrictMath.sqrt(0.5);
        } else {
            double alpha = (double)ang * Math.PI / 1800.0;
            cos0 = StrictMath.cos(alpha);
            sin0 = StrictMath.sin(alpha);
        }
        double cos = 0.0;
        double sin = 0.0;
        switch (sect) {
            case 0: {
                cos = cos0;
                sin = sin0;
                break;
            }
            case 1: {
                cos = sin0;
                sin = cos0;
                break;
            }
            case 2: {
                cos = -sin0;
                sin = cos0;
                break;
            }
            case 3: {
                cos = -cos0;
                sin = sin0;
                break;
            }
            case 4: {
                cos = -cos0;
                sin = -sin0;
                break;
            }
            case 5: {
                cos = -sin0;
                sin = -cos0;
                break;
            }
            case 6: {
                cos = sin0;
                sin = -cos0;
                break;
            }
            case 7: {
                cos = cos0;
                sin = -sin0;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        matrix[0] = cos * (double)(jMirrorX ? -1 : 1);
        matrix[1] = sin * (double)(jMirrorY ? -1 : 1);
        matrix[2] = sin * (double)(jMirrorX ? 1 : -1);
        matrix[3] = cos * (double)(jMirrorY ? -1 : 1);
        AffineTransform trans = new AffineTransform(matrix);
        this.m00 = trans.getScaleX();
        this.m01 = trans.getShearX();
        this.m10 = trans.getShearY();
        this.m11 = trans.getScaleY();
        this.trans = new FixpTransform(0L, 0L, this);
        String s = "";
        if (jMirrorX) {
            s = s + 'X';
        }
        if (jMirrorY) {
            s = s + 'Y';
        }
        while (jAngle >= 900) {
            s = s + 'R';
            jAngle -= 900;
        }
        if (jAngle != 0) {
            s = s + jAngle;
        }
        this.jString = s;
    }

    private Object readResolve() {
        return Orientation.fromJava(this.jAngle, this.jMirrorX, this.jMirrorY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Orientation fromJava(int jAngle, boolean jMirrorX, boolean jMirrorY) {
        Orientation orient;
        if (jAngle % 450 == 0) {
            int index = jAngle / 450 & 7;
            if (jMirrorX) {
                index |= 8;
            }
            if (jMirrorY) {
                index |= 0x10;
            }
            return map45[index];
        }
        if ((jAngle %= 3600) < 0) {
            jAngle += 3600;
        }
        int index = 0;
        if (jMirrorX) {
            index += 3600;
        }
        if (jMirrorY) {
            index += 7200;
        }
        Integer key = new Integer(index + jAngle);
        HashMap<Integer, Orientation> hashMap = map;
        synchronized (hashMap) {
            orient = map.get(key);
            if (orient == null) {
                orient = new Orientation(jAngle, jMirrorX, jMirrorY, null);
                map.put(key, orient);
                if (orient.inverse != orient) {
                    key = new Integer(index + 3600 - jAngle);
                    map.put(key, orient.inverse);
                }
            }
        }
        return orient;
    }

    public static Orientation fromC(int cAngle, boolean cTranspose) {
        return Orientation.fromJava(cTranspose ? cAngle % 3600 + 900 : cAngle, false, cTranspose);
    }

    public static Orientation fromAngle(int angle) {
        return Orientation.fromJava(angle, false, false);
    }

    public static Orientation fromQuadrants(int numquadrants) {
        return Orientation.fromJava(900 * (numquadrants & 3), false, false);
    }

    public Orientation inverse() {
        return this.inverse;
    }

    public Orientation canonic() {
        return this.jMirrorX ? Orientation.fromC(this.cAngle, this.cTranspose) : this;
    }

    public Orientation concatenate(Orientation that) {
        boolean mirrorX = this.jMirrorX ^ that.jMirrorX;
        boolean mirrorY = this.jMirrorY ^ that.jMirrorY;
        int angle = that.jMirrorX ^ that.jMirrorY ? that.jAngle - this.jAngle : that.jAngle + this.jAngle;
        return Orientation.fromJava(angle, mirrorX, mirrorY);
    }

    public int getCAngle() {
        return this.cAngle;
    }

    public boolean isCTranspose() {
        return this.cTranspose;
    }

    public int getAngle() {
        return this.jAngle;
    }

    public boolean isXMirrored() {
        return this.jMirrorX;
    }

    public boolean isYMirrored() {
        return this.jMirrorY;
    }

    public boolean isManhattan() {
        return this.manh != -1;
    }

    public boolean isIdent() {
        return this.manh == 0;
    }

    public FixpTransform pureRotate() {
        return (FixpTransform)this.trans.clone();
    }

    public double getDeterminant() {
        return this.cTranspose ? -1.0 : 1.0;
    }

    public int getType() {
        return this.affineTransformType;
    }

    public FixpTransform rotateAbout(AbstractFixpPoint c) {
        long cX = c.getFixpX();
        long cY = c.getFixpY();
        if (cX != 0L || cY != 0L) {
            return new FixpTransform(cX - (long)Math.rint(this.m00 * (double)cX + this.m01 * (double)cY), cY - (long)Math.rint(this.m11 * (double)cY + this.m10 * (double)cX), this);
        }
        return this.pureRotate();
    }

    public FixpTransform rotateAbout(double cX, double cY) {
        return this.rotateAbout(cX, cY, -cX, -cY);
    }

    public FixpTransform rotateAbout(double aX, double aY, double bX, double bY) {
        if (bX != 0.0 || bY != 0.0) {
            aX = aX + this.m00 * bX + this.m01 * bY;
            aY = aY + this.m11 * bY + this.m10 * bX;
        }
        return new FixpTransform(FixpCoord.lambdaToFixp(aX), FixpCoord.lambdaToFixp(aY), this);
    }

    public int transformAngle(int angle) {
        angle += this.cAngle;
        if (this.cTranspose) {
            angle = 2700 - angle;
        }
        if ((angle %= 3600) < 0) {
            angle += 3600;
        }
        return angle;
    }

    public Point2D transform(long fixpX, long fixpY, Point2D ptSrc, Point2D ptDst) {
        if (ptSrc instanceof AbstractFixpPoint) {
            long dstY;
            long dstX;
            AbstractFixpPoint fpSrc = (AbstractFixpPoint)ptSrc;
            long srcX = fpSrc.getFixpX();
            long srcY = fpSrc.getFixpY();
            switch (this.manh) {
                case 0: {
                    dstX = srcX;
                    dstY = srcY;
                    break;
                }
                case 1: {
                    dstX = -srcY;
                    dstY = srcX;
                    break;
                }
                case 2: {
                    dstX = -srcX;
                    dstY = -srcY;
                    break;
                }
                case 3: {
                    dstX = srcY;
                    dstY = -srcX;
                    break;
                }
                case 4: {
                    dstX = srcX;
                    dstY = -srcY;
                    break;
                }
                case 5: {
                    dstX = -srcY;
                    dstY = -srcX;
                    break;
                }
                case 6: {
                    dstX = -srcX;
                    dstY = srcY;
                    break;
                }
                case 7: {
                    dstX = srcY;
                    dstY = srcX;
                    break;
                }
                default: {
                    dstX = (long)Math.rint((double)srcX * this.m00 + (double)srcY * this.m01);
                    dstY = (long)Math.rint((double)srcX * this.m10 + (double)srcY * this.m11);
                }
            }
            dstX += fixpX;
            dstY += fixpY;
            if (ptDst == null) {
                ptDst = fpSrc.create(dstX, dstY);
            } else if (ptDst instanceof AbstractFixpPoint) {
                ((AbstractFixpPoint)ptDst).setFixpLocation(dstX, dstY);
            } else {
                ptDst.setLocation(FixpCoord.fixpToLambda(dstX), FixpCoord.fixpToLambda(dstY));
            }
            return ptDst;
        }
        double srcX = ptSrc.getX();
        double srcY = ptSrc.getY();
        double dstX = FixpCoord.fixpToLambda(fixpX) + this.transformX(srcX, srcY);
        double dstY = FixpCoord.fixpToLambda(fixpY) + this.transformY(srcX, srcY);
        if (ptDst == null) {
            ptDst = ptSrc instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        ptDst.setLocation(dstX, dstY);
        return ptDst;
    }

    public void transform(long fixpX, long fixpY, AbstractFixpPoint[] ptSrc, int srcOff, AbstractFixpPoint[] ptDst, int dstOff, int numPts) {
        switch (this.manh) {
            case 0: {
                while (--numPts >= 0) {
                    AbstractFixpPoint dst;
                    AbstractFixpPoint src = ptSrc[srcOff++];
                    long dstX = fixpX + src.getFixpX();
                    long dstY = fixpY + src.getFixpY();
                    if ((dst = ptDst[dstOff++]) == null) {
                        ptDst[dstOff - 1] = src.create(dstX, dstY);
                        continue;
                    }
                    dst.setFixpLocation(dstX, dstY);
                }
                break;
            }
            case 1: {
                while (--numPts >= 0) {
                    AbstractFixpPoint dst;
                    AbstractFixpPoint src = ptSrc[srcOff++];
                    long dstX = fixpX - src.getFixpY();
                    long dstY = fixpY + src.getFixpX();
                    if ((dst = ptDst[dstOff++]) == null) {
                        ptDst[dstOff - 1] = src.create(dstX, dstY);
                        continue;
                    }
                    dst.setFixpLocation(dstX, dstY);
                }
                break;
            }
            case 2: {
                while (--numPts >= 0) {
                    AbstractFixpPoint dst;
                    AbstractFixpPoint src = ptSrc[srcOff++];
                    long dstX = fixpX - src.getFixpX();
                    long dstY = fixpY - src.getFixpY();
                    if ((dst = ptDst[dstOff++]) == null) {
                        ptDst[dstOff - 1] = src.create(dstX, dstY);
                        continue;
                    }
                    dst.setFixpLocation(dstX, dstY);
                }
                break;
            }
            case 3: {
                while (--numPts >= 0) {
                    AbstractFixpPoint dst;
                    AbstractFixpPoint src = ptSrc[srcOff++];
                    long dstX = fixpX + src.getFixpY();
                    long dstY = fixpY - src.getFixpX();
                    if ((dst = ptDst[dstOff++]) == null) {
                        ptDst[dstOff - 1] = src.create(dstX, dstY);
                        continue;
                    }
                    dst.setFixpLocation(dstX, dstY);
                }
                break;
            }
            case 4: {
                while (--numPts >= 0) {
                    AbstractFixpPoint dst;
                    AbstractFixpPoint src = ptSrc[srcOff++];
                    long dstX = fixpX + src.getFixpX();
                    long dstY = fixpY - src.getFixpY();
                    if ((dst = ptDst[dstOff++]) == null) {
                        ptDst[dstOff - 1] = src.create(dstX, dstY);
                        continue;
                    }
                    dst.setFixpLocation(dstX, dstY);
                }
                break;
            }
            case 5: {
                while (--numPts >= 0) {
                    AbstractFixpPoint dst;
                    AbstractFixpPoint src = ptSrc[srcOff++];
                    long dstX = fixpX - src.getFixpY();
                    long dstY = fixpY - src.getFixpX();
                    if ((dst = ptDst[dstOff++]) == null) {
                        ptDst[dstOff - 1] = src.create(dstX, dstY);
                        continue;
                    }
                    dst.setFixpLocation(dstX, dstY);
                }
                break;
            }
            case 6: {
                while (--numPts >= 0) {
                    AbstractFixpPoint dst;
                    AbstractFixpPoint src = ptSrc[srcOff++];
                    long dstX = fixpX - src.getFixpX();
                    long dstY = fixpY + src.getFixpY();
                    if ((dst = ptDst[dstOff++]) == null) {
                        ptDst[dstOff - 1] = src.create(dstX, dstY);
                        continue;
                    }
                    dst.setFixpLocation(dstX, dstY);
                }
                break;
            }
            case 7: {
                while (--numPts >= 0) {
                    AbstractFixpPoint dst;
                    AbstractFixpPoint src = ptSrc[srcOff++];
                    long dstX = fixpX + src.getFixpY();
                    long dstY = fixpY + src.getFixpX();
                    if ((dst = ptDst[dstOff++]) == null) {
                        ptDst[dstOff - 1] = src.create(dstX, dstY);
                        continue;
                    }
                    dst.setFixpLocation(dstX, dstY);
                }
                break;
            }
            default: {
                while (--numPts >= 0) {
                    AbstractFixpPoint dst;
                    AbstractFixpPoint src = ptSrc[srcOff++];
                    long x = src.getFixpX();
                    long y = src.getFixpY();
                    long dstX = fixpX + (long)Math.rint((double)x * this.m00 + (double)y * this.m01);
                    long dstY = fixpY + (long)Math.rint((double)x * this.m10 + (double)y * this.m11);
                    if ((dst = ptDst[dstOff++]) == null) {
                        ptDst[dstOff - 1] = src.create(dstX, dstY);
                        continue;
                    }
                    dst.setFixpLocation(dstX, dstY);
                }
                break block0;
            }
        }
    }

    public void transformPoints(int numPoints, long[] srcCoords, long[] dstCoords) {
        if (srcCoords == dstCoords) {
            this.transformPoints(numPoints, srcCoords);
            return;
        }
        switch (this.manh) {
            case 0: {
                System.arraycopy(srcCoords, 0, dstCoords, 0, numPoints * 2);
                return;
            }
            case 1: {
                for (int i = 0; i < numPoints; ++i) {
                    long x = srcCoords[i * 2 + 0];
                    long y = srcCoords[i * 2 + 1];
                    dstCoords[i * 2 + 0] = -y;
                    dstCoords[i * 2 + 1] = x;
                }
                return;
            }
            case 2: {
                for (int i = 0; i < numPoints; ++i) {
                    dstCoords[i * 2 + 0] = -srcCoords[i * 2 + 0];
                    dstCoords[i * 2 + 1] = -srcCoords[i * 2 + 1];
                }
                return;
            }
            case 3: {
                for (int i = 0; i < numPoints; ++i) {
                    long y;
                    long x = srcCoords[i * 2 + 0];
                    dstCoords[i * 2 + 0] = y = srcCoords[i * 2 + 1];
                    dstCoords[i * 2 + 1] = -x;
                }
                return;
            }
            case 4: {
                for (int i = 0; i < numPoints; ++i) {
                    dstCoords[i * 2 + 0] = srcCoords[i * 2 + 0];
                    dstCoords[i * 2 + 1] = -srcCoords[i * 2 + 1];
                }
                return;
            }
            case 5: {
                for (int i = 0; i < numPoints; ++i) {
                    long x = srcCoords[i * 2 + 0];
                    long y = srcCoords[i * 2 + 1];
                    dstCoords[i * 2 + 0] = -y;
                    dstCoords[i * 2 + 1] = -x;
                }
                return;
            }
            case 6: {
                for (int i = 0; i < numPoints; ++i) {
                    dstCoords[i * 2 + 0] = -srcCoords[i * 2 + 0];
                    dstCoords[i * 2 + 1] = srcCoords[i * 2 + 1];
                }
                return;
            }
            case 7: {
                for (int i = 0; i < numPoints; ++i) {
                    long y;
                    long x = srcCoords[i * 2 + 0];
                    dstCoords[i * 2 + 0] = y = srcCoords[i * 2 + 1];
                    dstCoords[i * 2 + 1] = x;
                }
                return;
            }
        }
        for (int i = 0; i < numPoints; ++i) {
            long x = srcCoords[i * 2 + 0];
            long y = srcCoords[i * 2 + 1];
            dstCoords[i * 2 + 0] = (long)Math.rint((double)x * this.m00 + (double)y * this.m01);
            dstCoords[i * 2 + 1] = (long)Math.rint((double)x * this.m10 + (double)y * this.m11);
        }
    }

    public void transformPoints(int numPoints, int[] srcCoords, int[] dstCoords) {
        if (srcCoords == dstCoords) {
            this.transformPoints(numPoints, srcCoords);
            return;
        }
        switch (this.manh) {
            case 0: {
                System.arraycopy(srcCoords, 0, dstCoords, 0, numPoints * 2);
                return;
            }
            case 1: {
                for (int i = 0; i < numPoints; ++i) {
                    int x = srcCoords[i * 2 + 0];
                    int y = srcCoords[i * 2 + 1];
                    dstCoords[i * 2 + 0] = -y;
                    dstCoords[i * 2 + 1] = x;
                }
                return;
            }
            case 2: {
                for (int i = 0; i < numPoints; ++i) {
                    dstCoords[i * 2 + 0] = -srcCoords[i * 2 + 0];
                    dstCoords[i * 2 + 1] = -srcCoords[i * 2 + 1];
                }
                return;
            }
            case 3: {
                for (int i = 0; i < numPoints; ++i) {
                    int y;
                    int x = srcCoords[i * 2 + 0];
                    dstCoords[i * 2 + 0] = y = srcCoords[i * 2 + 1];
                    dstCoords[i * 2 + 1] = -x;
                }
                return;
            }
            case 4: {
                for (int i = 0; i < numPoints; ++i) {
                    dstCoords[i * 2 + 0] = srcCoords[i * 2 + 0];
                    dstCoords[i * 2 + 1] = -srcCoords[i * 2 + 1];
                }
                return;
            }
            case 5: {
                for (int i = 0; i < numPoints; ++i) {
                    int x = srcCoords[i * 2 + 0];
                    int y = srcCoords[i * 2 + 1];
                    dstCoords[i * 2 + 0] = -y;
                    dstCoords[i * 2 + 1] = -x;
                }
                return;
            }
            case 6: {
                for (int i = 0; i < numPoints; ++i) {
                    dstCoords[i * 2 + 0] = -srcCoords[i * 2 + 0];
                    dstCoords[i * 2 + 1] = srcCoords[i * 2 + 1];
                }
                return;
            }
            case 7: {
                for (int i = 0; i < numPoints; ++i) {
                    int y;
                    int x = srcCoords[i * 2 + 0];
                    dstCoords[i * 2 + 0] = y = srcCoords[i * 2 + 1];
                    dstCoords[i * 2 + 1] = x;
                }
                return;
            }
        }
        for (int i = 0; i < numPoints; ++i) {
            int x = srcCoords[i * 2 + 0];
            int y = srcCoords[i * 2 + 1];
            dstCoords[i * 2 + 0] = (int)Math.rint((double)x * this.m00 + (double)y * this.m01);
            dstCoords[i * 2 + 1] = (int)Math.rint((double)x * this.m10 + (double)y * this.m11);
        }
    }

    public void transformPoints(int numPoints, long[] coords) {
        switch (this.manh) {
            case 0: {
                return;
            }
            case 1: {
                for (int i = 0; i < numPoints; ++i) {
                    long x = coords[i * 2 + 0];
                    long y = coords[i * 2 + 1];
                    coords[i * 2 + 0] = -y;
                    coords[i * 2 + 1] = x;
                }
                return;
            }
            case 2: {
                for (int i = 0; i < numPoints; ++i) {
                    coords[i * 2 + 0] = -coords[i * 2 + 0];
                    coords[i * 2 + 1] = -coords[i * 2 + 1];
                }
                return;
            }
            case 3: {
                for (int i = 0; i < numPoints; ++i) {
                    long y;
                    long x = coords[i * 2 + 0];
                    coords[i * 2 + 0] = y = coords[i * 2 + 1];
                    coords[i * 2 + 1] = -x;
                }
                return;
            }
            case 4: {
                for (int i = 0; i < numPoints; ++i) {
                    coords[i * 2 + 1] = -coords[i * 2 + 1];
                }
                return;
            }
            case 5: {
                for (int i = 0; i < numPoints; ++i) {
                    long x = coords[i * 2 + 0];
                    long y = coords[i * 2 + 1];
                    coords[i * 2 + 0] = -y;
                    coords[i * 2 + 1] = -x;
                }
                return;
            }
            case 6: {
                for (int i = 0; i < numPoints; ++i) {
                    coords[i * 2 + 0] = -coords[i * 2 + 0];
                }
                return;
            }
            case 7: {
                for (int i = 0; i < numPoints; ++i) {
                    long y;
                    long x = coords[i * 2 + 0];
                    coords[i * 2 + 0] = y = coords[i * 2 + 1];
                    coords[i * 2 + 1] = x;
                }
                return;
            }
        }
        for (int i = 0; i < numPoints; ++i) {
            long x = coords[i * 2 + 0];
            long y = coords[i * 2 + 1];
            coords[i * 2 + 0] = (long)Math.rint((double)x * this.m00 + (double)y * this.m01);
            coords[i * 2 + 1] = (long)Math.rint((double)x * this.m10 + (double)y * this.m11);
        }
    }

    public void transformPoints(int numPoints, int[] coords) {
        switch (this.manh) {
            case 0: {
                return;
            }
            case 1: {
                for (int i = 0; i < numPoints; ++i) {
                    int x = coords[i * 2 + 0];
                    int y = coords[i * 2 + 1];
                    coords[i * 2 + 0] = -y;
                    coords[i * 2 + 1] = x;
                }
                return;
            }
            case 2: {
                for (int i = 0; i < numPoints; ++i) {
                    coords[i * 2 + 0] = -coords[i * 2 + 0];
                    coords[i * 2 + 1] = -coords[i * 2 + 1];
                }
                return;
            }
            case 3: {
                for (int i = 0; i < numPoints; ++i) {
                    int y;
                    int x = coords[i * 2 + 0];
                    coords[i * 2 + 0] = y = coords[i * 2 + 1];
                    coords[i * 2 + 1] = -x;
                }
                return;
            }
            case 4: {
                for (int i = 0; i < numPoints; ++i) {
                    coords[i * 2 + 1] = -coords[i * 2 + 1];
                }
                return;
            }
            case 5: {
                for (int i = 0; i < numPoints; ++i) {
                    int x = coords[i * 2 + 0];
                    int y = coords[i * 2 + 1];
                    coords[i * 2 + 0] = -y;
                    coords[i * 2 + 1] = -x;
                }
                return;
            }
            case 6: {
                for (int i = 0; i < numPoints; ++i) {
                    coords[i * 2 + 0] = -coords[i * 2 + 0];
                }
                return;
            }
            case 7: {
                for (int i = 0; i < numPoints; ++i) {
                    int y;
                    int x = coords[i * 2 + 0];
                    coords[i * 2 + 0] = y = coords[i * 2 + 1];
                    coords[i * 2 + 1] = x;
                }
                return;
            }
        }
        for (int i = 0; i < numPoints; ++i) {
            int x = coords[i * 2 + 0];
            int y = coords[i * 2 + 1];
            coords[i * 2 + 0] = (int)Math.rint((double)x * this.m00 + (double)y * this.m01);
            coords[i * 2 + 1] = (int)Math.rint((double)x * this.m10 + (double)y * this.m11);
        }
    }

    public long transformX(long x, long y) {
        switch (this.manh) {
            case 0: {
                return x;
            }
            case 1: {
                return -y;
            }
            case 2: {
                return -x;
            }
            case 3: {
                return y;
            }
            case 4: {
                return x;
            }
            case 5: {
                return -y;
            }
            case 6: {
                return -x;
            }
            case 7: {
                return y;
            }
        }
        return (long)Math.rint((double)x * this.m00 + (double)y * this.m01);
    }

    public long transformY(long x, long y) {
        switch (this.manh) {
            case 0: {
                return y;
            }
            case 1: {
                return x;
            }
            case 2: {
                return -y;
            }
            case 3: {
                return -x;
            }
            case 4: {
                return -y;
            }
            case 5: {
                return -x;
            }
            case 6: {
                return y;
            }
            case 7: {
                return x;
            }
        }
        return (long)Math.rint((double)x * this.m10 + (double)y * this.m11);
    }

    public double transformX(double x, double y) {
        switch (this.manh) {
            case 0: {
                return x;
            }
            case 1: {
                return -y;
            }
            case 2: {
                return -x;
            }
            case 3: {
                return y;
            }
            case 4: {
                return x;
            }
            case 5: {
                return -y;
            }
            case 6: {
                return -x;
            }
            case 7: {
                return y;
            }
        }
        return x * this.m00 + y * this.m01;
    }

    public double transformY(double x, double y) {
        switch (this.manh) {
            case 0: {
                return y;
            }
            case 1: {
                return x;
            }
            case 2: {
                return -y;
            }
            case 3: {
                return -x;
            }
            case 4: {
                return -y;
            }
            case 5: {
                return -x;
            }
            case 6: {
                return y;
            }
            case 7: {
                return x;
            }
        }
        return x * this.m10 + y * this.m11;
    }

    public Point2D transformPoint(Point2D coord) {
        switch (this.manh) {
            case 0: {
                return coord;
            }
            case 1: {
                return new Point2D.Double(-coord.getY(), coord.getX());
            }
            case 2: {
                return new Point2D.Double(-coord.getX(), -coord.getY());
            }
            case 3: {
                return new Point2D.Double(coord.getY(), -coord.getX());
            }
            case 4: {
                return new Point2D.Double(coord.getX(), -coord.getY());
            }
            case 5: {
                return new Point2D.Double(-coord.getY(), -coord.getX());
            }
            case 6: {
                return new Point2D.Double(-coord.getX(), coord.getY());
            }
            case 7: {
                return new Point2D.Double(coord.getY(), coord.getX());
            }
        }
        Point2D.Double result = new Point2D.Double();
        this.trans.transform(coord, result);
        return result;
    }

    public void rectangleBounds(Rectangle2D src, Point2D c, Rectangle2D dst) {
        this.rectangleBounds(src.getMinX(), src.getMinY(), src.getMaxX(), src.getMaxY(), c.getX(), c.getY(), dst);
    }

    public void rectangleBounds(double xl, double yl, double xh, double yh, double cx, double cy, Rectangle2D dst) {
        double dx = xh - xl;
        double dy = yh - yl;
        switch (this.manh) {
            case 0: {
                dst.setFrame(cx + xl, cy + yl, dx, dy);
                return;
            }
            case 1: {
                dst.setFrame(cx - yh, cy + xl, dy, dx);
                return;
            }
            case 2: {
                dst.setFrame(cx - xh, cy - yh, dx, dy);
                return;
            }
            case 3: {
                dst.setFrame(cx + yl, cy - xh, dy, dx);
                return;
            }
            case 4: {
                dst.setFrame(cx + xl, cy - yh, dx, dy);
                return;
            }
            case 5: {
                dst.setFrame(cx - yh, cy - xh, dy, dx);
                return;
            }
            case 6: {
                dst.setFrame(cx - xh, cy + yl, dx, dy);
                return;
            }
            case 7: {
                dst.setFrame(cx + yl, cy + xl, dy, dx);
                return;
            }
        }
        assert (this.manh == -1);
        dst.setFrame(cx + this.m00 * (this.m00 >= 0.0 ? xl : xh) + this.m01 * (this.m01 >= 0.0 ? yl : yh), cy + this.m10 * (this.m10 >= 0.0 ? xl : xh) + this.m11 * (this.m11 >= 0.0 ? yl : yh), Math.abs(this.m00) * dx + Math.abs(this.m01) * dy, Math.abs(this.m10) * dx + Math.abs(this.m11) * dy);
    }

    public void rectangleBounds(long[] coords) {
        long xl = coords[0];
        long yl = coords[1];
        long xh = coords[2];
        long yh = coords[3];
        switch (this.manh) {
            case 0: {
                return;
            }
            case 1: {
                coords[0] = -yh;
                coords[1] = xl;
                coords[2] = -yl;
                coords[3] = xh;
                return;
            }
            case 2: {
                coords[0] = -xh;
                coords[1] = -yh;
                coords[2] = -xl;
                coords[3] = -yl;
                return;
            }
            case 3: {
                coords[0] = yl;
                coords[1] = -xh;
                coords[2] = yh;
                coords[3] = -xl;
                return;
            }
            case 4: {
                coords[1] = -yh;
                coords[3] = -yl;
                return;
            }
            case 5: {
                coords[0] = -yh;
                coords[1] = -xh;
                coords[2] = -yl;
                coords[3] = -xl;
                return;
            }
            case 6: {
                coords[0] = -xh;
                coords[2] = -xl;
                return;
            }
            case 7: {
                coords[0] = yl;
                coords[1] = xl;
                coords[2] = yh;
                coords[3] = xh;
                return;
            }
        }
        assert (this.manh == -1);
        coords[0] = (long)Math.rint(this.m00 * (double)(this.m00 >= 0.0 ? xl : xh) + this.m01 * (double)(this.m01 >= 0.0 ? yl : yh));
        coords[1] = (long)Math.rint(this.m10 * (double)(this.m10 >= 0.0 ? xl : xh) + this.m11 * (double)(this.m11 >= 0.0 ? yl : yh));
        coords[2] = (long)Math.rint(this.m00 * (double)(this.m00 >= 0.0 ? xh : xl) + this.m01 * (double)(this.m01 >= 0.0 ? yh : yl));
        coords[3] = (long)Math.rint(this.m10 * (double)(this.m10 >= 0.0 ? xh : xl) + this.m11 * (double)(this.m11 >= 0.0 ? yh : yl));
    }

    public void rectangleBounds(int[] coords) {
        int xl = coords[0];
        int yl = coords[1];
        int xh = coords[2];
        int yh = coords[3];
        switch (this.manh) {
            case 0: {
                return;
            }
            case 1: {
                coords[0] = -yh;
                coords[1] = xl;
                coords[2] = -yl;
                coords[3] = xh;
                return;
            }
            case 2: {
                coords[0] = -xh;
                coords[1] = -yh;
                coords[2] = -xl;
                coords[3] = -yl;
                return;
            }
            case 3: {
                coords[0] = yl;
                coords[1] = -xh;
                coords[2] = yh;
                coords[3] = -xl;
                return;
            }
            case 4: {
                coords[1] = -yh;
                coords[3] = -yl;
                return;
            }
            case 5: {
                coords[0] = -yh;
                coords[1] = -xh;
                coords[2] = -yl;
                coords[3] = -xl;
                return;
            }
            case 6: {
                coords[0] = -xh;
                coords[2] = -xl;
                return;
            }
            case 7: {
                coords[0] = yl;
                coords[1] = xl;
                coords[2] = yh;
                coords[3] = xh;
                return;
            }
        }
        assert (this.manh == -1);
        coords[0] = (int)Math.rint(this.m00 * (double)(this.m00 >= 0.0 ? xl : xh) + this.m01 * (double)(this.m01 >= 0.0 ? yl : yh));
        coords[1] = (int)Math.rint(this.m10 * (double)(this.m10 >= 0.0 ? xl : xh) + this.m11 * (double)(this.m11 >= 0.0 ? yl : yh));
        coords[2] = (int)Math.rint(this.m00 * (double)(this.m00 >= 0.0 ? xh : xl) + this.m01 * (double)(this.m01 >= 0.0 ? yh : yl));
        coords[3] = (int)Math.rint(this.m10 * (double)(this.m10 >= 0.0 ? xh : xl) + this.m11 * (double)(this.m11 >= 0.0 ? yh : yl));
    }

    public String toJelibString() {
        return this.jString;
    }

    public String toString() {
        return this.toJelibString();
    }

    static {
        Orientation[] m = new Orientation[32];
        for (int i = 0; i < m.length; ++i) {
            Orientation orient;
            int octant = i & 7;
            boolean jMirrorX = (i & 8) != 0;
            boolean jMirrorY = (i & 0x10) != 0;
            m[i] = orient = new Orientation(octant * 450, jMirrorX, jMirrorY, null);
            if (orient.inverse == orient) continue;
            m[i + 8 - octant * 2] = orient.inverse;
        }
        map45 = m;
        IDENT = Orientation.fromJava(0, false, false);
        R = Orientation.fromJava(900, false, false);
        RR = Orientation.fromJava(1800, false, false);
        RRR = Orientation.fromJava(2700, false, false);
        X = Orientation.fromJava(0, true, false);
        XR = Orientation.fromJava(900, true, false);
        XRR = Orientation.fromJava(1800, true, false);
        XRRR = Orientation.fromJava(2700, true, false);
        Y = Orientation.fromJava(0, false, true);
        YR = Orientation.fromJava(900, false, true);
        YRR = Orientation.fromJava(1800, false, true);
        YRRR = Orientation.fromJava(2700, false, true);
        XY = Orientation.fromJava(0, true, true);
        XYR = Orientation.fromJava(900, true, true);
        XYRR = Orientation.fromJava(1800, true, true);
        XYRRR = Orientation.fromJava(2700, true, true);
    }
}

