/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ImmutableList<T>
implements Iterable<T> {
    private ImmutableList<T> next;
    private T item;

    private ImmutableList(ImmutableList<T> next, T item) {
        this.next = next;
        this.item = item;
    }

    public static <T> ImmutableList<T> add(ImmutableList<T> list, T item) {
        return new ImmutableList<T>(list, item);
    }

    public static <T> ImmutableList<T> remove(ImmutableList<T> list, T item) {
        if (list == null) {
            return null;
        }
        return super.remove(item);
    }

    private ImmutableList<T> remove(T target) {
        if (this.item == target) {
            return this.next;
        }
        ImmutableList<T> new_next = ImmutableList.remove(this.next, target);
        if (new_next == this.next) {
            return this;
        }
        return new ImmutableList<T>(new_next, this.item);
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableListIterator(this);
    }

    public static class ImmutableListIterator<T>
    implements Iterator<T> {
        private ImmutableList<T> list;

        public ImmutableListIterator(ImmutableList<T> list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.list != null;
        }

        @Override
        public T next() {
            if (this.list != null) {
                Object obj = ((ImmutableList)this.list).item;
                this.list = ((ImmutableList)this.list).next;
                return (T)obj;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

