/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util;

import com.sun.electric.util.collections.ImmutableList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CollectionFactory {
    private CollectionFactory() {
    }

    public static <T> ArrayList<T> createArrayList() {
        return new ArrayList();
    }

    public static <T> HashSet<T> createHashSet() {
        return new HashSet();
    }

    public static <T> List<T> createConcurrentList() {
        return Collections.synchronizedList(CollectionFactory.<T>createArrayList());
    }

    public static <T> ConcurrentLinkedQueue<T> createConcurrentLinkedQueue() {
        return new ConcurrentLinkedQueue();
    }

    public static <T, V> ConcurrentHashMap<T, V> createConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <T> Set<T> createConcurrentHashSet() {
        return Collections.synchronizedSet(CollectionFactory.<T>createHashSet());
    }

    public static <T> Set<T> copySetToConcurrent(Set<T> source) {
        Set<T> result = CollectionFactory.createConcurrentHashSet();
        CollectionFactory.doCopyCollection(source, result);
        return result;
    }

    public static <T> LinkedList<T> createLinkedList() {
        return new LinkedList();
    }

    private static <T> void doCopyCollection(Collection<T> source, Collection<T> dest) {
        Iterator<T> it = source.iterator();
        while (it.hasNext()) {
            dest.add(it.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T threadSafeListGet(int index, List<T> list) {
        List<T> list2 = list;
        synchronized (list2) {
            return list.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T threadSafeListRemove(int index, List<T> list) {
        List<T> list2 = list;
        synchronized (list2) {
            return list.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void threadSafeListAdd(T item, List<T> list) {
        List<T> list2 = list;
        synchronized (list2) {
            list.add(item);
        }
    }

    public static <T, K> HashMap<T, K> createHashMap() {
        return new HashMap();
    }

    public static <T> Set<T> copySet(Set<T> source) {
        HashSet<T> result = CollectionFactory.createHashSet();
        CollectionFactory.doCopyCollection(source, result);
        return result;
    }

    public static <T> Set<T> copyListToSet(List<T> source) {
        HashSet<T> result = CollectionFactory.createHashSet();
        CollectionFactory.doCopyCollection(source, result);
        return result;
    }

    public static <T> List<T> copySetToList(Set<T> source) {
        ArrayList<T> result = CollectionFactory.createArrayList();
        CollectionFactory.doCopyCollection(source, result);
        return result;
    }

    public static <T> ImmutableList<T> copyListToImmutableList(List<T> source) {
        ImmutableList<T> immutableList = null;
        for (T element : source) {
            immutableList = ImmutableList.add(immutableList, element);
        }
        return immutableList;
    }

    public static <T> T[] arrayMerge(T[] ... arrays) {
        Class<?> objectClass = null;
        int count = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            count += array.length;
            if (array.length <= 0) continue;
            objectClass = array[0].getClass();
        }
        if (objectClass == null) {
            return null;
        }
        ArrayList<T> mergedList = new ArrayList<T>();
        for (T[] array : arrays) {
            if (array == null) continue;
            mergedList.addAll(Arrays.asList(array));
        }
        return mergedList.toArray((Object[])Array.newInstance(objectClass, count));
    }
}

