/*
 * Decompiled with CFR 0.152.
 */
package com.sumitanantwar.android.xml_font_views;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.support.v7.widget.AppCompatEditText;
import android.util.AttributeSet;
import android.util.Log;
import com.sumitanantwar.android.xml_font_views.FontManager;
import com.sumitanantwar.android.xml_font_views.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.InvalidParameterException;

public class XMLFontIconEditText
extends AppCompatEditText {
    private static final String LOG_TAG = "XMLFontIconEditText";
    private final Context context;
    private String fontFile;
    private String iconCharacter = "";
    private String iconFontFile;
    private int iconPosition;
    private Paint iconPaint = new Paint();
    public static final int ICON_POSITION_LEFT = 0;
    public static final int ICON_POSITION_RIGHT = 1;
    private static final float ICON_X_OFFSET = 25.0f;

    public XMLFontIconEditText(Context context) {
        this(context, null);
    }

    public XMLFontIconEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.initWithAttributes(attrs, 0);
    }

    public XMLFontIconEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.initWithAttributes(attrs, defStyleAttr);
    }

    private void initWithAttributes(AttributeSet attrs, int defStyleAttr) {
        int iconSize = 25;
        this.iconPaint.setTextAlign(Paint.Align.CENTER);
        this.iconPaint.setColor(-16777216);
        this.iconPaint.setTextSize((float)iconSize);
        TypedArray attributes = this.context.getTheme().obtainStyledAttributes(attrs, R.styleable.XMLFontIconEditText, defStyleAttr, 0);
        String fontFilename = attributes.getString(R.styleable.XMLFontIconEditText_font_file);
        if (fontFilename != null) {
            this.setFontFile(fontFilename);
        }
        String iconCharacter = attributes.getString(R.styleable.XMLFontIconEditText_icon_character);
        this.setIconCharacter(iconCharacter);
        String iconFontFilename = attributes.getString(R.styleable.XMLFontIconEditText_icon_font_file);
        if (iconFontFilename != null) {
            this.setIconFontFile(iconFontFilename);
        }
        iconSize = attributes.getDimensionPixelSize(R.styleable.XMLFontIconEditText_icon_size, iconSize);
        this.setIconSize(iconSize);
        ColorStateList iconColor = attributes.getColorStateList(R.styleable.XMLFontIconEditText_icon_color);
        if (iconColor != null) {
            this.setIconColor(iconColor);
        }
        this.iconPosition = attributes.getInt(R.styleable.XMLFontIconEditText_icon_position, this.iconPosition);
        this.setIconPosition(this.iconPosition);
        attributes.recycle();
    }

    public String getFontFile() {
        return this.fontFile;
    }

    public void setFontFile(String filename) {
        this.fontFile = filename;
        this.setTypeface(FontManager.getTypeFaceForFont(this.context, filename));
    }

    public String getIconCharacter() {
        return this.iconCharacter;
    }

    public void setIconCharacter(String iconCharacter) {
        this.iconCharacter = iconCharacter;
        this.invalidate();
    }

    public String getIconFontFile() {
        return this.iconFontFile;
    }

    public void setIconFontFile(String iconFontFile) {
        this.iconFontFile = iconFontFile;
        this.iconPaint.setTypeface(FontManager.getTypeFaceForFont(this.context, iconFontFile));
        this.invalidate();
    }

    public void setIconSize(float iconSize) {
        this.iconPaint.setTextSize(iconSize);
        this.invalidate();
    }

    public void setIconColor(@NonNull ColorStateList color) {
        this.iconPaint.setColor(color.getDefaultColor());
        this.invalidate();
    }

    public void setIconPosition(int position) {
        int iconPadding = (int)((double)this.iconPaint.getTextSize() * 1.5);
        switch (position) {
            case 0: {
                this.setPadding(this.getPaddingLeft() + iconPadding, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
                break;
            }
            case 1: {
                this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight() + iconPadding, this.getPaddingBottom());
                break;
            }
            default: {
                throw new InvalidParameterException("Only Left and Right positions are supported");
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float iconSize = this.iconPaint.getTextSize();
        float iconOffset = iconSize * 0.75f;
        float cX = this.iconPosition == 0 ? iconOffset : (float)this.getMeasuredWidth() - iconOffset;
        float cY = this.getMeasuredHeight() / 2 + this.getScrollY();
        canvas.drawText(this.iconCharacter, cX, cY + this.iconPaint.getTextSize() * 0.35f, this.iconPaint);
        Log.i((String)LOG_TAG, (String)"onDraw: Drawing Icon Character");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IconPosition {
    }
}

