/*
 * Decompiled with CFR 0.152.
 */
package com.sumitanantwar.android.xml_font_views;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.sumitanantwar.android.xml_font_views.R;
import com.sumitanantwar.android.xml_font_views.XMLFontTextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class XMLFontIconButton
extends FrameLayout {
    private final Context context;
    private CharSequence text;
    private String fontFile;
    private CharSequence iconCharacter;
    private String iconFontFile;
    private XMLFontTextView topIconView;
    private XMLFontTextView leftIconView;
    private XMLFontTextView rightIconView;
    private XMLFontTextView bottomIconView;
    private XMLFontTextView mainTextView;
    public static final int ICON_POSITION_LEFT = 0;
    public static final int ICON_POSITION_RIGHT = 1;
    public static final int ICON_POSITION_TOP = 2;
    public static final int ICON_POSITION_BOTTOM = 3;

    public XMLFontIconButton(Context context) {
        this(context, null);
    }

    public XMLFontIconButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public XMLFontIconButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.initWithAttributes(attrs, defStyleAttr);
    }

    private void initWithAttributes(AttributeSet attrs, int defStyleAttr) {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        View view = XMLFontIconButton.inflate((Context)this.context, (int)R.layout.layout_xml_font_icon_button, null);
        this.leftIconView = (XMLFontTextView)view.findViewById(R.id.FIB_LeftIcon);
        this.rightIconView = (XMLFontTextView)view.findViewById(R.id.FIB_RightIcon);
        this.topIconView = (XMLFontTextView)view.findViewById(R.id.FIB_TopIcon);
        this.bottomIconView = (XMLFontTextView)view.findViewById(R.id.FIB_BottomIcon);
        this.mainTextView = (XMLFontTextView)view.findViewById(R.id.FIB_MainText);
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView(view);
        int textSize = 15;
        int iconSize = 25;
        int iconPosition = 0;
        int iconPadding = 10;
        TypedArray attributes = this.context.getTheme().obtainStyledAttributes(attrs, R.styleable.XMLFontIconButton, defStyleAttr, 0);
        String mainText = attributes.getString(R.styleable.XMLFontIconButton_text);
        this.setText(mainText);
        String fontFilename = attributes.getString(R.styleable.XMLFontIconButton_font_file);
        if (fontFilename != null) {
            this.setFontFile(fontFilename);
        }
        textSize = attributes.getDimensionPixelSize(R.styleable.XMLFontIconButton_text_size, textSize);
        this.setTextSize(textSize);
        ColorStateList textColor = attributes.getColorStateList(R.styleable.XMLFontIconButton_text_color);
        if (textColor != null) {
            this.setTextColor(textColor);
        }
        String iconCharacter = attributes.getString(R.styleable.XMLFontIconButton_icon_character);
        this.setIconCharacter(iconCharacter);
        String iconFontFilename = attributes.getString(R.styleable.XMLFontIconButton_icon_font_file);
        if (iconFontFilename != null) {
            this.setIconFontFile(iconFontFilename);
        }
        iconSize = attributes.getDimensionPixelSize(R.styleable.XMLFontIconButton_icon_size, iconSize);
        this.setIconSize(iconSize);
        ColorStateList iconColor = attributes.getColorStateList(R.styleable.XMLFontIconButton_icon_color);
        if (iconColor != null) {
            this.setIconColor(iconColor);
        }
        iconPosition = attributes.getInt(R.styleable.XMLFontIconButton_icon_position, iconPosition);
        this.setIconPosition(iconPosition);
        iconPadding = attributes.getDimensionPixelSize(R.styleable.XMLFontIconButton_icon_padding, iconPadding);
        this.setIconPadding(iconPadding);
        attributes.recycle();
    }

    public void setFontFile(String filename) {
        this.fontFile = filename;
        this.mainTextView.setFontFile(filename);
        this.invalidate();
    }

    public String getFontFile() {
        return this.fontFile;
    }

    public void setTextSize(float size) {
        this.mainTextView.setTextSize(size);
        this.invalidate();
    }

    public void setText(CharSequence text) {
        this.text = text;
        this.mainTextView.setText(text);
        this.invalidate();
    }

    public CharSequence getText() {
        return this.text;
    }

    public void setTextColor(@NonNull ColorStateList color) {
        this.mainTextView.setTextColor(color);
        this.invalidate();
    }

    public void setIconCharacter(CharSequence character) {
        this.iconCharacter = character;
        this.leftIconView.setText(character);
        this.rightIconView.setText(character);
        this.topIconView.setText(character);
        this.bottomIconView.setText(character);
        this.invalidate();
    }

    public CharSequence getIconCharacter() {
        return this.iconCharacter;
    }

    public void setIconColor(@NonNull ColorStateList color) {
        this.leftIconView.setTextColor(color);
        this.rightIconView.setTextColor(color);
        this.topIconView.setTextColor(color);
        this.bottomIconView.setTextColor(color);
        this.invalidate();
    }

    public void setIconFontFile(String filename) {
        this.iconFontFile = filename;
        this.leftIconView.setFontFile(filename);
        this.rightIconView.setFontFile(filename);
        this.topIconView.setFontFile(filename);
        this.bottomIconView.setFontFile(filename);
        this.invalidate();
    }

    public void setIconSize(float size) {
        this.topIconView.setTextSize(size);
        this.leftIconView.setTextSize(size);
        this.rightIconView.setTextSize(size);
        this.bottomIconView.setTextSize(size);
        this.invalidate();
    }

    public void setIconPosition(int position) {
        this.leftIconView.setVisibility(8);
        this.rightIconView.setVisibility(8);
        this.topIconView.setVisibility(8);
        this.bottomIconView.setVisibility(8);
        switch (position) {
            case 0: {
                this.leftIconView.setVisibility(0);
                break;
            }
            case 1: {
                this.rightIconView.setVisibility(0);
                break;
            }
            case 2: {
                this.topIconView.setVisibility(0);
                break;
            }
            case 3: {
                this.bottomIconView.setVisibility(0);
            }
        }
        this.invalidate();
    }

    public void setIconPadding(int padding) {
        this.leftIconView.setPadding(padding, padding, padding, padding);
        this.rightIconView.setPadding(padding, padding, padding, padding);
        this.topIconView.setPadding(padding, padding, padding, padding);
        this.bottomIconView.setPadding(padding, padding, padding, padding);
        this.invalidate();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IconPosition {
    }
}

