/*
 * Decompiled with CFR 0.152.
 */
package com.sumitanantwar.android.xml_font_views;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.RadioButton;
import com.sumitanantwar.android.xml_font_views.FontManager;
import com.sumitanantwar.android.xml_font_views.R;

public class XMLFontRadioButton
extends RadioButton {
    private final Context mContext;
    private String mFontFile;

    public XMLFontRadioButton(Context context) {
        this(context, null);
    }

    public XMLFontRadioButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initWithAttributes(attrs, 0);
    }

    public XMLFontRadioButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initWithAttributes(attrs, defStyleAttr);
    }

    private void initWithAttributes(AttributeSet attrs, int defStyleAttr) {
        TypedArray attributes = this.mContext.getTheme().obtainStyledAttributes(attrs, R.styleable.XMLFontRadioButton, defStyleAttr, 0);
        String fontFilename = attributes.getString(R.styleable.XMLFontRadioButton_font_file);
        if (fontFilename != null) {
            this.setFontFile(fontFilename);
        }
        attributes.recycle();
    }

    public void setFontFile(String filename) {
        this.mFontFile = filename;
        this.setTypeface(FontManager.getTypeFaceForFont(this.mContext, filename));
    }

    public String getFontFile() {
        return this.mFontFile;
    }
}

