/*
 * Decompiled with CFR 0.152.
 */
package com.sumitanantwar.android.xml_font_views;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.sumitanantwar.android.xml_font_views.R;
import com.sumitanantwar.android.xml_font_views.XMLFontTextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class XMLFontIconButton
extends FrameLayout {
    private final Context mContext;
    private CharSequence mText;
    private String mFontFile;
    private CharSequence mIconCharacter;
    private String mIconFontFile;
    private XMLFontTextView mTopIconView;
    private XMLFontTextView mLeftIconView;
    private XMLFontTextView mRightIconView;
    private XMLFontTextView mBottomIconView;
    private XMLFontTextView mMainTextView;
    public static final int ICON_POSITION_LEFT = 0;
    public static final int ICON_POSITION_RIGHT = 1;
    public static final int ICON_POSITION_TOP = 2;
    public static final int ICON_POSITION_BOTTOM = 3;

    public XMLFontIconButton(Context context) {
        this(context, null);
    }

    public XMLFontIconButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public XMLFontIconButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initWithAttributes(attrs, defStyleAttr);
    }

    private void initWithAttributes(AttributeSet attrs, int defStyleAttr) {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        View view = XMLFontIconButton.inflate((Context)this.mContext, (int)R.layout.layout_xml_font_icon_button, null);
        this.mLeftIconView = (XMLFontTextView)view.findViewById(R.id.FIB_LeftIcon);
        this.mRightIconView = (XMLFontTextView)view.findViewById(R.id.FIB_RightIcon);
        this.mTopIconView = (XMLFontTextView)view.findViewById(R.id.FIB_TopIcon);
        this.mBottomIconView = (XMLFontTextView)view.findViewById(R.id.FIB_BottomIcon);
        this.mMainTextView = (XMLFontTextView)view.findViewById(R.id.FIB_MainText);
        view.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView(view);
        int textSize = 15;
        int iconSize = 25;
        int iconPosition = 0;
        int iconPadding = 10;
        TypedArray attributes = this.mContext.getTheme().obtainStyledAttributes(attrs, R.styleable.XMLFontIconButton, defStyleAttr, 0);
        String mainText = attributes.getString(R.styleable.XMLFontIconButton_text);
        this.setText(mainText);
        String fontFilename = attributes.getString(R.styleable.XMLFontIconButton_font_file);
        if (fontFilename != null) {
            this.setFontFile(fontFilename);
        }
        textSize = attributes.getDimensionPixelSize(R.styleable.XMLFontIconButton_text_size, textSize);
        this.setTextSize(textSize);
        ColorStateList textColor = attributes.getColorStateList(R.styleable.XMLFontIconButton_text_color);
        if (textColor != null) {
            this.setTextColor(textColor);
        }
        String iconCharacter = attributes.getString(R.styleable.XMLFontIconButton_icon_character);
        this.setIconCharacter(iconCharacter);
        String iconFontFilename = attributes.getString(R.styleable.XMLFontIconButton_icon_font_file);
        if (iconFontFilename != null) {
            this.setIconFontFile(iconFontFilename);
        }
        iconSize = attributes.getDimensionPixelSize(R.styleable.XMLFontIconButton_icon_size, iconSize);
        this.setIconSize(iconSize);
        ColorStateList iconColor = attributes.getColorStateList(R.styleable.XMLFontIconButton_icon_color);
        if (iconColor != null) {
            this.setIconColor(iconColor);
        }
        iconPosition = attributes.getInt(R.styleable.XMLFontIconButton_icon_position, iconPosition);
        this.setIconPosition(iconPosition);
        iconPadding = attributes.getDimensionPixelSize(R.styleable.XMLFontIconButton_icon_padding, iconPadding);
        this.setIconPadding(iconPadding);
        attributes.recycle();
    }

    public void setFontFile(String filename) {
        this.mFontFile = filename;
        this.mMainTextView.setFontFile(filename);
        this.invalidate();
    }

    public String getFontFile() {
        return this.mFontFile;
    }

    public void setTextSize(float size) {
        this.mMainTextView.setTextSize(size);
        this.invalidate();
    }

    public void setText(CharSequence text) {
        this.mText = text;
        this.mMainTextView.setText(text);
        this.invalidate();
    }

    public CharSequence getText() {
        return this.mText;
    }

    public void setTextColor(@NonNull ColorStateList color) {
        this.mMainTextView.setTextColor(color);
        this.invalidate();
    }

    public void setIconCharacter(CharSequence character) {
        this.mIconCharacter = character;
        this.mLeftIconView.setText(character);
        this.mRightIconView.setText(character);
        this.mTopIconView.setText(character);
        this.mBottomIconView.setText(character);
        this.invalidate();
    }

    public CharSequence getIconCharacter() {
        return this.mIconCharacter;
    }

    public void setIconColor(@NonNull ColorStateList color) {
        this.mLeftIconView.setTextColor(color);
        this.mRightIconView.setTextColor(color);
        this.mTopIconView.setTextColor(color);
        this.mBottomIconView.setTextColor(color);
        this.invalidate();
    }

    public void setIconFontFile(String filename) {
        this.mIconFontFile = filename;
        this.mLeftIconView.setFontFile(filename);
        this.mRightIconView.setFontFile(filename);
        this.mTopIconView.setFontFile(filename);
        this.mBottomIconView.setFontFile(filename);
        this.invalidate();
    }

    public void setIconSize(float size) {
        this.mTopIconView.setTextSize(size);
        this.mLeftIconView.setTextSize(size);
        this.mRightIconView.setTextSize(size);
        this.mBottomIconView.setTextSize(size);
        this.invalidate();
    }

    public void setIconPosition(int position) {
        this.mLeftIconView.setVisibility(8);
        this.mRightIconView.setVisibility(8);
        this.mTopIconView.setVisibility(8);
        this.mBottomIconView.setVisibility(8);
        switch (position) {
            case 0: {
                this.mLeftIconView.setVisibility(0);
                break;
            }
            case 1: {
                this.mRightIconView.setVisibility(0);
                break;
            }
            case 2: {
                this.mTopIconView.setVisibility(0);
                break;
            }
            case 3: {
                this.mBottomIconView.setVisibility(0);
            }
        }
        this.invalidate();
    }

    public void setIconPadding(int padding) {
        this.mLeftIconView.setPadding(padding, padding, padding, padding);
        this.mRightIconView.setPadding(padding, padding, padding, padding);
        this.mTopIconView.setPadding(padding, padding, padding, padding);
        this.mBottomIconView.setPadding(padding, padding, padding, padding);
        this.invalidate();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IconPosition {
    }
}

