/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.DeploymentElement;
import com.structurizr.model.HttpHealthCheck;
import com.structurizr.model.InfrastructureNode;
import com.structurizr.model.InteractionStyle;
import com.structurizr.model.Relationship;
import com.structurizr.model.StaticStructureElement;
import com.structurizr.util.StringUtils;
import com.structurizr.util.Url;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class StaticStructureElementInstance
extends DeploymentElement {
    private static final int DEFAULT_HEALTH_CHECK_INTERVAL_IN_SECONDS = 60;
    private static final long DEFAULT_HEALTH_CHECK_TIMEOUT_IN_MILLISECONDS = 0L;
    private Set<String> deploymentGroups = new HashSet<String>();
    private int instanceId;
    private Set<HttpHealthCheck> healthChecks = new HashSet<HttpHealthCheck>();

    StaticStructureElementInstance() {
    }

    StaticStructureElementInstance(int instanceId, String environment, String ... deploymentGroups) {
        this.setInstanceId(instanceId);
        this.setEnvironment(environment);
        if (deploymentGroups != null) {
            for (String deploymentGroup : deploymentGroups) {
                if (StringUtils.isNullOrEmpty(deploymentGroup)) continue;
                this.deploymentGroups.add(deploymentGroup.trim());
            }
        }
        if (this.deploymentGroups.isEmpty()) {
            this.deploymentGroups.add("Default");
        }
    }

    @JsonIgnore
    public abstract StaticStructureElement getElement();

    public Set<String> getDeploymentGroups() {
        if (this.deploymentGroups.isEmpty()) {
            return Collections.singleton("Default");
        }
        return new HashSet<String>(this.deploymentGroups);
    }

    void setDeploymentGroups(Set<String> deploymentGroups) {
        this.deploymentGroups = deploymentGroups != null ? new HashSet<String>(deploymentGroups) : new HashSet<String>();
    }

    void setDeploymentGroup(String deploymentGroup) {
        this.deploymentGroups = Collections.singleton(deploymentGroup);
    }

    boolean inSameDeploymentGroup(StaticStructureElementInstance ssei) {
        for (String deploymentGroup : this.getDeploymentGroups()) {
            if (!ssei.getDeploymentGroups().contains(deploymentGroup)) continue;
            return true;
        }
        return false;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    void setInstanceId(int instanceId) {
        this.instanceId = instanceId;
    }

    @Override
    @JsonIgnore
    public Set<String> getDefaultTags() {
        return Collections.emptySet();
    }

    @Override
    public boolean removeTag(String tag) {
        return false;
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.getElement().getName();
    }

    @Override
    public void setName(String name) {
    }

    @Nonnull
    public Set<HttpHealthCheck> getHealthChecks() {
        return new HashSet<HttpHealthCheck>(this.healthChecks);
    }

    void setHealthChecks(Set<HttpHealthCheck> healthChecks) {
        this.healthChecks = healthChecks;
    }

    @Nonnull
    public HttpHealthCheck addHealthCheck(String name, String url) {
        return this.addHealthCheck(name, url, 60, 0L);
    }

    @Nonnull
    public HttpHealthCheck addHealthCheck(String name, String url, int interval, long timeout) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("The name must not be null or empty.");
        }
        if (url == null || url.trim().length() == 0) {
            throw new IllegalArgumentException("The URL must not be null or empty.");
        }
        if (!Url.isUrl(url)) {
            throw new IllegalArgumentException(url + " is not a valid URL.");
        }
        if (interval < 0) {
            throw new IllegalArgumentException("The polling interval must be zero or a positive integer.");
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("The timeout must be zero or a positive integer.");
        }
        HttpHealthCheck healthCheck = new HttpHealthCheck(name, url, interval, timeout);
        this.healthChecks.add(healthCheck);
        return healthCheck;
    }

    public Relationship uses(InfrastructureNode destination, String description, String technology) {
        return this.uses(destination, description, technology, null);
    }

    public Relationship uses(InfrastructureNode destination, String description, String technology, InteractionStyle interactionStyle) {
        return this.uses(destination, description, technology, interactionStyle, new String[0]);
    }

    public Relationship uses(InfrastructureNode destination, String description, String technology, InteractionStyle interactionStyle, String[] tags) {
        return this.getModel().addRelationship(this, destination, description, technology, interactionStyle, tags);
    }
}

