// Generated by delombok at Wed Nov 28 11:15:52 EST 2018
package com.stripe.model;

import com.stripe.exception.InvalidRequestException;
import com.stripe.exception.StripeException;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import java.util.HashMap;
import java.util.Map;

public class UsageRecord extends ApiResource implements HasId {
  String id;
  String object;
  Boolean livemode;
  Long quantity;
  String subscriptionItem;
  Long timestamp;

  // <editor-fold desc="create">
  /**
   * Create a new usage record associated with a subscription item.
   * @param params The quantity, the timestamp and the conflict behaviour (action)
   * @param options Request options
   * @return The created usage record
   */
  public static UsageRecord create(Map<String, Object> params, RequestOptions options) throws StripeException {
    String subscriptionItem = (String) params.get("subscription_item");
    if (subscriptionItem == null) {
      throw new InvalidRequestException("The params object must contain a subscription_item element", "subscription_item", null, null, null, null);
    }
    Map<String, Object> requestParams = new HashMap<String, Object>(params);
    requestParams.remove("subscription_item");
    return request(RequestMethod.POST, subresourceUrl(SubscriptionItem.class, subscriptionItem, UsageRecord.class), requestParams, UsageRecord.class, options);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getObject() {
    return this.object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getLivemode() {
    return this.livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getQuantity() {
    return this.quantity;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSubscriptionItem() {
    return this.subscriptionItem;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Long getTimestamp() {
    return this.timestamp;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setId(final String id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setObject(final String object) {
    this.object = object;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLivemode(final Boolean livemode) {
    this.livemode = livemode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setQuantity(final Long quantity) {
    this.quantity = quantity;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSubscriptionItem(final String subscriptionItem) {
    this.subscriptionItem = subscriptionItem;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTimestamp(final Long timestamp) {
    this.timestamp = timestamp;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof UsageRecord)) return false;
    final UsageRecord other = (UsageRecord) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$id = this.getId();
    final java.lang.Object other$id = other.getId();
    if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
    final java.lang.Object this$object = this.getObject();
    final java.lang.Object other$object = other.getObject();
    if (this$object == null ? other$object != null : !this$object.equals(other$object)) return false;
    final java.lang.Object this$livemode = this.getLivemode();
    final java.lang.Object other$livemode = other.getLivemode();
    if (this$livemode == null ? other$livemode != null : !this$livemode.equals(other$livemode)) return false;
    final java.lang.Object this$quantity = this.getQuantity();
    final java.lang.Object other$quantity = other.getQuantity();
    if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) return false;
    final java.lang.Object this$subscriptionItem = this.getSubscriptionItem();
    final java.lang.Object other$subscriptionItem = other.getSubscriptionItem();
    if (this$subscriptionItem == null ? other$subscriptionItem != null : !this$subscriptionItem.equals(other$subscriptionItem)) return false;
    final java.lang.Object this$timestamp = this.getTimestamp();
    final java.lang.Object other$timestamp = other.getTimestamp();
    if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof UsageRecord;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $id = this.getId();
    result = result * PRIME + ($id == null ? 43 : $id.hashCode());
    final java.lang.Object $object = this.getObject();
    result = result * PRIME + ($object == null ? 43 : $object.hashCode());
    final java.lang.Object $livemode = this.getLivemode();
    result = result * PRIME + ($livemode == null ? 43 : $livemode.hashCode());
    final java.lang.Object $quantity = this.getQuantity();
    result = result * PRIME + ($quantity == null ? 43 : $quantity.hashCode());
    final java.lang.Object $subscriptionItem = this.getSubscriptionItem();
    result = result * PRIME + ($subscriptionItem == null ? 43 : $subscriptionItem.hashCode());
    final java.lang.Object $timestamp = this.getTimestamp();
    result = result * PRIME + ($timestamp == null ? 43 : $timestamp.hashCode());
    return result;
  }

  @Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getId() {
    return this.id;
  }
  // </editor-fold>
}
